/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.worldwindow.core;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwindx.applications.worldwindow.core.Controller;
import gov.nasa.worldwindx.applications.worldwindow.core.Initializable;
import gov.nasa.worldwindx.applications.worldwindow.core.Registry;
import gov.nasa.worldwindx.applications.worldwindow.core.ToolBar;
import gov.nasa.worldwindx.applications.worldwindow.features.AbstractFeature;
import gov.nasa.worldwindx.applications.worldwindow.features.Feature;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;

public class ToolBarImpl
extends AbstractFeature
implements ToolBar {
    private GradientToolBar toolBar;

    public ToolBarImpl(Registry registry) {
        super("Tool Bar", "gov.nasa.worldwindx.applications.worldwindow.ToolBar", registry);
    }

    @Override
    public void initialize(Controller controller) {
        this.toolBar = new GradientToolBar();
        this.toolBar.setLayout(new GridLayout(1, 0));
        this.toolBar.setRollover(false);
        this.toolBar.setFloatable(false);
        this.toolBar.initialize(controller);
        this.toolBar.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                for (Component component : ToolBarImpl.this.toolBar.getComponents()) {
                    if (!(component instanceof ToolBarButton)) continue;
                    ((ToolBarButton)component).updateSize();
                }
            }
        });
    }

    @Override
    public JToolBar getJToolBar() {
        return this.toolBar;
    }

    @Override
    public void addFeature(Feature feature) {
        ToolBarButton toolBarButton = new ToolBarButton(feature);
        toolBarButton.initialize(this.controller);
        this.toolBar.add(toolBarButton);
    }

    public static class ToolBarButton
    extends JButton
    implements Initializable {
        protected boolean initialized = false;
        protected ImageIcon originalIcon;
        protected ImageIcon currentIcon;
        protected int iconSize = Configuration.getIntegerValue("gov.nasa.worldwindx.applications.worldwindow.ToolBarIconSizeProperty", 52);

        public ToolBarButton(Feature feature) {
            super(feature);
            this.setOpaque(false);
            this.originalIcon = (ImageIcon)feature.getValue("SwingLargeIconKey");
            this.setIconSize(this.iconSize + this.getInsets().left + this.getInsets().right);
            if (feature.getValue("gov.nasa.worldwindx.applications.worldwindow.ActionCommand") != null) {
                this.setActionCommand((String)feature.getValue("gov.nasa.worldwindx.applications.worldwindow.ActionCommand"));
            }
        }

        @Override
        public void initialize(Controller controller) {
            this.getFeature().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ToolBarButton.this.repaint();
                }
            });
            this.initialized = true;
        }

        @Override
        public boolean isInitialized() {
            return this.initialized;
        }

        public Feature getFeature() {
            return (Feature)this.getAction();
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.getFeature().isOn()) {
                this.drawDot(graphics);
            }
        }

        private void drawDot(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = ((Graphics2D)graphics).getPaint();
            float f = 3.0f;
            float f2 = (float)this.getWidth() / 2.0f - f;
            float f3 = 1.0f;
            float f4 = (float)this.getWidth() / 2.0f - 1.0f;
            float f5 = f3 + f - 1.0f;
            RadialGradientPaint radialGradientPaint = new RadialGradientPaint(f4, f5, f, new float[]{0.0f, 1.0f}, new Color[]{Color.WHITE, Color.GREEN});
            graphics2D.setPaint(radialGradientPaint);
            Ellipse2D.Float float_ = new Ellipse2D.Float(f2, f3, 2.0f * f, 2.0f * f);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.fill(float_);
            graphics2D.setPaint(paint);
        }

        public void updateSize() {
            this.setIconSize(this.getWidth());
        }

        public void setIconSize(int n) {
            if (this.currentIcon != null && this.currentIcon.getIconWidth() == (n -= this.getInsets().left + this.getInsets().right) && this.currentIcon.getIconHeight() == n) {
                return;
            }
            n = Math.min(52, n);
            n = Math.max(16, n);
            this.currentIcon = new ImageIcon(this.originalIcon.getImage().getScaledInstance(n, n, 4));
            this.getAction().putValue("SwingLargeIconKey", this.currentIcon);
        }
    }

    public static class GradientToolBar
    extends JToolBar
    implements Initializable {
        private ToolBarButton rolloverComponent;
        private MouseListener mouseListener;

        public GradientToolBar() {
            this.setOpaque(false);
            this.setBorderPainted(false);
        }

        @Override
        public void initialize(Controller controller) {
            this.mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (mouseEvent.getSource() instanceof ToolBarButton) {
                        GradientToolBar.this.rolloverComponent = (ToolBarButton)mouseEvent.getSource();
                    } else {
                        GradientToolBar.this.rolloverComponent = null;
                    }
                    GradientToolBar.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    GradientToolBar.this.rolloverComponent = null;
                    GradientToolBar.this.repaint();
                }
            };
        }

        @Override
        public boolean isInitialized() {
            return this.mouseListener != null;
        }

        public void add(ToolBarButton toolBarButton) {
            toolBarButton.setBorderPainted(false);
            toolBarButton.setOpaque(false);
            toolBarButton.setHideActionText(true);
            toolBarButton.addMouseListener(this.mouseListener);
            super.add(toolBarButton);
        }

        public void setRolloverComponent(Component component) {
            ToolBarButton toolBarButton = this.rolloverComponent = component != null && component instanceof ToolBarButton ? (ToolBarButton)component : null;
            if (this.rolloverComponent != null) {
                this.repaint();
            }
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, new Color(7047624), 0.0f, this.getHeight(), new Color(0));
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(gradientPaint);
            graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics2D.setPaint(paint);
        }

        @Override
        protected void paintChildren(Graphics graphics) {
            super.paintChildren(graphics);
            if (this.rolloverComponent != null) {
                this.drawButtonLabel(this.rolloverComponent, (Graphics2D)graphics);
            }
        }

        public void drawButtonLabel(ToolBarButton toolBarButton, Graphics2D graphics2D) {
            Paint paint = graphics2D.getPaint();
            Font font = Font.decode("Arial-Bold-14");
            graphics2D.setFont(font);
            Rectangle2D rectangle2D = graphics2D.getFontMetrics().getStringBounds(toolBarButton.getActionCommand(), graphics2D);
            double d = toolBarButton.getLocation().x + 1;
            double d2 = (double)(toolBarButton.getLocation().y + toolBarButton.getHeight()) - (rectangle2D.getHeight() + 4.0);
            double d3 = d + rectangle2D.getX() + 10.0;
            double d4 = d2 + rectangle2D.getHeight();
            LinearGradientPaint linearGradientPaint = new LinearGradientPaint(new Point2D.Double(d, d2), new Point2D.Double(d, d2 + rectangle2D.getHeight()), new float[]{0.0f, 1.0f}, new Color[]{Color.BLACK, new Color(50, 50, 50)}, MultipleGradientPaint.CycleMethod.NO_CYCLE);
            graphics2D.setPaint(linearGradientPaint);
            RoundRectangle2D.Double double_ = new RoundRectangle2D.Double(d, d2, rectangle2D.getWidth() + 20.0, rectangle2D.getHeight() + 4.0, 20.0, 20.0);
            graphics2D.fill(double_);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.drawString(toolBarButton.getActionCommand(), (float)d3, (float)d4);
            graphics2D.setPaint(paint);
        }
    }
}

