/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar.tracks;

import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.exception.WWUnrecognizedException;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwindx.applications.sar.tracks.TrackReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;

public abstract class AbstractTrackReader
implements TrackReader {
    protected abstract Track[] doRead(InputStream var1) throws IOException;

    @Override
    public boolean canRead(Object object) {
        return object != null && this.doCanRead(object);
    }

    @Override
    public Track[] read(Object object) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.SourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        try {
            return this.doRead(object);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("generic.ExceptionAttemptingToReadFrom", object);
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, iOException);
        }
        catch (WWUnrecognizedException wWUnrecognizedException) {
            String string = Logging.getMessage("generic.UnrecognizedSourceType", wWUnrecognizedException.getMessage());
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, wWUnrecognizedException);
        }
    }

    protected boolean doCanRead(Object object) {
        if (object instanceof File) {
            return this.doCanRead(((File)object).getPath());
        }
        if (object instanceof String) {
            return this.doCanRead((String)object);
        }
        if (object instanceof URL) {
            return this.doCanRead((URL)object);
        }
        if (object instanceof InputStream) {
            return this.doCanRead((InputStream)object);
        }
        return false;
    }

    protected boolean doCanRead(String string) {
        if (!this.acceptFilePath(string)) {
            return false;
        }
        try {
            return this.doRead(string) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean doCanRead(URL uRL) {
        File file = WWIO.convertURLToFile(uRL);
        if (file != null) {
            return this.doCanRead(file.getPath());
        }
        try {
            return this.doRead(uRL) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean doCanRead(InputStream inputStream) {
        try {
            return this.doRead(inputStream) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean acceptFilePath(String string) {
        return true;
    }

    protected Track[] doRead(Object object) throws IOException {
        if (object instanceof File) {
            return this.doRead(((File)object).getPath());
        }
        if (object instanceof String) {
            return this.doRead((String)object);
        }
        if (object instanceof URL) {
            return this.doRead((URL)object);
        }
        if (object instanceof InputStream) {
            return this.doRead((InputStream)object);
        }
        throw new WWUnrecognizedException(object.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Track[] doRead(String string) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = WWIO.openFileOrResourceStream(string, this.getClass());
            Track[] trackArray = this.doRead(inputStream);
            return trackArray;
        }
        finally {
            WWIO.closeStream(inputStream, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Track[] doRead(URL uRL) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Track[] trackArray = this.doRead(inputStream);
            return trackArray;
        }
        finally {
            WWIO.closeStream(inputStream, uRL.toString());
        }
    }

    protected Track[] asArray(List<Track> list) {
        if (list == null) {
            return null;
        }
        Track[] trackArray = new Track[list.size()];
        list.toArray(trackArray);
        return trackArray;
    }
}

