/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.util.BasicDragger;
import gov.nasa.worldwind.view.orbit.OrbitView;
import gov.nasa.worldwindx.applications.sar.SAR2;
import gov.nasa.worldwindx.applications.sar.SARAnnotation;
import gov.nasa.worldwindx.applications.sar.SARAnnotationReader;
import gov.nasa.worldwindx.applications.sar.SARAnnotationWriter;
import gov.nasa.worldwindx.applications.sar.SARTrack;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class SARAnnotationSupport {
    private AnnotationLayer annotationLayer = new AnnotationLayer();
    private AnnotationAttributes defaults;
    private WorldWindow wwd;
    private SARAnnotation lastPickedObject;
    private SARAnnotation currentAnnotation;
    private ScreenAnnotation helpMessageAnnotation = new ScreenAnnotation("", new Point(0, 0));
    private Color savedBorderColor;
    private String angleFormat;

    public SARAnnotationSupport() {
        this.helpMessageAnnotation.getAttributes().setFrameShape("gov.nasa.worldwind.avkey.ShapeNone");
        this.helpMessageAnnotation.getAttributes().setInsets(new Insets(0, 0, 0, 0));
        this.helpMessageAnnotation.getAttributes().setDrawOffset(new Point(0, -20));
        this.helpMessageAnnotation.getAttributes().setTextAlign("gov.nasa.worldwind.avkey.Center");
        this.helpMessageAnnotation.getAttributes().setEffect("gov.nasa.worldwind.avkey.TextEffectOutline");
        this.helpMessageAnnotation.getAttributes().setFont(Font.decode("Arial-Bold-14"));
        this.helpMessageAnnotation.getAttributes().setTextColor(Color.YELLOW);
        this.helpMessageAnnotation.getAttributes().setBackgroundColor(Color.BLACK);
        this.helpMessageAnnotation.getAttributes().setSize(new Dimension(220, 0));
        this.annotationLayer.addAnnotation(this.helpMessageAnnotation);
        this.defaults = new AnnotationAttributes();
        this.defaults.setHighlightScale(1.1);
    }

    public void setWwd(WorldWindow worldWindow) {
        this.wwd = worldWindow;
        this.wwd.getModel().getLayers().add(this.annotationLayer);
        this.wwd.addSelectListener(new SelectListener(){
            private BasicDragger dragger;
            {
                this.dragger = new BasicDragger(SARAnnotationSupport.this.wwd);
            }

            @Override
            public void selected(SelectEvent selectEvent) {
                if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                    if (selectEvent.hasObjects() && selectEvent.getTopObject() instanceof Annotation) {
                        PickedObject pickedObject = selectEvent.getTopPickedObject();
                        if (pickedObject.getValue("gov.nasa.worldwind.avkey.Text") != null) {
                            // empty if block
                        }
                        SARAnnotationSupport.this.select(selectEvent.getTopObject());
                    }
                } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftDoubleClick")) {
                    if (selectEvent.hasObjects() && selectEvent.getTopObject() instanceof Annotation) {
                        SARAnnotationSupport.this.edit((SARAnnotation)selectEvent.getTopObject());
                    }
                } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !this.dragger.isDragging()) {
                    SARAnnotationSupport.this.highlight(selectEvent.getTopObject());
                } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
                    PickedObjectList pickedObjectList;
                    if (selectEvent.hasObjects() && selectEvent.getTopObject() == SARAnnotationSupport.this.currentAnnotation) {
                        this.dragger.selected(selectEvent);
                        SARAnnotationSupport.this.updateHelpMessage(SARAnnotationSupport.this.currentAnnotation);
                        if (SARAnnotationSupport.this.currentAnnotation.getOwner() != null) {
                            SARAnnotationSupport.this.currentAnnotation.getOwner().markDirty();
                        }
                    }
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = SARAnnotationSupport.this.wwd.getObjectsAtCurrentPosition()) != null) {
                        SARAnnotationSupport.this.highlight(pickedObjectList.getTopObject());
                        SARAnnotationSupport.this.wwd.redraw();
                    }
                }
            }
        });
        this.wwd.getInputHandler().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SARAnnotationSupport.this.currentAnnotation != null && mouseEvent.getButton() == 1) {
                    SARAnnotationSupport.this.select(null);
                    mouseEvent.consume();
                    SARAnnotationSupport.this.getWwd().redraw();
                }
            }
        });
        this.wwd.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "AngleFormat") {
                    SARAnnotationSupport.this.setAngleFormat((String)propertyChangeEvent.getNewValue());
                }
            }
        });
    }

    public WorldWindow getWwd() {
        return this.wwd;
    }

    public String getAngleFormat() {
        return this.angleFormat;
    }

    public void setAngleFormat(String string) {
        this.angleFormat = string;
        this.updateHelpMessage(this.lastPickedObject);
    }

    private void select(Object object) {
        if (this.currentAnnotation != null) {
            this.currentAnnotation.getAttributes().setBorderColor(this.savedBorderColor);
        }
        if (object != null && object instanceof SARAnnotation && this.currentAnnotation != object) {
            this.currentAnnotation = (SARAnnotation)object;
            this.savedBorderColor = this.currentAnnotation.getAttributes().getBorderColor();
            this.currentAnnotation.getAttributes().setBorderColor(Color.YELLOW);
        } else {
            this.currentAnnotation = null;
        }
    }

    private void highlight(Object object) {
        if (this.lastPickedObject == object) {
            return;
        }
        if (this.lastPickedObject != null) {
            this.lastPickedObject.getAttributes().setHighlighted(false);
            this.lastPickedObject = null;
            this.updateHelpMessage(null);
        }
        if (object != null && object instanceof SARAnnotation) {
            this.lastPickedObject = (SARAnnotation)object;
            this.lastPickedObject.getAttributes().setHighlighted(true);
            this.updateHelpMessage(this.lastPickedObject);
        }
    }

    private void updateHelpMessage(SARAnnotation sARAnnotation) {
        if (sARAnnotation != null) {
            Object object;
            Position position = sARAnnotation.getPosition();
            this.helpMessageAnnotation.getAttributes().setVisible(true);
            this.helpMessageAnnotation.setText(String.format("Lat %s Lon %s", SAR2.formatAngle(this.angleFormat, position.getLatitude()), SAR2.formatAngle(this.angleFormat, position.getLongitude())));
            Vec4 vec4 = this.getWwd().getSceneController().getTerrain().getSurfacePoint(position.getLatitude(), position.getLongitude());
            if (vec4 == null) {
                object = this.getWwd().getModel().getGlobe();
                vec4 = object.computePointFromPosition(position.getLatitude(), position.getLongitude(), object.getElevation(position.getLatitude(), position.getLongitude()));
            }
            if ((object = this.getWwd().getView().project(vec4)) != null) {
                this.helpMessageAnnotation.setScreenPoint(new Point((int)((Vec4)object).x, (int)((Vec4)object).y));
            }
        } else {
            this.helpMessageAnnotation.getAttributes().setVisible(false);
        }
    }

    public void addNew(String string, SARTrack sARTrack) {
        if (string == null) {
            string = this.showAnnotationDialog("Add New Annotation", null);
        }
        OrbitView orbitView = (OrbitView)this.wwd.getView();
        if (string != null && string.length() > 0 && orbitView != null) {
            Position position = new Position(orbitView.getCenterPosition(), 0.0);
            SARAnnotation sARAnnotation = new SARAnnotation(string, position);
            this.addNew(sARAnnotation, sARTrack);
            this.select(sARAnnotation);
        }
    }

    public void addNew(SARAnnotation sARAnnotation, SARTrack sARTrack) {
        if (sARAnnotation != null) {
            sARAnnotation.getAttributes().setDefaults(this.defaults);
            sARAnnotation.getAttributes().setDistanceMinScale(0.7);
            sARAnnotation.getAttributes().setDistanceMaxScale(1.3);
            if (sARTrack != null) {
                sARAnnotation.setOwner(sARTrack);
                sARAnnotation.getAttributes().setTextColor(sARTrack.getColor());
            }
            this.add(sARAnnotation);
        }
    }

    private String showAnnotationDialog(String string, String string2) {
        Object[] objectArray;
        final JTextArea jTextArea = new JTextArea(5, 10);
        if (string2 != null) {
            jTextArea.setText(string2);
        }
        jTextArea.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if ((hierarchyEvent.getChangeFlags() & 4L) != 0L && jTextArea.isShowing()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            jTextArea.requestFocus();
                        }
                    });
                }
            }
        });
        int n = -1;
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        if (string2 != null && string2.length() > 0) {
            objectArray = new Object[]{"Save", "Delete", "Cancel"};
            n = JOptionPane.showOptionDialog(null, new Object[]{"Enter text", jScrollPane}, string, 1, 3, null, objectArray, objectArray[0]);
        } else {
            n = JOptionPane.showOptionDialog(null, new Object[]{"Enter text", jScrollPane}, string, 2, 3, null, null, null);
        }
        objectArray = null;
        if (n == 0 || n == 0) {
            objectArray = jTextArea.getText();
        }
        if (n == 1) {
            objectArray = "";
        }
        return objectArray;
    }

    public void add(SARAnnotation sARAnnotation) {
        if (sARAnnotation != null) {
            this.annotationLayer.addAnnotation(sARAnnotation);
            if (sARAnnotation.getOwner() != null) {
                sARAnnotation.getOwner().markDirty();
            }
        }
    }

    public void edit(SARAnnotation sARAnnotation) {
        if (sARAnnotation != null) {
            String string = this.showAnnotationDialog("Edit Annotation", sARAnnotation.getText());
            if (string != null) {
                if (string.length() > 0) {
                    sARAnnotation.setText(string);
                    if (sARAnnotation.getOwner() != null) {
                        sARAnnotation.getOwner().markDirty();
                    }
                } else {
                    this.remove(sARAnnotation);
                }
            }
            this.wwd.redraw();
        }
    }

    public void remove(SARAnnotation sARAnnotation) {
        if (sARAnnotation != null) {
            this.annotationLayer.removeAnnotation(sARAnnotation);
            if (this.currentAnnotation == sARAnnotation) {
                this.currentAnnotation = null;
            }
            if (sARAnnotation.getOwner() != null) {
                sARAnnotation.getOwner().markDirty();
            }
        }
    }

    public void removeAnnotationsForTrack(SARTrack sARTrack) {
        for (SARAnnotation sARAnnotation : this.getAnnotationsForTrack(sARTrack)) {
            if (sARAnnotation == null) continue;
            this.remove(sARAnnotation);
        }
    }

    public SARAnnotation getCurrent() {
        return this.currentAnnotation;
    }

    public Iterable<Annotation> getAnnotations() {
        return this.annotationLayer.getAnnotations();
    }

    public Iterable<SARAnnotation> getAnnotationsForTrack(SARTrack sARTrack) {
        ArrayList<SARAnnotation> arrayList = new ArrayList<SARAnnotation>();
        for (Annotation annotation : this.annotationLayer.getAnnotations()) {
            if (annotation == null || !(annotation instanceof SARAnnotation) || sARTrack != ((SARAnnotation)annotation).getOwner()) continue;
            arrayList.add((SARAnnotation)annotation);
        }
        return arrayList;
    }

    public void setEnabled(boolean bl) {
        this.annotationLayer.setEnabled(bl);
    }

    public boolean getEnabled() {
        return this.annotationLayer.isEnabled();
    }

    public AnnotationAttributes getDefaults() {
        return this.defaults;
    }

    public void writeAnnotations(String string, SARTrack sARTrack) throws IOException {
        try {
            if (string != null) {
                SARAnnotationWriter sARAnnotationWriter = new SARAnnotationWriter(string);
                sARAnnotationWriter.writeAnnotations(this.getAnnotationsForTrack(sARTrack));
                sARAnnotationWriter.close();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalArgumentException(parserConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new IllegalArgumentException(transformerException);
        }
    }

    public void readAnnotations(String string, SARTrack sARTrack) throws IOException {
        try {
            if (string != null) {
                SARAnnotationReader sARAnnotationReader = new SARAnnotationReader();
                sARAnnotationReader.readFile(string);
                for (SARAnnotation sARAnnotation : sARAnnotationReader.getSARAnnotations()) {
                    this.addNew(sARAnnotation, sARTrack);
                }
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalArgumentException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException(sAXException);
        }
    }
}

