/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwindx.applications.sar.ElementParser;
import gov.nasa.worldwindx.applications.sar.SARAnnotation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SARAnnotationReader {
    private SAXParser parser;
    private List<SARAnnotation> sarAnnotations = new ArrayList<SARAnnotation>();

    public SARAnnotationReader() throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        this.parser = sAXParserFactory.newSAXParser();
    }

    public void readFile(String string) throws IOException, SAXException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", string);
            Logging.logger().severe(string3);
            throw new FileNotFoundException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.doRead(fileInputStream);
    }

    public void readStream(InputStream inputStream) throws IOException, SAXException {
        if (inputStream == null) {
            String string = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.doRead(inputStream);
    }

    public List<SARAnnotation> getSARAnnotations() {
        return this.sarAnnotations;
    }

    private void doRead(InputStream inputStream) throws IOException, SAXException {
        this.parser.parse(inputStream, (DefaultHandler)new Handler());
    }

    private class SARAnnotationElement
    extends ElementParser {
        private double latitutde;
        private double longitude;
        private String id;
        private String text;

        public SARAnnotationElement(String string, String string2, String string3, Attributes attributes) {
            super("sarAnnotation");
        }

        public SARAnnotation getSARAnnotation() {
            Position position = Position.fromDegrees(this.latitutde, this.longitude, 0.0);
            SARAnnotation sARAnnotation = new SARAnnotation(this.text, position);
            sARAnnotation.setId(this.id);
            return sARAnnotation;
        }

        @Override
        public void doStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        }

        @Override
        public void doEndElement(String string, String string2, String string3) throws SAXException {
            if (string2 == null) {
                String string4 = Logging.getMessage("nullValue.LNameIsNull");
                Logging.logger().severe(string4);
                throw new IllegalArgumentException(string4);
            }
            if (string2.equalsIgnoreCase("latitude")) {
                this.latitutde = Double.parseDouble(this.currentCharacters);
            } else if (string2.equalsIgnoreCase("longitude")) {
                this.longitude = Double.parseDouble(this.currentCharacters);
            } else if (string2.equalsIgnoreCase("id")) {
                this.id = this.currentCharacters.trim();
            } else if (string2.equalsIgnoreCase("text")) {
                this.text = this.currentCharacters.trim();
            }
        }
    }

    private class Handler
    extends DefaultHandler {
        private ElementParser currentElement = null;
        private boolean firstElement = true;

        private Handler() {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            sAXParseException.printStackTrace();
            super.warning(sAXParseException);
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            sAXParseException.printStackTrace();
            super.error(sAXParseException);
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            sAXParseException.printStackTrace();
            super.fatalError(sAXParseException);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.firstElement) {
                if (!string2.equalsIgnoreCase("sarTrackAnnotations")) {
                    throw new IllegalArgumentException("Not a SAR Track Annotations file");
                }
                this.firstElement = false;
            }
            if (this.currentElement != null) {
                this.currentElement.startElement(string, string2, string3, attributes);
            } else if (string2.equalsIgnoreCase("sarAnnotation")) {
                this.currentElement = new SARAnnotationElement(string, string2, string3, attributes);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.currentElement != null) {
                this.currentElement.endElement(string, string2, string3);
                if (string2.equalsIgnoreCase(this.currentElement.getElementName())) {
                    if (this.currentElement instanceof SARAnnotationElement) {
                        SARAnnotationReader.this.sarAnnotations.add(((SARAnnotationElement)this.currentElement).getSARAnnotation());
                    }
                    this.currentElement = null;
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.currentElement != null) {
                this.currentElement.characters(cArray, n, n2);
            }
        }
    }
}

