/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.sar;

import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.render.airspaces.Polygon;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLUtil;
import java.util.List;
import javax.media.opengl.GL2;

public class ElevationPlane
extends Polygon {
    private Object imageSource;
    protected WWTexture texture;
    private double imageSize = 500.0;
    protected OGLStackHandler osh = new OGLStackHandler();

    public ElevationPlane() {
        this.getRenderer().setEnableLighting(false);
    }

    public Object getImageSource() {
        return this.imageSource;
    }

    public void setImageSource(Object object) {
        this.imageSource = object;
        this.texture = null;
    }

    public double getImageSize() {
        return this.imageSize;
    }

    public void setImageSize(double d) {
        this.imageSize = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRenderGeometry(DrawContext drawContext, String string, List<LatLon> list, List<Boolean> list2) {
        this.beginRendering(drawContext);
        try {
            this.applyTextureState(drawContext);
            drawContext.getGL().glDepthMask(false);
            super.doRenderGeometry(drawContext, string, list, list2);
        }
        finally {
            this.unApplyTextureState(drawContext);
            this.endRendering(drawContext);
        }
    }

    protected void beginRendering(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        this.osh.pushAttrib(gL2, 28929);
        this.osh.pushTextureIdentity(gL2);
    }

    protected void endRendering(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        this.osh.pop(gL2);
    }

    protected void applyTextureState(DrawContext drawContext) {
        WWTexture wWTexture = this.getTexture();
        if (wWTexture == null) {
            return;
        }
        if (!wWTexture.bind(drawContext)) {
            return;
        }
        GL2 gL2 = drawContext.getGL().getGL2();
        double[][] dArray = this.computePlanes(drawContext);
        if (dArray == null) {
            return;
        }
        gL2.glTexGeni(8192, 9472, 9217);
        gL2.glTexGeni(8193, 9472, 9217);
        gL2.glTexGendv(8192, 9473, dArray[0], 0);
        gL2.glTexGendv(8193, 9473, dArray[1], 0);
        gL2.glEnable(3168);
        gL2.glEnable(3169);
        gL2.glMatrixMode(2984);
        gL2.glScaled(1.0 / this.imageSize, 1.0 / this.imageSize, 1.0);
        gL2.glEnable(3042);
        gL2.glBlendFunc(1, 771);
        gL2.glEnable(3553);
        gL2.glTexParameteri(3553, 10242, 10497);
        gL2.glTexParameteri(3553, 10243, 10497);
    }

    protected void unApplyTextureState(DrawContext drawContext) {
        GL2 gL2 = drawContext.getGL().getGL2();
        gL2.glTexGeni(8192, 9472, 9216);
        gL2.glTexGeni(8193, 9472, 9216);
        gL2.glTexGendv(8192, 9473, OGLUtil.DEFAULT_TEXTURE_GEN_S_OBJECT_PLANE, 0);
        gL2.glTexGendv(8193, 9473, OGLUtil.DEFAULT_TEXTURE_GEN_T_OBJECT_PLANE, 0);
        gL2.glBindTexture(3553, 0);
    }

    protected double[][] computePlanes(DrawContext drawContext) {
        double[][] dArray = new double[2][4];
        Position position = this.getReferencePosition();
        if (position == null) {
            return null;
        }
        Vec4 vec4 = drawContext.getGlobe().computeNorthPointingTangentAtLocation(position.latitude, position.longitude);
        Vec4 vec42 = drawContext.getGlobe().computeSurfaceNormalAtLocation(position.latitude, position.longitude);
        Vec4 vec43 = vec4.cross3(vec42);
        vec4.toArray4(dArray[0], 0);
        vec43.toArray4(dArray[1], 0);
        return dArray;
    }

    protected WWTexture getTexture() {
        if (this.texture == null && this.imageSource != null) {
            this.texture = new BasicWWTexture(this.imageSource);
        }
        return this.texture;
    }
}

