/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwindx.applications.dataimporter;

import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwindx.applications.dataimporter.FileSet;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class TableCellColorRenderer
extends JLabel
implements TableCellRenderer {
    protected List<Color> fileSetColors = new ArrayList<Color>();
    protected Border unselectedBorder = null;
    protected Border selectedBorder = null;
    protected boolean isBordered = true;

    public TableCellColorRenderer(boolean bl) {
        this.isBordered = bl;
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        Color color = (Color)object;
        this.setBackground(color);
        if (this.isBordered) {
            if (bl) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, jTable.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        return this;
    }

    protected void initializeColors() {
        this.fileSetColors.clear();
        this.fileSetColors.add(Color.YELLOW);
        this.fileSetColors.add(Color.GREEN);
        this.fileSetColors.add(Color.BLUE);
        this.fileSetColors.add(Color.CYAN);
        this.fileSetColors.add(Color.MAGENTA);
        this.fileSetColors.add(Color.RED);
        this.fileSetColors.add(Color.ORANGE);
        this.fileSetColors.add(Color.PINK);
    }

    protected Color determineFileSetColor(FileSet fileSet) {
        if (fileSet.getValue("gov.nasa.worldwind.avkey.Color") != null) {
            return (Color)fileSet.getValue("gov.nasa.worldwind.avkey.Color");
        }
        if (this.fileSetColors.size() > 0) {
            Color color = this.fileSetColors.get(0);
            this.fileSetColors.remove(color);
            return color;
        }
        return WWUtil.makeRandomColor(null);
    }
}

