/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXButton
extends JButton {
    private String text = "";
    private boolean borderPainted;
    private boolean contentAreaFilled;
    private Painter<JXButton> fgPainter = new DefaultForegroundPainter();
    private Painter<JXButton> bgPainter = new DefaultBackgroundPainter();
    private boolean paintBorderInsets = true;
    private boolean painting;

    public JXButton() {
    }

    public JXButton(String text) {
        super(text);
    }

    public JXButton(Action a) {
        super(a);
    }

    public JXButton(Icon icon) {
        super(icon);
    }

    public JXButton(String text, Icon icon) {
        super(text, icon);
    }

    @Override
    protected void init(String text, Icon icon) {
        this.borderPainted = true;
        this.contentAreaFilled = true;
        super.init(text, icon);
    }

    @Override
    public void setText(String text) {
        this.text = text;
        super.setText(text);
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setBorderPainted(boolean b) {
        this.borderPainted = b;
        super.setBorderPainted(b);
    }

    @Override
    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    @Override
    public void setContentAreaFilled(boolean b) {
        this.contentAreaFilled = b;
        super.setContentAreaFilled(b);
    }

    @Override
    public boolean isContentAreaFilled() {
        return this.contentAreaFilled;
    }

    public Painter<JXButton> getBackgroundPainter() {
        return this.bgPainter;
    }

    public void setBackgroundPainter(Painter<JXButton> p) {
        Painter<JXButton> old = this.getBackgroundPainter();
        this.bgPainter = p;
        this.firePropertyChange("backgroundPainter", old, this.getBackgroundPainter());
        this.repaint();
    }

    public Painter<JXButton> getForegroundPainter() {
        return this.fgPainter;
    }

    public void setForegroundPainter(Painter<JXButton> p) {
        Painter<JXButton> old = this.getForegroundPainter();
        this.fgPainter = p;
        this.firePropertyChange("foregroundPainter", old, this.getForegroundPainter());
        this.repaint();
    }

    public boolean isPaintBorderInsets() {
        return this.paintBorderInsets;
    }

    public void setPaintBorderInsets(boolean paintBorderInsets) {
        boolean old = this.isPaintBorderInsets();
        this.paintBorderInsets = paintBorderInsets;
        this.firePropertyChange("paintBorderInsets", old, this.isPaintBorderInsets());
    }

    @Override
    protected void paintComponent(Graphics g) {
        Painter<JXButton> bgPainter = this.getBackgroundPainter();
        Painter<JXButton> fgPainter = this.getForegroundPainter();
        if (this.painting || bgPainter == null && fgPainter == null) {
            super.paintComponent(g);
        } else {
            this.invokePainter(g, bgPainter);
            this.invokePainter(g, fgPainter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokePainter(Graphics g, Painter<JXButton> ptr) {
        if (ptr == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        try {
            if (this.isPaintBorderInsets()) {
                ptr.paint(g2d, this, this.getWidth(), this.getHeight());
            } else {
                Insets ins = this.getInsets();
                g2d.translate(ins.left, ins.top);
                ptr.paint(g2d, this, this.getWidth() - ins.left - ins.right, this.getHeight() - ins.top - ins.bottom);
            }
        }
        finally {
            g2d.dispose();
        }
    }

    protected void setPainting(boolean b) {
        this.painting = b;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultForegroundPainter
    extends AbstractPainter<JXButton> {
        private DefaultForegroundPainter() {
        }

        @Override
        protected void doPaint(Graphics2D g, JXButton b, int width, int height) {
            b.setPainting(true);
            boolean t1 = b.isBorderPainted();
            boolean t2 = b.isContentAreaFilled();
            b.borderPainted = false;
            b.contentAreaFilled = false;
            b.paint(g);
            b.borderPainted = t1;
            b.contentAreaFilled = t2;
            b.setPainting(false);
        }

        @Override
        protected boolean shouldUseCache() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DefaultBackgroundPainter
    extends AbstractPainter<JXButton> {
        private DefaultBackgroundPainter() {
        }

        @Override
        protected void doPaint(Graphics2D g, JXButton b, int width, int height) {
            b.setPainting(true);
            String tmp = b.text;
            b.text = "";
            b.paint(g);
            b.text = tmp;
            b.setPainting(false);
        }

        @Override
        protected boolean shouldUseCache() {
            return false;
        }
    }
}

