/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Point;
import org.geotools.coverage.grid.GeneralGridCoordinates;
import org.geotools.resources.i18n.Errors;
import org.opengis.coverage.grid.GridCoordinates;

public class GridCoordinates2D
extends Point
implements GridCoordinates {
    private static final long serialVersionUID = -4583333545268906740L;

    public GridCoordinates2D() {
    }

    public GridCoordinates2D(int x, int y) {
        super(x, y);
    }

    public GridCoordinates2D(Point coordinates) {
        super(coordinates);
    }

    public final int getDimension() {
        return 2;
    }

    public int[] getCoordinateValues() {
        return new int[]{this.x, this.y};
    }

    public int getCoordinateValue(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
    }

    public void setCoordinateValue(int dimension, int value) throws IndexOutOfBoundsException, UnsupportedOperationException {
        switch (dimension) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(GridCoordinates2D.indexOutOfBounds(dimension));
            }
        }
    }

    static String indexOutOfBounds(int dimension) {
        return Errors.format((int)56, (Object)dimension);
    }

    public String toString() {
        return GeneralGridCoordinates.toString(this);
    }

    public GridCoordinates2D clone() {
        return (GridCoordinates2D)super.clone();
    }
}

