/*
 * Decompiled with CFR 0.152.
 */
package org.libtiff.jai.codecimpl;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codec.TIFFDecodeParam;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.media.jai.RasterFactory;
import org.libtiff.jai.codec.XTIFFDecodeParam;
import org.libtiff.jai.codec.XTIFFDirectory;
import org.libtiff.jai.codec.XTIFFField;
import org.libtiff.jai.codec.XTIFFTileCodec;
import org.libtiff.jai.util.JaiI18N;

public class XTIFFImage
extends SimpleRenderedImage {
    XTIFFTileCodec codec;
    XTIFFDirectory dir;
    TIFFDecodeParam param;
    int photometric_interp;
    SeekableStream stream;
    int tileSize;
    int tilesX;
    int tilesY;
    long[] tileOffsets;
    long[] tileByteCounts;
    char[] colormap;
    char[] bitsPerSample;
    int samplesPerPixel;
    int extraSamples;
    byte[] palette;
    int bands;
    char[] sampleFormat;
    boolean decodePaletteAsShorts;
    boolean isBigEndian;
    int image_type;
    int dataType;
    private WritableRaster tile00 = null;

    public XTIFFImage(SeekableStream stream, TIFFDecodeParam param, int directory) throws IOException {
        this.stream = stream;
        if (param == null || !(param instanceof XTIFFDecodeParam)) {
            param = new XTIFFDecodeParam(param);
        }
        this.param = param;
        this.decodePaletteAsShorts = param.getDecodePaletteAsShorts();
        this.dir = XTIFFDirectory.create(stream, directory);
        this.properties.put("tiff.directory", this.dir);
        ((XTIFFDecodeParam)param).setDirectory(this.dir);
        this.isBigEndian = this.dir.isBigEndian();
        this.setupImageParameters();
        this.setupSamplesAndColor();
        this.dir.setImageType(this.image_type);
        this.tilesX = (this.width + this.tileWidth - 1) / this.tileWidth;
        this.tilesY = (this.height + this.tileHeight - 1) / this.tileHeight;
        this.tileSize = this.tileWidth * this.tileHeight * this.bands;
        try {
            this.codec = this.dir.createTileCodec((XTIFFDecodeParam)param);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void setupImageParameters() {
        this.minY = 0;
        this.minX = 0;
        this.width = (int)this.dir.getFieldAsLong(256);
        this.height = (int)this.dir.getFieldAsLong(257);
        this.photometric_interp = (int)this.dir.getFieldAsLong(262);
        XTIFFField bitsField = this.dir.getField(258);
        if (bitsField == null) {
            this.bitsPerSample = new char[1];
            this.bitsPerSample[0] = '\u0001';
        } else {
            this.bitsPerSample = bitsField.getAsChars();
        }
        for (int i = 1; i < this.bitsPerSample.length; ++i) {
            if (this.bitsPerSample[i] == this.bitsPerSample[1]) continue;
            throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder19"));
        }
        XTIFFField sfield = this.dir.getField(277);
        this.samplesPerPixel = sfield == null ? 1 : (int)sfield.getAsLong(0);
        XTIFFField efield = this.dir.getField(338);
        this.extraSamples = efield == null ? 0 : (int)efield.getAsLong(0);
        XTIFFField sampleFormatField = this.dir.getField(339);
        if (sampleFormatField != null) {
            this.sampleFormat = sampleFormatField.getAsChars();
            for (int l = 1; l < this.sampleFormat.length; ++l) {
                if (this.sampleFormat[l] == this.sampleFormat[0]) continue;
                throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder20"));
            }
        } else {
            this.sampleFormat = new char[]{'\u0001'};
        }
        if (this.sampleFormat[0] == '\u0001' || this.sampleFormat[0] == '\u0004') {
            if (this.bitsPerSample[0] == '\b') {
                this.dataType = 0;
            } else if (this.bitsPerSample[0] == '\u0010') {
                this.dataType = 1;
            } else if (this.bitsPerSample[0] == ' ') {
                this.dataType = 3;
            }
        } else if (this.sampleFormat[0] == '\u0002') {
            if (this.bitsPerSample[0] == '\u0001' || this.bitsPerSample[0] == '\u0004' || this.bitsPerSample[0] == '\b') {
                throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder21"));
            }
            if (this.bitsPerSample[0] == '\u0010') {
                this.dataType = 2;
            } else if (this.bitsPerSample[0] == ' ') {
                this.dataType = 3;
            }
        } else if (this.sampleFormat[0] == '\u0003') {
            throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder22"));
        }
        if (this.dir.getField(322) != null) {
            this.tileWidth = (int)this.dir.getFieldAsLong(322);
            this.tileHeight = (int)this.dir.getFieldAsLong(323);
            this.tileOffsets = this.dir.getField(324).getAsLongs();
            this.tileByteCounts = this.dir.getField(325).getAsLongs();
        } else {
            this.tileWidth = this.width;
            XTIFFField field = this.dir.getField(278);
            if (field == null) {
                this.tileHeight = this.height;
            } else {
                long l = field.getAsLong(0);
                long infinity = 1L;
                this.tileHeight = l == (infinity = (infinity << 32) - 1L) ? this.height : (int)l;
            }
            XTIFFField tileOffsetsField = this.dir.getField(273);
            if (tileOffsetsField == null) {
                throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder11"));
            }
            this.tileOffsets = tileOffsetsField.getAsLongs();
            XTIFFField tileByteCountsField = this.dir.getField(279);
            if (tileByteCountsField == null) {
                throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder12"));
            }
            this.tileByteCounts = tileByteCountsField.getAsLongs();
        }
    }

    protected void setupSamplesAndColor() {
        switch (this.photometric_interp) {
            case 0: {
                this.bands = 1;
                if (this.bitsPerSample[0] == '\u0001') {
                    this.image_type = 0;
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 1);
                    byte[] r = new byte[]{-1, 0};
                    byte[] g = new byte[]{-1, 0};
                    byte[] b = new byte[]{-1, 0};
                    this.colorModel = new IndexColorModel(1, 2, r, g, b);
                    break;
                }
                this.image_type = 2;
                if (this.bitsPerSample[0] == '\u0004') {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 4);
                    this.colorModel = ImageCodec.createGrayIndexColorModel((SampleModel)this.sampleModel, (boolean)false);
                    break;
                }
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)0, (int)this.tileWidth, (int)this.tileHeight, (int)this.bands);
                    this.colorModel = ImageCodec.createGrayIndexColorModel((SampleModel)this.sampleModel, (boolean)false);
                    break;
                }
                if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)this.dataType, (int)this.tileWidth, (int)this.tileHeight, (int)this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel((SampleModel)this.sampleModel);
                    break;
                }
                throw new IllegalArgumentException(JaiI18N.getString("XTIFFImageDecoder14"));
            }
            case 1: {
                this.bands = 1;
                if (this.bitsPerSample[0] == '\u0001') {
                    this.image_type = 1;
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 1);
                    byte[] r = new byte[]{0, -1};
                    byte[] g = new byte[]{0, -1};
                    byte[] b = new byte[]{0, -1};
                    this.colorModel = new IndexColorModel(1, 2, r, g, b);
                    break;
                }
                this.image_type = 3;
                if (this.bitsPerSample[0] == '\u0004') {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, 4);
                    this.colorModel = ImageCodec.createGrayIndexColorModel((SampleModel)this.sampleModel, (boolean)true);
                    break;
                }
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)0, (int)this.tileWidth, (int)this.tileHeight, (int)this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel((SampleModel)this.sampleModel);
                    break;
                }
                if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)this.dataType, (int)this.tileWidth, (int)this.tileHeight, (int)this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel((SampleModel)this.sampleModel);
                    break;
                }
                throw new IllegalArgumentException(JaiI18N.getString("XTIFFImageDecoder14"));
            }
            case 2: {
                this.bands = this.samplesPerPixel;
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)0, (int)this.tileWidth, (int)this.tileHeight, (int)this.bands);
                } else if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)this.dataType, (int)this.tileWidth, (int)this.tileHeight, (int)this.bands);
                } else {
                    throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder15"));
                }
                if (this.samplesPerPixel < 3) {
                    throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder1"));
                }
                if (this.samplesPerPixel == 3) {
                    this.image_type = 4;
                    this.colorModel = ImageCodec.createComponentColorModel((SampleModel)this.sampleModel);
                    break;
                }
                if (this.samplesPerPixel == 4) {
                    if (this.extraSamples == 0) {
                        this.image_type = 7;
                        this.colorModel = this.createAlphaComponentColorModel(this.dataType, true, false, 1);
                        break;
                    }
                    if (this.extraSamples == 1) {
                        this.image_type = 5;
                        this.colorModel = this.createAlphaComponentColorModel(this.dataType, true, true, 3);
                        break;
                    }
                    if (this.extraSamples != 2) break;
                    this.image_type = 6;
                    this.colorModel = this.createAlphaComponentColorModel(this.dataType, true, false, 2);
                    break;
                }
                this.image_type = 8;
                int[] bandOffsets = new int[this.bands];
                for (int i = 0; i < this.bands; ++i) {
                    bandOffsets[i] = i;
                }
                if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = new PixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.bands, this.bands * this.tileWidth, bandOffsets);
                    this.colorModel = null;
                    break;
                }
                if (this.bitsPerSample[0] != '\u0010') break;
                this.sampleModel = new PixelInterleavedSampleModel(this.dataType, this.tileWidth, this.tileHeight, this.bands, this.bands * this.tileWidth, bandOffsets);
                this.colorModel = null;
                break;
            }
            case 3: {
                this.image_type = 9;
                XTIFFField cfield = this.dir.getField(320);
                if (cfield == null) {
                    throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder2"));
                }
                this.colormap = cfield.getAsChars();
                if (this.decodePaletteAsShorts) {
                    this.bands = 3;
                    if (this.bitsPerSample[0] != '\u0004' && this.bitsPerSample[0] != '\b' && this.bitsPerSample[0] != '\u0010') {
                        throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder13"));
                    }
                    if (this.dataType == 0) {
                        this.dataType = 1;
                    }
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)this.dataType, (int)this.tileWidth, (int)this.tileHeight, (int)this.bands);
                    this.colorModel = ImageCodec.createComponentColorModel((SampleModel)this.sampleModel);
                    break;
                }
                this.bands = 1;
                if (this.bitsPerSample[0] == '\u0004') {
                    this.sampleModel = new MultiPixelPackedSampleModel(0, this.tileWidth, this.tileHeight, this.bitsPerSample[0]);
                } else if (this.bitsPerSample[0] == '\b') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)0, (int)this.tileWidth, (int)this.tileHeight, (int)this.bands);
                } else if (this.bitsPerSample[0] == '\u0010') {
                    this.sampleModel = RasterFactory.createPixelInterleavedSampleModel((int)1, (int)this.tileWidth, (int)this.tileHeight, (int)this.bands);
                } else {
                    throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder13"));
                }
                int bandLength = this.colormap.length / 3;
                byte[] r = new byte[bandLength];
                byte[] g = new byte[bandLength];
                byte[] b = new byte[bandLength];
                int gIndex = bandLength;
                int bIndex = bandLength * 2;
                if (this.dataType == 2) {
                    for (int i = 0; i < bandLength; ++i) {
                        r[i] = this.param.decodeSigned16BitsTo8Bits((short)this.colormap[i]);
                        g[i] = this.param.decodeSigned16BitsTo8Bits((short)this.colormap[gIndex + i]);
                        b[i] = this.param.decodeSigned16BitsTo8Bits((short)this.colormap[bIndex + i]);
                    }
                } else {
                    for (int i = 0; i < bandLength; ++i) {
                        r[i] = this.param.decode16BitsTo8Bits(this.colormap[i] & 0xFFFF);
                        g[i] = this.param.decode16BitsTo8Bits(this.colormap[gIndex + i] & 0xFFFF);
                        b[i] = this.param.decode16BitsTo8Bits(this.colormap[bIndex + i] & 0xFFFF);
                    }
                }
                this.colorModel = new IndexColorModel((int)this.bitsPerSample[0], bandLength, r, g, b);
                break;
            }
            case 4: {
                this.image_type = 10;
                throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder3"));
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder4"));
            }
        }
    }

    public XTIFFDirectory getPrivateIFD(long offset) throws IOException {
        return XTIFFDirectory.create(this.stream, offset);
    }

    public synchronized Raster getTile(int tileX, int tileY) {
        if (tileX == 0 && tileY == 0 && this.tile00 != null) {
            return this.tile00;
        }
        if (tileX < 0 || tileX >= this.tilesX || tileY < 0 || tileY >= this.tilesY) {
            throw new IllegalArgumentException(JaiI18N.getString("XTIFFImageDecoder5"));
        }
        long save_offset = 0L;
        try {
            save_offset = this.stream.getFilePointer();
            this.stream.seek(this.tileOffsets[tileY * this.tilesX + tileX]);
        }
        catch (IOException ioe) {
            throw new RuntimeException(JaiI18N.getString("XTIFFImageDecoder8"));
        }
        int byteCount = (int)this.tileByteCounts[tileY * this.tilesX + tileX];
        Rectangle tileRect = new Rectangle(this.tileXToX(tileX), this.tileYToY(tileY), this.tileWidth, this.tileHeight);
        Rectangle newRect = tileRect.intersection(this.getBounds());
        byte[] data = new byte[byteCount];
        WritableRaster tile = null;
        try {
            this.stream.readFully(data, 0, byteCount);
            tile = this.codec.decode((RenderedImage)((Object)this), newRect, data);
            this.stream.seek(save_offset);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read raw tile data:" + e);
        }
        if (tileX == 0 && tileY == 0) {
            this.tile00 = tile;
        }
        return tile;
    }

    private ComponentColorModel createAlphaComponentColorModel(int dataType, boolean hasAlpha, boolean isAlphaPremultiplied, int transparency) {
        ComponentColorModel ccm = null;
        int[][] RGBBits = new int[][]{{8, 8, 8, 8}, {16, 16, 16, 16}, {16, 16, 16, 16}};
        RGBBits[2] = new int[]{32, 32, 32, 32};
        ccm = new ComponentColorModel(ColorSpace.getInstance(1000), RGBBits[dataType], hasAlpha, isAlphaPremultiplied, transparency, dataType);
        return ccm;
    }
}

