/*
 * Decompiled with CFR 0.152.
 */
package org.libtiff.jai.codec;

import java.io.Serializable;

public class XTIFFField
implements Serializable,
Comparable {
    public static final int TIFF_BYTE = 1;
    public static final int TIFF_ASCII = 2;
    public static final int TIFF_SHORT = 3;
    public static final int TIFF_LONG = 4;
    public static final int TIFF_RATIONAL = 5;
    public static final int TIFF_SBYTE = 6;
    public static final int TIFF_UNDEFINED = 7;
    public static final int TIFF_SSHORT = 8;
    public static final int TIFF_SLONG = 9;
    public static final int TIFF_SRATIONAL = 10;
    public static final int TIFF_FLOAT = 11;
    public static final int TIFF_DOUBLE = 12;
    int tag = 0;
    int type;
    int count;
    Object data;

    public XTIFFField() {
    }

    public XTIFFField(int tag, int type, int count, Object data) {
        this.tag = tag;
        this.type = type;
        this.count = count;
        this.data = data;
    }

    public int getTag() {
        return this.tag;
    }

    public int getType() {
        return this.type;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getAsBytes() {
        return (byte[])this.data;
    }

    public String[] getAsStrings() {
        return (String[])this.data;
    }

    public char[] getAsChars() {
        return (char[])this.data;
    }

    public short[] getAsShorts() {
        return (short[])this.data;
    }

    public int[] getAsInts() {
        return (int[])this.data;
    }

    public long[] getAsLongs() {
        if (this.type == 3) {
            char[] vals = (char[])this.data;
            long[] newvals = new long[vals.length];
            for (int i = 0; i < vals.length; ++i) {
                newvals[i] = vals[i] & 0xFFFF;
            }
            return newvals;
        }
        return (long[])this.data;
    }

    public float[] getAsFloats() {
        return (float[])this.data;
    }

    public double[] getAsDoubles() {
        return (double[])this.data;
    }

    public int[][] getAsSRationals() {
        return (int[][])this.data;
    }

    public long[][] getAsRationals() {
        return (long[][])this.data;
    }

    public int getAsInt(int index) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[index] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index];
            }
            case 3: {
                return ((char[])this.data)[index] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index];
            }
            case 9: {
                return ((int[])this.data)[index];
            }
        }
        throw new ClassCastException();
    }

    public long getAsLong(int index) {
        switch (this.type) {
            case 1: 
            case 7: {
                return ((byte[])this.data)[index] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index];
            }
            case 3: {
                return ((char[])this.data)[index] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index];
            }
            case 9: {
                return ((int[])this.data)[index];
            }
            case 4: {
                return ((long[])this.data)[index];
            }
        }
        throw new ClassCastException();
    }

    public float getAsFloat(int index) {
        switch (this.type) {
            case 1: {
                return ((byte[])this.data)[index] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index];
            }
            case 3: {
                return ((char[])this.data)[index] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index];
            }
            case 9: {
                return ((int[])this.data)[index];
            }
            case 4: {
                return ((long[])this.data)[index];
            }
            case 11: {
                return ((float[])this.data)[index];
            }
            case 12: {
                return (float)((double[])this.data)[index];
            }
            case 10: {
                int[] ivalue = this.getAsSRational(index);
                return (float)((double)ivalue[0] / (double)ivalue[1]);
            }
            case 5: {
                long[] lvalue = this.getAsRational(index);
                return (float)((double)lvalue[0] / (double)lvalue[1]);
            }
        }
        throw new ClassCastException();
    }

    public double getAsDouble(int index) {
        switch (this.type) {
            case 1: {
                return ((byte[])this.data)[index] & 0xFF;
            }
            case 6: {
                return ((byte[])this.data)[index];
            }
            case 3: {
                return ((char[])this.data)[index] & 0xFFFF;
            }
            case 8: {
                return ((short[])this.data)[index];
            }
            case 9: {
                return ((int[])this.data)[index];
            }
            case 4: {
                return ((long[])this.data)[index];
            }
            case 11: {
                return ((float[])this.data)[index];
            }
            case 12: {
                return ((double[])this.data)[index];
            }
            case 10: {
                int[] ivalue = this.getAsSRational(index);
                return (double)ivalue[0] / (double)ivalue[1];
            }
            case 5: {
                long[] lvalue = this.getAsRational(index);
                return (double)lvalue[0] / (double)lvalue[1];
            }
        }
        throw new ClassCastException();
    }

    public String getAsString(int index) {
        return ((String[])this.data)[index];
    }

    public int[] getAsSRational(int index) {
        return ((int[][])this.data)[index];
    }

    public long[] getAsRational(int index) {
        return ((long[][])this.data)[index];
    }

    public int compareTo(Object o) throws ClassCastException {
        if (!(o instanceof XTIFFField)) {
            throw new ClassCastException("comparator is not an XTIFFField");
        }
        if (o == null) {
            throw new NullPointerException("comparator");
        }
        return this.tag - ((XTIFFField)o).tag;
    }
}

