/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.quadtree;

import java.io.Serializable;

public class QuadTreeRect
implements Serializable {
    static final long serialVersionUID = -5585535433679092922L;
    public float north;
    public float south;
    public float west;
    public float east;

    public QuadTreeRect(float n, float w, float s, float e) {
        this.north = n;
        this.west = w;
        this.south = s;
        this.east = e;
    }

    public boolean within(QuadTreeRect rect) {
        return this.within(rect.north, rect.west, rect.south, rect.east);
    }

    public boolean within(float n, float w, float s, float e) {
        if (s >= this.north) {
            return false;
        }
        if (n < this.south) {
            return false;
        }
        if (w > this.east) {
            return false;
        }
        return !(e <= this.west);
    }

    public boolean pointWithinBounds(float lat, float lon) {
        return lon >= this.west && lon < this.east && lat <= this.north && lat > this.south;
    }

    public double borderDistance(float lat, float lon) {
        double nsdistance = this.south <= lat && lat <= this.north ? 0.0 : (double)Math.min(Math.abs(lat - this.north), Math.abs(lat - this.south));
        double ewdistance = this.west <= lon && lon <= this.east ? 0.0 : (double)Math.min(Math.abs(lon - this.east), Math.abs(lon - this.west));
        double distance = Math.sqrt(Math.pow(nsdistance, 2.0) + Math.pow(ewdistance, 2.0));
        return distance;
    }
}

