/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util.propertyEditor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditorSupport;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TrueFalsePropertyEditor
extends PropertyEditorSupport
implements ActionListener,
FocusListener {
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected boolean option = true;
    protected JRadioButton trueButton = new JRadioButton("true");
    protected JRadioButton falseButton = new JRadioButton("false");
    protected boolean useAltCommandStrings = false;
    public static final String TrueString = "true";
    public static final String FalseString = "false";

    public boolean supportsCustomEditor() {
        return true;
    }

    public void setUseAltCommandStrings(boolean value) {
        this.useAltCommandStrings = value;
    }

    public boolean getUseAltCommandStrings() {
        return this.useAltCommandStrings;
    }

    public Component getCustomEditor() {
        JPanel panel = new JPanel();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        panel.setLayout(gridbag);
        if (!this.getUseAltCommandStrings()) {
            this.trueButton.setActionCommand(TrueString);
            this.falseButton.setActionCommand(FalseString);
        }
        this.trueButton.addActionListener(this);
        this.falseButton.addActionListener(this);
        this.buttonGroup.add(this.trueButton);
        this.buttonGroup.add(this.falseButton);
        this.setSelected(this.option);
        gridbag.setConstraints(this.trueButton, c);
        c.fill = 2;
        c.weightx = 1.0;
        gridbag.setConstraints(this.falseButton, c);
        panel.add(this.trueButton);
        panel.add(this.falseButton);
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        String ac = e.getActionCommand();
        this.setSelected(ac.equalsIgnoreCase(this.trueButton.getActionCommand()));
        this.firePropertyChange();
    }

    public void setSelected(boolean set) {
        this.option = set;
        this.trueButton.setSelected(this.option);
        this.falseButton.setSelected(!this.option);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        this.firePropertyChange();
    }

    public void setValue(Object string) {
        if (!(string instanceof String)) {
            return;
        }
        this.setSelected(((String)string).equalsIgnoreCase(this.trueButton.getActionCommand()));
    }

    public String getAsText() {
        if (this.option) {
            return this.trueButton.getActionCommand();
        }
        return this.falseButton.getActionCommand();
    }
}

