/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.Environment;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class FileUtils {
    public static String getFilePathToSaveFromUser(String title) {
        JFileChooser chooser = FileUtils.getChooser(title);
        int state = chooser.showSaveDialog(null);
        String ret = FileUtils.handleResponse(chooser, state);
        return ret;
    }

    public static String getFilePathToOpenFromUser(String title) {
        return FileUtils.getFilePathToOpenFromUser(title, null);
    }

    public static String getFilePathToOpenFromUser(String title, FileFilter ff) {
        JFileChooser chooser = FileUtils.getChooser(title);
        if (ff != null) {
            chooser.setFileFilter(ff);
        }
        int state = chooser.showOpenDialog(null);
        String ret = FileUtils.handleResponse(chooser, state);
        return ret;
    }

    public static String getPathToOpenFromUser(String title, FileFilter ff, int fileSelectionMode, String acceptButtonText) {
        JFileChooser chooser = FileUtils.getChooser(title);
        chooser.setFileSelectionMode(fileSelectionMode);
        if (ff != null) {
            chooser.setFileFilter(ff);
        }
        int state = chooser.showDialog(null, acceptButtonText);
        String ret = FileUtils.handleResponse(chooser, state);
        return ret;
    }

    public static JFileChooser getChooser(String title) {
        File startingPoint = new File(Environment.get("lastchosendirectory", System.getProperty("user.home")));
        JFileChooser chooser = new JFileChooser(startingPoint);
        chooser.setDialogTitle(title);
        return chooser;
    }

    public static String handleResponse(JFileChooser chooser, int state) {
        String ret = null;
        try {
            int dirIndex;
            if (state != 1 && state != -1 && (dirIndex = (ret = chooser.getSelectedFile().getCanonicalPath()).lastIndexOf(File.separator)) >= 0) {
                Environment.set("lastchosendirectory", ret.substring(0, dirIndex));
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(null, ioe.getMessage(), "Error picking file", 0);
            ioe.printStackTrace();
        }
        return ret;
    }

    public static void copy(File fromFile, File toFile, int bufSize) throws IOException {
        int numRead;
        FileInputStream fis = new FileInputStream(fromFile);
        FileOutputStream fos = new FileOutputStream(toFile);
        if (bufSize <= 0) {
            bufSize = 1024;
        }
        byte[] bytes = new byte[bufSize];
        while ((numRead = fis.read(bytes)) > 0) {
            fos.write(bytes, 0, numRead);
        }
        fis.close();
        fos.close();
    }

    public static void saveZipFile(String zipFileName, File toBeZipped) throws IOException, FileNotFoundException {
        try {
            File zipFile;
            if (!zipFileName.endsWith(".zip")) {
                zipFileName = zipFileName + ".zip";
            }
            if (!(zipFile = new File(zipFileName)).getParentFile().exists()) {
                zipFile.getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zoStream = new ZipOutputStream(fos);
            FileUtils.writeZipEntry(toBeZipped, zoStream, toBeZipped.getParent().length() + 1);
            zoStream.close();
        }
        catch (SecurityException se) {
            Debug.error("Security Exception caught while creating " + zipFileName);
        }
    }

    protected static void writeZipEntry(File toBeZipped, ZipOutputStream zoStream, int prefixTrimLength) {
        if (toBeZipped.isDirectory()) {
            File[] files = toBeZipped.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtils.writeZipEntry(files[i], zoStream, prefixTrimLength);
            }
        } else {
            if (Debug.debugging("zip")) {
                Debug.output("FileUtils.writeZipEntry(" + toBeZipped + ", " + toBeZipped.getAbsolutePath().substring(prefixTrimLength) + ")");
            }
            FileUtils.writeZipEntry(toBeZipped, zoStream, prefixTrimLength < 0 ? toBeZipped.getName() : toBeZipped.getAbsolutePath().substring(prefixTrimLength));
        }
    }

    protected static void writeZipEntry(File fromFile, ZipOutputStream zoStream, String entryName) {
        try {
            int numRead;
            long size = fromFile.length();
            ZipEntry zEntry = new ZipEntry(entryName);
            zEntry.setSize(size);
            zEntry.setCrc(0L);
            zoStream.putNextEntry(zEntry);
            FileInputStream fis = new FileInputStream(fromFile);
            byte[] bytes = new byte[1024];
            CRC32 checksum = new CRC32();
            while ((numRead = fis.read(bytes)) > 0) {
                zoStream.write(bytes, 0, numRead);
                checksum.update(bytes, 0, numRead);
            }
            zEntry.setCrc(checksum.getValue());
            fis.close();
            zoStream.closeEntry();
        }
        catch (IOException ioe) {
            Debug.error("Error writing zip entry " + entryName);
            ioe.printStackTrace();
        }
    }

    public static void openZipFile(String zipFileName, File toDir, boolean deleteAfter) {
        if (zipFileName != null) {
            try {
                URL zipurl;
                if (!toDir.exists()) {
                    toDir.mkdirs();
                }
                if ((zipurl = PropUtils.getResourceOrFileOrURL(zipFileName)) != null) {
                    ZipEntry e;
                    BufferedInputStream in = new BufferedInputStream(zipurl.openStream());
                    if (Debug.debugging("zip")) {
                        Debug.output(" unzipping " + zipFileName);
                    }
                    ZipInputStream zin = new ZipInputStream(in);
                    while ((e = zin.getNextEntry()) != null) {
                        if (e.isDirectory()) {
                            new File(toDir, e.getName()).mkdirs();
                            continue;
                        }
                        if (Debug.debugging("zip")) {
                            Debug.output(" unzipping " + e.getName());
                        }
                        FileUtils.unzip(zin, new File(toDir, e.getName()));
                    }
                    zin.close();
                    if (deleteAfter) {
                        File file;
                        if (Debug.debugging("zip")) {
                            Debug.output("unzipping complete, deleting zip file");
                        }
                        if ((file = new File(zipurl.getFile())).exists()) {
                            file.delete();
                        }
                    } else if (Debug.debugging("zip")) {
                        Debug.output("unzipping complete, leaving zip file");
                    }
                    return;
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected static void unzip(ZipInputStream zin, File f) throws IOException {
        int BUFFER = 2048;
        FileOutputStream out = new FileOutputStream(f);
        byte[] b = new byte[2048];
        int len = 0;
        BufferedOutputStream dest = new BufferedOutputStream(out, 2048);
        while ((len = zin.read(b, 0, 2048)) != -1) {
            dest.write(b, 0, len);
        }
        dest.flush();
        dest.close();
    }
}

