/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.util.Debug;
import java.util.Vector;

public class ArgParser {
    public static final int TO_END = -1;
    protected String programName;
    protected Vector args;
    protected String[] rest = new String[0];
    protected char option = (char)45;
    protected boolean allowAbbr = true;

    public ArgParser(String pName) {
        this.programName = pName;
        this.args = new Vector();
        this.args.add(new HelpArg());
    }

    public void add(String argName, String desc) {
        this.add(argName, desc, 0);
    }

    public void add(String argName, String desc, int expectedNumberOfArguments) {
        this.add(argName, desc, expectedNumberOfArguments, false);
    }

    public void add(String argName, String desc, int expectedNumberOfArguments, boolean expectDashedArguments) {
        Arg newArg = new Arg(argName, desc, expectedNumberOfArguments, expectDashedArguments);
        this.args.add(newArg);
        if (Debug.debugging("parse")) {
            Debug.output("ArgParser: adding " + argName);
        }
    }

    public boolean parse(String[] argv) {
        try {
            if (argv == null || argv.length == 0) {
                return false;
            }
            for (int i = 0; i < argv.length; ++i) {
                boolean hit = false;
                if (argv[i].charAt(0) == this.option) {
                    String eval = argv[i].substring(1);
                    for (int j = 0; j < this.args.size(); ++j) {
                        Arg curArg = (Arg)this.args.elementAt(j);
                        if (!curArg.is(eval, this.allowAbbr)) continue;
                        if (Debug.debugging("parse")) {
                            Debug.output("ArgParser: arg " + curArg.name + " reading values.");
                        }
                        if (!curArg.readArgs(argv, ++i)) {
                            this.bail("ArgParser: Unexpected arguments with option " + curArg.name + ".", true);
                        }
                        hit = true;
                        if (curArg.numExpectedValues != -1) {
                            i += curArg.numExpectedValues - 1;
                            continue;
                        }
                        i = argv.length;
                    }
                    if (!hit) {
                        this.bail(this.programName + ": unknown option " + argv[i], false);
                    }
                }
                if (hit) continue;
                if (i == 0) {
                    this.rest = argv;
                } else {
                    int diff = argv.length - i;
                    this.rest = new String[diff];
                    for (int k = 0; k < diff; ++k) {
                        this.rest[k] = argv[i + k];
                        if (this.rest[k].charAt(0) != this.option) continue;
                        this.bail("ArgParser: Not expecting option in list of arguments.", true);
                    }
                }
                if (Debug.debugging("parse")) {
                    Debug.output("ArgParser: adding " + this.rest.length + " strings to the leftover list.");
                }
                return true;
            }
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            this.bail("Expecting more arguments for option", true);
        }
        catch (NegativeArraySizeException nase) {
            return false;
        }
        return true;
    }

    public void bail(String message, boolean printUsageStatement) {
        Debug.output(message);
        if (printUsageStatement) {
            this.printUsage();
        }
        System.exit(0);
    }

    public void setAllowAbbr(boolean set) {
        this.allowAbbr = set;
    }

    public boolean getAllowAbbr() {
        return this.allowAbbr;
    }

    public Vector getArgs() {
        return this.args;
    }

    public Arg getArg(String name) {
        for (int i = 0; i < this.args.size(); ++i) {
            Arg arg = (Arg)this.args.elementAt(i);
            if (!name.equalsIgnoreCase(arg.name)) continue;
            return arg;
        }
        return null;
    }

    public String[] getArgValues(String name) {
        for (int i = 0; i < this.args.size(); ++i) {
            Arg arg = (Arg)this.args.elementAt(i);
            if (!name.equalsIgnoreCase(arg.name) || !arg.flagged) continue;
            return arg.values;
        }
        return null;
    }

    public String[] getRest() {
        return this.rest;
    }

    public void printUsage() {
        Debug.output(this.programName + " Arguments:");
        for (int i = 0; i < this.args.size(); ++i) {
            Arg arg = (Arg)this.args.elementAt(i);
            StringBuffer sb = new StringBuffer();
            String filler = arg.name.length() < 6 ? "\t\t" : "\t";
            sb.append("  -" + arg.name + filler + arg.description);
            if (arg.numExpectedValues == -1) {
                sb.append(" (Variable number of arguments expected)");
            } else if (arg.numExpectedValues == 1) {
                sb.append(" (1 argument expected)");
            } else {
                sb.append(" (" + arg.numExpectedValues + " arguments expected)");
            }
            Debug.output(sb.toString());
        }
    }

    public static void main(String[] argv) {
        int i;
        Debug.init();
        ArgParser ap = new ArgParser("ArgParser");
        ap.add("first", "First test argument, no parameters expected");
        ap.add("second", "Second test argument, two parameters expected", 2);
        ap.add("third", "Third test argument, no parameters expected");
        ap.add("fourth", "Fourth test argument, one parameter expected", 1);
        if (!ap.parse(argv)) {
            ap.printUsage();
            System.exit(0);
        }
        Vector args = ap.getArgs();
        for (i = 0; i < args.size(); ++i) {
            Arg a = (Arg)args.elementAt(i);
            Debug.output(a.toString());
        }
        String[] rest = ap.getRest();
        Debug.output("Rest:");
        for (i = 0; i < rest.length; ++i) {
            Debug.output(rest[i]);
        }
    }

    public class HelpArg
    extends Arg {
        public HelpArg() {
            super("help", "Print usage statement, with arguments.", 0);
        }

        public boolean is(String arg, boolean allowAbbr) {
            boolean askingForHelp = super.is(arg, allowAbbr);
            if (askingForHelp) {
                ArgParser.this.bail("", true);
            }
            return false;
        }
    }

    public class Arg {
        public String name;
        public String description;
        public int numExpectedValues;
        public String[] values = null;
        public char c;
        public boolean flagged = false;
        public boolean dashedArguments = false;

        public Arg(String aName, String desc) {
            this(aName, desc, 0);
        }

        public Arg(String aName, String desc, int expectedNumberOfArguments) {
            this(aName, desc, expectedNumberOfArguments, false);
        }

        public Arg(String aName, String desc, int expectedNumberOfArguments, boolean expectDashedArguments) {
            this.name = aName;
            this.description = desc;
            this.numExpectedValues = expectedNumberOfArguments;
            this.c = this.name.charAt(0);
            this.dashedArguments = expectDashedArguments;
        }

        public boolean is(String arg, boolean allowAbbr) {
            if (this.name.equalsIgnoreCase(arg)) {
                return true;
            }
            return allowAbbr && arg.length() == 1 && arg.charAt(0) == this.c;
        }

        public boolean readArgs(String[] argv, int argIndex) throws ArrayIndexOutOfBoundsException, NegativeArraySizeException {
            this.values = this.numExpectedValues != -1 ? new String[this.numExpectedValues] : new String[argv.length - argIndex];
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i] = argv[argIndex + i];
                if (this.values[i].charAt(0) != ArgParser.this.option || this.dashedArguments) continue;
                if (this.numExpectedValues != -1) {
                    Debug.output("ArgParser: Option " + this.name + " expects " + this.numExpectedValues + (this.numExpectedValues == 1 ? " argument." : " arguments."));
                } else {
                    Debug.output("ArgParser: Option " + this.name + " not expecting options after its values.");
                }
                return false;
            }
            this.flagged = true;
            return true;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Arg: " + this.name + " expects " + this.numExpectedValues + (this.numExpectedValues == 1 ? " value.\n" : " values.\n"));
            if (this.values != null) {
                sb.append("Values: ");
                for (int i = 0; i < this.values.length; ++i) {
                    sb.append("[" + this.values[i] + "]");
                }
                sb.append("\n");
            }
            return sb.toString();
        }
    }
}

