/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.symbology.milStd2525;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.tools.symbology.milStd2525.CodeOptions;
import com.bbn.openmap.tools.symbology.milStd2525.CodePositionTree;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolImageMaker;
import com.bbn.openmap.tools.symbology.milStd2525.SymbolPart;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.ImageIcon;

public class SymbolReferenceLibrary
extends OMComponent {
    public static final String SymbolImageMakerClassProperty = "imageMakerClass";
    protected SymbolPart head;
    protected CodePositionTree positionTree;
    protected static SymbolReferenceLibrary library = null;
    protected CodeOptions symbolAttributes;
    protected SymbolImageMaker symbolImageMaker;
    static /* synthetic */ Class class$com$bbn$openmap$tools$symbology$milStd2525$SymbolReferenceLibrary;

    public SymbolReferenceLibrary() {
        this(null);
    }

    public SymbolReferenceLibrary(SymbolImageMaker sim) {
        Properties props = this.findAndLoadProperties("hierarchy.properties");
        if (props != null) {
            this.initialize(props, sim);
        }
    }

    public Properties findAndLoadProperties(String propertiesResource) {
        try {
            URL url = PropUtils.getResourceOrFileOrURL(class$com$bbn$openmap$tools$symbology$milStd2525$SymbolReferenceLibrary == null ? (class$com$bbn$openmap$tools$symbology$milStd2525$SymbolReferenceLibrary = SymbolReferenceLibrary.class$("com.bbn.openmap.tools.symbology.milStd2525.SymbolReferenceLibrary")) : class$com$bbn$openmap$tools$symbology$milStd2525$SymbolReferenceLibrary, propertiesResource);
            Properties props = new Properties();
            props.load(url.openStream());
            return props;
        }
        catch (MalformedURLException murle) {
            Debug.output("SymbolReferenceLibrary has malformed path to " + propertiesResource);
        }
        catch (IOException ioe) {
            Debug.output("SymbolReferenceLibrary I/O exception reading " + propertiesResource);
        }
        return null;
    }

    protected void initialize(Properties props, SymbolImageMaker sim) {
        Properties positionProperties;
        this.symbolImageMaker = sim;
        if (Debug.debugging("symbology")) {
            Debug.output("SRL: loading");
        }
        if ((positionProperties = this.findAndLoadProperties("positions.properties")) != null) {
            this.positionTree = new CodePositionTree(positionProperties);
            this.head = this.positionTree.parseHierarchy("MIL-STD-2525B Symbology", props);
        }
        if (Debug.debugging("symbology")) {
            Debug.output("SRL: initialized");
        }
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        String symbolImageMakerClassString = props.getProperty(realPrefix + SymbolImageMakerClassProperty);
        if (symbolImageMakerClassString != null) {
            this.symbolImageMaker = this.setSymbolImageMaker(symbolImageMakerClassString);
            if (this.symbolImageMaker != null) {
                this.symbolImageMaker.setProperties(prefix, props);
            }
        }
    }

    public SymbolImageMaker setSymbolImageMaker(String classname) {
        try {
            this.setSymbolImageMaker((SymbolImageMaker)Class.forName(classname).newInstance());
            return this.getSymbolImageMaker();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public CodeOptions getCodeOptions() {
        if (this.positionTree != null) {
            return this.positionTree.getCodeOptions(null);
        }
        return null;
    }

    public CodeOptions getCodeOptions(SymbolPart sp, CodeOptions co) {
        return null;
    }

    public ImageIcon getIcon(String symbolCode, Dimension di) {
        if (Debug.debugging("symbology")) {
            Debug.output("SymbolReferenceLibrary asked to create: " + symbolCode + " at " + di);
        }
        if (this.symbolImageMaker != null) {
            return this.symbolImageMaker.getIcon(symbolCode, di);
        }
        return null;
    }

    public ImageIcon getIcon(SymbolPart sp, CodeOptions co, Dimension di) {
        return null;
    }

    public String getSymbolCode(SymbolPart sp, CodeOptions co) {
        return null;
    }

    public SymbolPart getHead() {
        return this.head;
    }

    public String getDescription() {
        String description = null;
        if (this.head != null) {
            description = this.head.getDescription();
        }
        return description;
    }

    public SymbolPart getSymbolPartForCode(String code) {
        if (Debug.debugging("symbology.detail")) {
            Debug.output("SymbolReferenceLibrary checking for " + code + " in SymbolPart tree.");
        }
        if (this.head.codeMatches(code)) {
            return this.getSymbolPartForCodeStartingAt(this.head, code);
        }
        return null;
    }

    protected SymbolPart getSymbolPartForCodeStartingAt(SymbolPart node, String code) {
        List sublist = node.getSubs();
        if (sublist == null || sublist.size() == 0) {
            return node;
        }
        Iterator it = sublist.iterator();
        while (it.hasNext()) {
            SymbolPart ssp = (SymbolPart)it.next();
            try {
                char ch = code.charAt(ssp.getCodePosition().startIndex);
                if (ch == '-' || ch == '*') {
                    return node;
                }
                if (!ssp.codeMatches(code)) continue;
                return this.getSymbolPartForCodeStartingAt(ssp, code);
            }
            catch (StringIndexOutOfBoundsException sioobe) {
            }
            catch (NullPointerException npe) {
            }
        }
        return node;
    }

    public static void main(String[] argv) {
        Debug.init();
        Debug.put("codeposition");
        SymbolReferenceLibrary srl = new SymbolReferenceLibrary();
        Debug.output(srl.getDescription());
    }

    public SymbolImageMaker getSymbolImageMaker() {
        return this.symbolImageMaker;
    }

    public void setSymbolImageMaker(SymbolImageMaker symbolImageMaker) {
        this.symbolImageMaker = symbolImageMaker;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

