/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.dnd;

import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.util.Hashtable;

public class DnDListener
extends MouseDragGestureRecognizer
implements DragSourceListener,
DropTargetListener {
    protected boolean startDrag = true;
    protected int default_action = 2;
    private Hashtable cursors = new Hashtable();

    protected DnDListener(DragSource ds) {
        this(ds, null);
    }

    protected DnDListener(DragSource ds, Component c) {
        this(ds, c, 0);
    }

    protected DnDListener(DragSource ds, Component c, int act) {
        this(ds, c, act, null);
    }

    protected DnDListener(DragSource ds, Component c, int act, DragGestureListener dgl) {
        super(ds, c, act, dgl);
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        Debug.message("dndlistener", "dragDropEnd(source)");
        this.startDrag = true;
    }

    public void dragEnter(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        Debug.message("dndlistener", "dragEnter (source)");
        Debug.message("dndlistener", "action=" + action);
        if (action == this.default_action) {
            dsde.getDragSourceContext().setCursor(this.getCursor(DragSource.DefaultMoveDrop));
        } else {
            dsde.getDragSourceContext().setCursor(this.getCursor(DragSource.DefaultMoveNoDrop));
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        Debug.message("dndlistener", "dragEnter (target)");
        int action = dtde.getDropAction();
        Debug.message("dndlistener", "action=" + action);
        dtde.acceptDrag(action);
    }

    public void dragExit(DragSourceEvent dse) {
        Debug.message("dndlistener", "dragExit (source)");
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    public void dragExit(DropTargetEvent dte) {
        Debug.message("dndlistener", "dragExit (target)");
    }

    public void dragOver(DragSourceDragEvent dsde) {
        Debug.message("dndlistener", "dragOver(source)");
        int action = dsde.getDropAction();
        if (action == this.default_action) {
            dsde.getDragSourceContext().setCursor(this.getCursor(DragSource.DefaultMoveDrop));
        } else {
            dsde.getDragSourceContext().setCursor(this.getCursor(DragSource.DefaultMoveNoDrop));
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
        Debug.message("dndlistener", "dragOver(target)");
        dtde.acceptDrag(dtde.getDropAction());
    }

    public void drop(DropTargetDropEvent dtde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
        Debug.message("dndlistener", "dropActionChanged(source)");
        int action = dsde.getDropAction();
        Debug.message("dndlistener", "action=" + action);
        if (action == this.default_action) {
            dsde.getDragSourceContext().setCursor(this.getCursor(DragSource.DefaultMoveDrop));
        } else {
            dsde.getDragSourceContext().setCursor(this.getCursor(DragSource.DefaultMoveNoDrop));
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
        Debug.message("dndlistener", "dropActionChanged(target)");
        int action = dtde.getDropAction();
        Debug.message("dndlistener", "action=" + action);
        dtde.acceptDrag(action);
    }

    public Cursor getCursor(Cursor default_cursor) {
        Cursor cursor = (Cursor)this.cursors.get(default_cursor);
        return cursor != null ? cursor : default_cursor;
    }

    public int getDefaultAction() {
        return this.default_action;
    }

    public void setCursor(Image img, Cursor default_cursor) {
        Point offset = new Point(0, 0);
        Cursor customCursor = Toolkit.getDefaultToolkit().createCustomCursor(img, offset, "");
        this.cursors.put(default_cursor, customCursor);
    }

    public void setDefaultAction(int newAction) {
        this.default_action = newAction;
    }
}

