/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.coords.AbstractGCT;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.UTMPoint;
import com.bbn.openmap.util.PropUtils;
import java.awt.geom.Point2D;
import java.util.Properties;

public class UTMGCT
extends AbstractGCT
implements GeoCoordTransformation {
    public static final String NorthingProperty = "northing";
    public static final String EastingProperty = "easting";
    public static final String ZoneProperty = "zone";
    public static final String HemiProperty = "hemi";
    public static final String ElliposoidProperty = "ellipsoid";
    protected UTMPoint utm;
    protected Ellipsoid ellipsoid = Ellipsoid.WGS_84;
    protected LatLonPoint tmpLL = new LatLonPoint();

    public UTMGCT() {
    }

    public UTMGCT(UTMPoint utmPoint) {
        this.utm = utmPoint;
    }

    public UTMPoint getUtm() {
        return this.utm;
    }

    public void setUtm(UTMPoint utm) {
        this.utm = utm;
    }

    public synchronized Point2D forward(double lat, double lon, Point2D ret) {
        if (this.utm == null) {
            return null;
        }
        this.tmpLL.setLatLon((float)lat, (float)lon);
        UTMPoint.LLtoUTM(this.tmpLL, this.ellipsoid, this.utm);
        ret.setLocation(this.utm.easting, this.utm.northing);
        return ret;
    }

    public synchronized LatLonPoint inverse(double x, double y, LatLonPoint ret) {
        if (this.utm == null) {
            return null;
        }
        this.utm.easting = (float)x;
        this.utm.northing = (float)y;
        UTMPoint.UTMtoLL(this.utm, this.ellipsoid, ret);
        return ret;
    }

    public void setProperties(String propertyPrefix, Properties props) {
        super.setProperties(propertyPrefix, props);
        propertyPrefix = PropUtils.getScopedPropertyPrefix(propertyPrefix);
        float northing = PropUtils.floatFromProperties(props, propertyPrefix + NorthingProperty, 0.0f);
        float easting = PropUtils.floatFromProperties(props, propertyPrefix + EastingProperty, 0.0f);
        int zone = PropUtils.intFromProperties(props, propertyPrefix + ZoneProperty, 0);
        String hString = props.getProperty(propertyPrefix + HemiProperty, "N");
        char hemi = hString.charAt(0);
        this.utm = new UTMPoint(northing, easting, zone, hemi);
        String eName = props.getProperty(propertyPrefix + ElliposoidProperty, "WGS_84");
        this.ellipsoid = Ellipsoid.getByName(eName);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        if (this.utm != null) {
            props.put(prefix + NorthingProperty, Float.toString(this.utm.northing));
            props.put(prefix + EastingProperty, Float.toString(this.utm.easting));
            props.put(prefix + ZoneProperty, Integer.toString(this.utm.zone_number));
            props.put(prefix + HemiProperty, Character.toString(this.utm.zone_letter));
            props.put(prefix + ElliposoidProperty, this.ellipsoid.name.toUpperCase().replace(' ', '_'));
        }
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        return props;
    }

    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    public void setEllipsoid(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
    }
}

