/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj.coords;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Ellipsoid;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.ProjectionLoader;
import com.bbn.openmap.proj.coords.GeoCoordTransformation;
import com.bbn.openmap.proj.coords.LatLonGCT;
import com.bbn.openmap.proj.coords.MercatorMeterGCT;
import com.bbn.openmap.proj.coords.UTMGCT;
import com.bbn.openmap.proj.coords.UTMPoint;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class CoordinateReferenceSystem {
    private GeoCoordTransformation coordTransform;
    private ProjectionLoader projLoader;
    private String projLoaderClassName;
    private Ellipsoid ellipsoid = Ellipsoid.WGS_84;
    private Properties defaultProjectionParameters;
    protected static final Map crss = Collections.synchronizedMap(new TreeMap());
    static /* synthetic */ Class class$com$bbn$openmap$proj$LLXYLoader;
    static /* synthetic */ Class class$com$bbn$openmap$proj$MercatorLoader;
    static /* synthetic */ Class class$com$bbn$openmap$proj$UTMProjectionLoader;

    private static void addUtms() {
        for (int zone = 1; zone <= 60; ++zone) {
            String zoneCode = String.valueOf(zone);
            while (zoneCode.length() < 2) {
                zoneCode = "0" + zoneCode;
            }
            CoordinateReferenceSystem.addUtm("EPSG:326" + zoneCode, zone, 'N', Ellipsoid.WGS_84);
            CoordinateReferenceSystem.addUtm("EPSG:327" + zoneCode, zone, 'S', Ellipsoid.WGS_84);
        }
    }

    private static void addUtm(String epsg, int zone_number, char zone_letter, Ellipsoid ellps) {
        Properties projProps = new Properties();
        projProps.put("ZONE_NUMBER", Integer.toString(zone_number));
        projProps.put("ZONE_LETTER", Character.toString(zone_letter));
        projProps.put("ELLIPSOID", ellps);
        UTMPoint utmp = new UTMPoint(0.0f, 0.0f, zone_number, zone_letter);
        UTMGCT gct = new UTMGCT(utmp);
        gct.setEllipsoid(ellps);
        crss.put(epsg, new CoordinateReferenceSystem(gct, class$com$bbn$openmap$proj$UTMProjectionLoader == null ? (class$com$bbn$openmap$proj$UTMProjectionLoader = CoordinateReferenceSystem.class$("com.bbn.openmap.proj.UTMProjectionLoader")) : class$com$bbn$openmap$proj$UTMProjectionLoader, ellps, projProps));
    }

    public CoordinateReferenceSystem(GeoCoordTransformation coordConverter, Class projLoaderClass, Ellipsoid ellipsoid) {
        this.coordTransform = coordConverter;
        this.projLoaderClassName = projLoaderClass.getName();
        this.ellipsoid = ellipsoid;
        this.defaultProjectionParameters = new Properties();
    }

    public CoordinateReferenceSystem(GeoCoordTransformation coordConverter, Class projLoaderClass, Ellipsoid ellipsoid, Properties projectionParameters) {
        this.coordTransform = coordConverter;
        this.projLoaderClassName = projLoaderClass.getName();
        this.ellipsoid = ellipsoid;
        this.defaultProjectionParameters = projectionParameters;
    }

    public static CoordinateReferenceSystem getForCode(String code) {
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)crss.get(code);
        return crs;
    }

    public static Collection getCodes() {
        return crss.keySet();
    }

    protected ProjectionLoader projectionLoader() {
        if (this.projLoader != null) {
            return this.projLoader;
        }
        try {
            Class<?> cl = Class.forName(this.projLoaderClassName);
            Object o = cl.newInstance();
            this.projLoader = (ProjectionLoader)o;
            return this.projLoader;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public Proj createProjection(Properties overrideProjectionParameters) {
        Properties projectionParameters = new Properties();
        projectionParameters.putAll((Map<?, ?>)this.defaultProjectionParameters);
        projectionParameters.putAll((Map<?, ?>)overrideProjectionParameters);
        return (Proj)this.projectionLoader().create(projectionParameters);
    }

    public void prepareProjection(Proj proj) {
        proj.setPlanetRadius((float)this.ellipsoid.radius);
    }

    public LatLonPoint inverse(double x, double y) {
        return this.coordTransform.inverse(x, y);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        crss.put("EPSG:4326", new CoordinateReferenceSystem(LatLonGCT.INSTANCE, class$com$bbn$openmap$proj$LLXYLoader == null ? (class$com$bbn$openmap$proj$LLXYLoader = CoordinateReferenceSystem.class$("com.bbn.openmap.proj.LLXYLoader")) : class$com$bbn$openmap$proj$LLXYLoader, Ellipsoid.WGS_84));
        crss.put("CRS:84", new CoordinateReferenceSystem(LatLonGCT.INSTANCE, class$com$bbn$openmap$proj$LLXYLoader == null ? (class$com$bbn$openmap$proj$LLXYLoader = CoordinateReferenceSystem.class$("com.bbn.openmap.proj.LLXYLoader")) : class$com$bbn$openmap$proj$LLXYLoader, Ellipsoid.WGS_84));
        crss.put("EPSG:54004", new CoordinateReferenceSystem(MercatorMeterGCT.INSTANCE, class$com$bbn$openmap$proj$MercatorLoader == null ? (class$com$bbn$openmap$proj$MercatorLoader = CoordinateReferenceSystem.class$("com.bbn.openmap.proj.MercatorLoader")) : class$com$bbn$openmap$proj$MercatorLoader, Ellipsoid.WGS_84));
        crss.put("AUTO:41001", new CoordinateReferenceSystem(MercatorMeterGCT.INSTANCE, class$com$bbn$openmap$proj$MercatorLoader == null ? (class$com$bbn$openmap$proj$MercatorLoader = CoordinateReferenceSystem.class$("com.bbn.openmap.proj.MercatorLoader")) : class$com$bbn$openmap$proj$MercatorLoader, Ellipsoid.WGS_84));
        crss.put("OSGEO:41001", new CoordinateReferenceSystem(MercatorMeterGCT.INSTANCE, class$com$bbn$openmap$proj$MercatorLoader == null ? (class$com$bbn$openmap$proj$MercatorLoader = CoordinateReferenceSystem.class$("com.bbn.openmap.proj.MercatorLoader")) : class$com$bbn$openmap$proj$MercatorLoader, Ellipsoid.WGS_84));
        CoordinateReferenceSystem.addUtms();
    }
}

