/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.OMComponent;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.proj.ProjectionStackSupport;
import com.bbn.openmap.proj.ProjectionStackTrigger;
import com.bbn.openmap.util.Debug;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;

public class ProjectionStack
extends OMComponent
implements ActionListener,
ProjectionListener {
    public static final int DEFAULT_MAX_SIZE = 10;
    public static final int REMEMBER_ALL = -1;
    protected transient ProjHolder currentProjection;
    protected transient String currentProjectionID;
    protected transient Container face;
    protected transient MapBean mapBean;
    protected int stackSize = 10;
    public static final transient String BackProjCmd = "backProjection";
    public static final transient String ForwardProjCmd = "forwardProjection";
    public static final transient String ClearBackStackCmd = "clearBackStack";
    public static final transient String ClearForwardStackCmd = "clearForwardStack";
    public static final transient String ClearStacksCmd = "clearStacks";
    protected Stack backStack;
    protected Stack forwardStack;
    protected ProjectionStackSupport triggers;

    public void setMapBean(MapBean map) {
        if (this.mapBean != null) {
            this.mapBean.removeProjectionListener(this);
        }
        if (map != null) {
            map.addProjectionListener(this);
        }
        this.mapBean = map;
    }

    public MapBean getMapBean() {
        return this.mapBean;
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand().intern();
        Debug.message("projectionstack", "ProjectionStack.actionPerformed(): " + command);
        boolean changeProjection = false;
        if (command == BackProjCmd && this.backStack != null && this.backStack.size() > 1) {
            this.pop();
            this.currentProjection = (ProjHolder)this.backStack.peek();
            changeProjection = true;
        } else if (command == ForwardProjCmd && this.forwardStack != null && !this.forwardStack.empty()) {
            this.currentProjection = this.backPop();
            changeProjection = true;
        } else {
            this.clearStacks(command == ClearBackStackCmd || command == ClearStacksCmd, command == ClearForwardStackCmd || command == ClearStacksCmd);
        }
        if (changeProjection && this.mapBean != null) {
            if (Debug.debugging("projectionstack")) {
                Debug.output("ProjectionStack.actionPerformed() changing mapbean projection to : " + this.currentProjection);
            }
            Projection currProj = this.currentProjection.create(this.mapBean.getWidth(), this.mapBean.getHeight());
            this.mapBean.setProjection(currProj);
            this.fireStackStatus();
        }
    }

    public void projectionChanged(ProjectionEvent e) {
        if (Debug.debugging("projectionstack")) {
            System.out.println("ProjectionStack.projectionChanged()");
        }
        Projection newProj = e.getProjection();
        if (this.currentProjection == null || !this.currentProjection.equals(newProj)) {
            Debug.message("projectionstack", "ProjectionStack.projectionChanged() pushing projection on backStack");
            this.currentProjection = this.push(new ProjHolder(newProj));
            if (this.forwardStack != null) {
                this.forwardStack.clear();
            }
            this.fireStackStatus();
        } else {
            Debug.message("projectionstack", "ProjectionStack.projectionChanged() new projection matches current projection, no action.");
        }
    }

    public synchronized void clearStacks(boolean clearBackStack, boolean clearForwardStack) {
        if (clearBackStack && this.backStack != null) {
            ProjHolder currentProj = this.pop();
            this.backStack.clear();
            this.push(currentProj);
        }
        if (clearForwardStack && this.forwardStack != null) {
            this.forwardStack.clear();
        }
        this.fireStackStatus();
    }

    protected synchronized ProjHolder pop() {
        ProjHolder proj = (ProjHolder)this.backStack.pop();
        if (this.forwardStack == null) {
            this.forwardStack = new Stack();
        }
        while (this.forwardStack.size() >= this.stackSize) {
            this.forwardStack.removeElementAt(0);
        }
        this.forwardStack.push(proj);
        return proj;
    }

    protected synchronized ProjHolder backPop() {
        ProjHolder proj = (ProjHolder)this.forwardStack.pop();
        if (this.backStack == null) {
            this.backStack = new Stack();
        }
        while (this.backStack.size() >= this.stackSize) {
            this.backStack.removeElementAt(0);
        }
        this.backStack.push(proj);
        return proj;
    }

    protected synchronized ProjHolder push(ProjHolder proj) {
        if (this.backStack == null) {
            this.backStack = new Stack();
        }
        if (this.backStack.size() >= this.stackSize) {
            this.backStack.removeElementAt(0);
        }
        return this.backStack.push(proj);
    }

    public void fireStackStatus() {
        this.fireStackStatus(this.backStack != null && this.backStack.size() > 1, this.forwardStack != null && !this.forwardStack.empty());
    }

    public void fireStackStatus(boolean enableBackButton, boolean enableForwardButton) {
        if (this.triggers != null) {
            if (Debug.debugging("projectionstack")) {
                Debug.output("ProjectionStack.fireStackStatus(" + enableBackButton + ", " + enableForwardButton + ")");
            }
            this.triggers.fireStackStatus(enableBackButton, enableForwardButton);
        }
    }

    public void addProjectionStackTrigger(ProjectionStackTrigger trigger) {
        trigger.addActionListener(this);
        if (this.triggers == null) {
            this.triggers = new ProjectionStackSupport();
        }
        this.triggers.add(trigger);
        trigger.updateProjectionStackStatus(this.backStack != null && this.backStack.size() > 1, this.forwardStack != null && !this.forwardStack.empty());
    }

    public void removeProjectionStackTrigger(ProjectionStackTrigger trigger) {
        trigger.removeActionListener(this);
        if (this.triggers != null) {
            this.triggers.remove(trigger);
            if (this.triggers.size() == 0) {
                this.triggers = null;
            }
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof MapBean) {
            Debug.message("projectionstack", "ProjectionStack removing a MapBean.");
            MapBean map = this.getMapBean();
            if (map != null && map == (MapBean)someObj) {
                this.setMapBean(null);
            }
        }
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof MapBean) {
            Debug.message("projectionstack", "ProjectionStack found a MapBean.");
            this.setMapBean((MapBean)someObj);
        }
    }

    public class ProjHolder {
        public Class projClass;
        public float scale;
        public LatLonPoint center;
        protected Point tmpPoint1;
        protected Point tmpPoint2;

        public ProjHolder(Projection proj) {
            this.projClass = proj.getClass();
            this.scale = proj.getScale();
            this.center = proj.getCenter();
        }

        public boolean equals(Projection proj) {
            Point tmpPoint1 = proj.forward(proj.getCenter());
            Point tmpPoint2 = proj.forward(this.center);
            boolean same = this.projClass == proj.getClass() && this.scale == proj.getScale() && tmpPoint1.x == tmpPoint2.x && tmpPoint1.y == tmpPoint2.y;
            return same;
        }

        public Projection create(int width, int height) {
            return ProjectionFactory.makeProjection(this.projClass, this.center.getLatitude(), this.center.getLongitude(), this.scale, width, height);
        }

        public String toString() {
            return "[ProjHolder: class(" + this.projClass.getName() + "), scale(" + this.scale + "), center(" + this.center + ")]";
        }
    }
}

