/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.proj;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.proj.Mercator;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.util.Debug;
import java.awt.Point;

public class MercatorView
extends Mercator {
    public static final transient String MercatorViewName = "MercatorView";
    public static final transient int MercatorViewType = 22;
    private MercatorViewHelper helper;
    protected LatLonPoint uCtr;
    protected float uCtrLat;
    protected float uCtrLon;
    protected int sCtrX;
    protected int sCtrY;
    protected int uCtrX;
    protected int uCtrY;
    protected int dUSX;
    protected int dUSY;

    public MercatorView(LatLonPoint center, float scale, int width, int height) {
        super(center, scale, width, height, 22);
        this.computeParameters();
    }

    public String toString() {
        return "MercatorView[" + super.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeParameters() {
        Debug.message("mercatorview", "MercatorView.computeParameters()");
        if (this.uCtr == null) {
            this.uCtrLat = 0.0f;
            this.uCtrLon = 0.0f;
            this.uCtr = new LatLonPoint(this.uCtrLat, this.uCtrLon);
        }
        if (this.helper == null) {
            this.helper = new MercatorViewHelper(this.uCtr, this.scale, this.width, this.height);
        }
        MercatorViewHelper mercatorViewHelper = this.helper;
        synchronized (mercatorViewHelper) {
            super.computeParameters();
            Point temp = new Point();
            this.helper.setAllParams(this.pixelsPerMeter, this.planetRadius, this.planetPixelRadius, this.planetPixelCircumference, this.minscale, this.maxscale, this.scale, this.scaled_radius, this.width, this.height, this.uCtrLat, this.uCtrLon);
            this.helper.forward(this.ctrLat, this.ctrLon, temp, true);
            this.sCtrX = temp.x;
            this.sCtrY = temp.y;
            this.helper.forward(this.uCtrLat, this.uCtrLon, temp);
            this.uCtrX = temp.x;
            this.uCtrY = temp.y;
            this.dUSX = this.sCtrX - this.uCtrX;
            this.dUSY = this.sCtrY - this.uCtrY;
        }
        Debug.message("mercatorview", "User Center LL: " + this.uCtrLon + "," + this.uCtrLat + " User Center xy: " + this.uCtrX + "," + this.uCtrY + " Screen Center LL: " + ProjMath.radToDeg(this.ctrLon) + "," + ProjMath.radToDeg(this.ctrLat) + " Screen Center xy: " + this.sCtrX + "," + this.sCtrY + " Screen wh: " + this.width + "x" + this.height + " Screen halfwh: " + this.wx + "x" + this.hy + " Delta xy: " + this.dUSX + "," + this.dUSY);
    }

    public Point forward(LatLonPoint pt, Point p) {
        this.helper.forward(pt, p);
        Debug.message("mercatorview-f", "forward llp,p: " + pt.getLongitude() + "," + pt.getLatitude() + " merc xy: " + p.x + "," + p.y);
        p.x = p.x + this.wx - this.dUSX;
        p.y = this.hy - p.y + this.dUSY;
        Debug.message("mercatorview-f", "forward llp,p: " + pt.getLongitude() + "," + pt.getLatitude() + " view xy: " + p.x + "," + p.y);
        return p;
    }

    public Point forward(float lat, float lon, Point p) {
        this.helper.forward(lat, lon, p);
        Debug.message("mercatorview-f", "forward l,l,p: " + lon + "," + lat + " merc xy: " + p.x + "," + p.y);
        p.x = p.x + this.wx - this.dUSX;
        p.y = this.hy - p.y + this.dUSY;
        Debug.message("mercatorview-f", "forward l,l,p: " + lon + "," + lat + " view xy: " + p.x + "," + p.y);
        return p;
    }

    public Point forward(float lat, float lon, Point p, boolean isRadian) {
        this.helper.forward(lat, lon, p, isRadian);
        Debug.message("mercatorview-f", "forward l,l,p,i: " + ProjMath.radToDeg(lon) + "," + ProjMath.radToDeg(lat) + " merc xy: " + p.x + "," + p.y);
        p.x = p.x + this.wx - this.dUSX;
        p.y = this.hy - p.y + this.dUSY;
        Debug.message("mercatorview-f", "forward l,l,p,i: " + ProjMath.radToDeg(lon) + "," + ProjMath.radToDeg(lat) + " view xy: " + p.x + "," + p.y);
        return p;
    }

    public LatLonPoint inverse(Point pt, LatLonPoint llp) {
        int x = pt.x - this.wx + this.dUSX;
        int y = this.hy - pt.y + this.dUSY;
        Debug.message("mercatorview-i", "pt: " + pt.x + "," + pt.y + "xy: " + x + "," + y);
        return this.helper.inverse(x, y, llp);
    }

    public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
        int tx = x - this.wx + this.dUSX;
        int ty = this.hy - y + this.dUSY;
        LatLonPoint tllp = this.helper.inverse(tx, ty, llp);
        Debug.message("mercatorview-i", "xy: " + x + "," + y + " txty: " + tx + "," + ty + " llp: " + tllp.getLongitude() + "," + tllp.getLatitude());
        return this.helper.inverse(tx, ty, llp);
    }

    private class MercatorViewHelper
    extends Mercator {
        public MercatorViewHelper(LatLonPoint center, float scale, int width, int height) {
            super(center, scale, width, height, 2);
        }

        public void setAllParams(int hPixelsPerMeter, float hPlanetRadius, float hPlanetPixelRadius, float hPlanetPixelCircumference, float hMinscale, float hMaxscale, float hScale, float hScaled_radius, int hWidth, int hHeight, float hCtrLat, float hCtrLon) {
            this.pixelsPerMeter = hPixelsPerMeter;
            this.planetRadius = hPlanetRadius;
            this.planetPixelRadius = hPlanetPixelRadius;
            this.planetPixelCircumference = hPlanetPixelCircumference;
            this.minscale = hMinscale;
            this.maxscale = hMaxscale;
            this.scale = hScale;
            this.scaled_radius = hScaled_radius;
            this.width = hWidth;
            this.height = hHeight;
            this.ctrLat = hCtrLat;
            this.ctrLon = hCtrLon;
            this.computeParameters();
        }

        public String toString() {
            return "MercatorViewHelper[" + super.toString();
        }

        public Point forward(LatLonPoint pt, Point p) {
            super.forward(pt, p);
            Debug.message("mercatorview-f", "forward l,l,p: " + pt.getLongitude() + "," + pt.getLatitude() + " help xy: " + p.x + "," + p.y);
            p.x -= this.wx;
            p.y = this.hy - p.y;
            return p;
        }

        public Point forward(float lat, float lon, Point p) {
            super.forward(lat, lon, p);
            Debug.message("mercatorview-f", "forward l,l,p: " + lon + "," + lat + " help xy: " + p.x + "," + p.y);
            p.x -= this.wx;
            p.y = this.hy - p.y;
            return p;
        }

        public Point forward(float lat, float lon, Point p, boolean isRadian) {
            super.forward(lat, lon, p, isRadian);
            Debug.message("mercatorview-f", "forward l,l,p: " + ProjMath.radToDeg(lon) + "," + ProjMath.radToDeg(lat) + " help xy: " + p.x + "," + p.y);
            p.x -= this.wx;
            p.y = this.hy - p.y;
            return p;
        }

        public LatLonPoint inverse(Point pt, LatLonPoint llp) {
            int x = pt.x + this.wx;
            int y = this.hy - pt.y;
            return super.inverse(x, y, llp);
        }

        public LatLonPoint inverse(int x, int y, LatLonPoint llp) {
            y = this.hy - y;
            return super.inverse(x += this.wx, y, llp);
        }
    }
}

