/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin.earthImage;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.image.BufferedImageHelper;
import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.plugin.AbstractPlugIn;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;

public class EarthImagePlugIn
extends AbstractPlugIn
implements ImageServerConstants {
    protected BufferedImage bi = null;
    protected ImageTranslator it = null;
    public static final String ImageProperty = "image";
    protected String imageString = null;

    public EarthImagePlugIn() {
    }

    public EarthImagePlugIn(Component comp) {
        super(comp);
    }

    public OMGraphicList getRectangle(Projection p) {
        OMGraphicList list = new OMGraphicList();
        if (this.bi == null && this.it == null) {
            return list;
        }
        OMRaster ras = null;
        if (this.it == null) {
            this.it = new ImageTranslator(this.bi);
            this.bi = null;
        }
        if ((ras = this.it.getImage(p)) != null) {
            list.add(ras);
        }
        list.generate(p);
        return list;
    }

    public void setProperties(String prefix, Properties setList) {
        super.setProperties(prefix, setList);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.imageString = setList.getProperty(realPrefix + ImageProperty);
        if (this.imageString == null || this.imageString.equals("")) {
            Debug.error("EarthImagePlugIn needs an image.");
            Debug.output(setList.toString());
            return;
        }
        if (Debug.debugging("earthimage")) {
            Debug.output("EarthImagePlugIn:  fetching " + realPrefix + ImageProperty + " : " + this.imageString);
        }
        try {
            URL url = PropUtils.getResourceOrFileOrURL(this, this.imageString);
            this.bi = BufferedImageHelper.getBufferedImage(url, 0, 0, -1, -1);
            if (Debug.debugging("earthimage") && this.bi != null) {
                Debug.output("EarthImagePlugIn: buffered image OK");
            }
        }
        catch (MalformedURLException murle) {
            Debug.error("EarthImagePlugIn: image path is not good: " + this.imageString);
        }
        catch (InterruptedException ie) {
            Debug.error("EarthImagePlugIn: problem reading image from path: " + this.imageString);
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + ImageProperty, this.imageString == null ? "" : this.imageString);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.put(ImageProperty, "Path to image file (URL, resource or file)");
        props.put("image.editor", "com.bbn.openmap.util.propertyEditor.FUPropertyEditor");
        props.put("initProperties", ImageProperty);
        return props;
    }

    public class ImageTranslator {
        protected int[] pixels = null;
        public int iwidth;
        public int iheight;
        public float hor_dpp;
        public float ver_dpp;
        public int verOrigin;
        public int horOrigin;
        int[] tmpPixels = new int[0];

        public ImageTranslator(BufferedImage bi) {
            if (bi != null) {
                this.iwidth = bi.getWidth();
                this.iheight = bi.getHeight();
                this.verOrigin = this.iheight / 2;
                this.horOrigin = this.iwidth / 2;
                this.hor_dpp = 360.0f / (float)this.iwidth;
                this.ver_dpp = 180.0f / (float)this.iheight;
                if (Debug.debugging("earthimage")) {
                    Debug.output("ImageTranslator: getting image pixels w:" + this.iwidth + ", h:" + this.iheight + "\n     hor dpp:" + this.hor_dpp + ", ver dpp:" + this.ver_dpp);
                }
                this.pixels = this.getPixels(bi, 0, 0, this.iwidth, this.iheight);
                bi = null;
            }
        }

        public OMRaster getImage(Projection p) {
            if (this.pixels != null && p != null) {
                int projHeight = p.getHeight();
                int projWidth = p.getWidth();
                if (this.tmpPixels.length != projWidth * projHeight) {
                    this.tmpPixels = new int[projWidth * projHeight];
                }
                int clear = 0;
                Point ctp = new Point();
                LatLonPoint llp = new LatLonPoint();
                LatLonPoint center = p.getCenter();
                for (int i = 0; i < projWidth; ++i) {
                    for (int j = 0; j < projHeight; ++j) {
                        int imageIndex;
                        p.inverse(i, j, llp);
                        int tmpIndex = i + j * projWidth;
                        if (llp.equals(center)) {
                            p.forward(llp, ctp);
                            if (ctp.x != i || ctp.y != j) {
                                this.tmpPixels[tmpIndex] = clear;
                                continue;
                            }
                        }
                        int horIndex = this.horOrigin + (int)(llp.getLongitude() / this.hor_dpp);
                        int verIndex = this.verOrigin - (int)(llp.getLatitude() / this.ver_dpp);
                        if (horIndex < 0 || horIndex >= this.iwidth || verIndex < 0 || verIndex >= this.iheight || (imageIndex = horIndex + verIndex * this.iwidth) < 0 || imageIndex >= this.pixels.length) continue;
                        this.tmpPixels[tmpIndex] = this.pixels[imageIndex];
                    }
                }
                Debug.message("earthimage", "ImageTranslator: finished creating image");
                return new OMRaster(0, 0, projWidth, projHeight, this.tmpPixels);
            }
            Debug.message("earthimage", "ImageTranslator: problem creating image");
            return null;
        }

        protected int[] getPixels(Image img, int x, int y, int w, int h) {
            int[] pixels = new int[w * h];
            PixelGrabber pg = new PixelGrabber(img, x, y, w, h, pixels, 0, w);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                Debug.error("ImageTranslator: interrupted waiting for pixels!");
                return new int[0];
            }
            if ((pg.getStatus() & 0x80) != 0) {
                System.err.println("ImageTranslator: image fetch aborted or errored");
                return new int[0];
            }
            return pixels;
        }
    }
}

