/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.plugin;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.Layer;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.SelectMouseMode;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.plugin.PlugIn;
import com.bbn.openmap.plugin.PlugInLayer;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Properties;

public abstract class AbstractPlugIn
implements PlugIn,
PropertyConsumer,
MapMouseListener {
    public static final String RemovableProperty = "removable";
    protected boolean removable = true;
    protected Component component = null;
    protected String prefix = null;
    protected String name = this.getClass().getName();
    protected MapMouseListener mml = this;
    protected boolean addToBeanContext = true;
    public I18n i18n = Environment.getI18n();
    static /* synthetic */ Class class$com$bbn$openmap$Layer;
    static /* synthetic */ Class class$com$bbn$openmap$plugin$AbstractPlugIn;

    public AbstractPlugIn() {
    }

    public AbstractPlugIn(Component comp) {
        this.setComponent(comp);
    }

    public void setName(String name) {
        this.name = name;
        Component comp = this.getComponent();
        if (comp != null) {
            comp.setName(name);
        }
    }

    public String getName() {
        Component comp = this.getComponent();
        if (comp != null) {
            this.name = comp.getName();
        }
        return this.name;
    }

    public void setComponent(Component comp) {
        this.component = comp;
    }

    public Component getComponent() {
        return this.component;
    }

    public void repaint() {
        this.component.repaint();
    }

    public void doPrepare() {
        if (this.component instanceof PlugInLayer) {
            ((PlugInLayer)this.component).doPrepare();
        }
    }

    public void setMapMouseListener(MapMouseListener mml) {
        this.mml = mml;
    }

    public MapMouseListener getMapMouseListener() {
        return this.mml;
    }

    public abstract OMGraphicList getRectangle(Projection var1);

    public Component getGUI() {
        return null;
    }

    public void setAddToBeanContext(boolean value) {
        this.addToBeanContext = value;
    }

    public boolean getAddToBeanContext() {
        return this.addToBeanContext;
    }

    public void setRemovable(boolean set) {
        this.removable = set;
        Component comp = this.getComponent();
        if (comp != null && comp instanceof Layer) {
            ((Layer)comp).setRemovable(set);
        }
    }

    public boolean isRemovable() {
        Component comp = this.getComponent();
        if (comp != null && comp instanceof Layer) {
            this.removable = ((Layer)comp).isRemovable();
        }
        return this.removable;
    }

    public void setProperties(Properties setList) {
        this.setProperties(null, setList);
    }

    public void setProperties(String prefix, Properties setList) {
        this.setPropertyPrefix(prefix);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.name = setList.getProperty(realPrefix + "prettyName");
        this.setAddToBeanContext(PropUtils.booleanFromProperties(setList, realPrefix + "addToBeanContext", this.addToBeanContext));
        this.setRemovable(PropUtils.booleanFromProperties(setList, realPrefix + RemovableProperty, this.removable));
    }

    public Properties getProperties(Properties getList) {
        if (getList == null) {
            getList = new Properties();
        }
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        getList.put(realPrefix + "addToBeanContext", new Boolean(this.addToBeanContext).toString());
        getList.put(this.prefix + RemovableProperty, new Boolean(this.removable).toString());
        return getList;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        String internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = AbstractPlugIn.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, "addToBeanContext", 3, "Flag to give access to all of the other application components.");
        list.put("addToBeanContext", internString);
        internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = AbstractPlugIn.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, "addToBeanContext", "Add to MapHandler");
        list.put("addToBeanContext.label", internString);
        list.put("addToBeanContext.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        internString = this.i18n.get(class$com$bbn$openmap$plugin$AbstractPlugIn == null ? (class$com$bbn$openmap$plugin$AbstractPlugIn = AbstractPlugIn.class$("com.bbn.openmap.plugin.AbstractPlugIn")) : class$com$bbn$openmap$plugin$AbstractPlugIn, RemovableProperty, 3, "Flag to allow layer to be deleted.");
        list.put(RemovableProperty, internString);
        internString = this.i18n.get(class$com$bbn$openmap$Layer == null ? (class$com$bbn$openmap$Layer = AbstractPlugIn.class$("com.bbn.openmap.Layer")) : class$com$bbn$openmap$Layer, RemovableProperty, "Removable");
        list.put("removable.label", internString);
        list.put("removable.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        return list;
    }

    public void setPropertyPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.prefix;
    }

    public String[] getMouseModeServiceList() {
        return new String[]{SelectMouseMode.modeID};
    }

    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    public void mouseMoved() {
    }

    public void removed() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

