/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.ProjMath;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.Serializable;
import java.util.ArrayList;

public class OMArc
extends OMGraphic
implements Serializable {
    protected int x1 = 0;
    protected int y1 = 0;
    protected int off_x = 0;
    protected int off_y = 0;
    protected LatLonPoint center;
    protected float radius = 0.0f;
    protected int width = 0;
    protected int height = 0;
    protected float start = 0.0f;
    protected float extent = 360.0f;
    protected int arcType = 0;
    private transient GeneralPath polarShapeLine = null;
    private transient boolean correctFill = false;
    private transient boolean correctPolar = false;
    protected int nverts;
    protected double rotationAngle = 0.0;

    public OMArc() {
        super(0, 0, 0);
    }

    public OMArc(float latPoint, float lonPoint, int w, int h, float s, float e) {
        this(latPoint, lonPoint, 0, 0, w, h, s, e);
    }

    public OMArc(int x1, int y1, int w, int h, float s, float e) {
        super(2, 0, 0);
        this.x1 = x1;
        this.y1 = y1;
        this.width = w;
        this.height = h;
        this.start = s;
        this.extent = e;
    }

    public OMArc(float latPoint, float lonPoint, int offset_x1, int offset_y1, int w, int h, float s, float e) {
        super(3, 0, 0);
        this.center = new LatLonPoint(latPoint, lonPoint);
        this.off_x = offset_x1;
        this.off_y = offset_y1;
        this.width = w;
        this.height = h;
        this.start = s;
        this.extent = e;
    }

    public OMArc(float latPoint, float lonPoint, float radius, float s, float e) {
        this(new LatLonPoint(latPoint, lonPoint), radius, Length.DECIMAL_DEGREE, -1, s, e);
    }

    public OMArc(float latPoint, float lonPoint, float radius, Length units, float s, float e) {
        this(new LatLonPoint(latPoint, lonPoint), radius, units, -1, s, e);
    }

    public OMArc(float latPoint, float lonPoint, float radius, Length units, int nverts, float s, float e) {
        this(new LatLonPoint(latPoint, lonPoint), radius, units, nverts, s, e);
    }

    public OMArc(LatLonPoint center, float radius, Length units, int nverts, float s, float e) {
        super(1, 0, 0);
        this.radius = units.toRadians(radius);
        this.center = center;
        this.nverts = nverts;
        this.start = s;
        this.extent = e;
    }

    public int getX() {
        return this.x1;
    }

    public int getY() {
        return this.y1;
    }

    public int getOffX() {
        return this.off_x;
    }

    public int getOffY() {
        return this.off_y;
    }

    public LatLonPoint getLatLon() {
        return this.center;
    }

    public float getRadius() {
        return Length.DECIMAL_DEGREE.fromRadians(this.radius);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getStartAngle() {
        return this.start;
    }

    public float getExtentAngle() {
        return this.extent;
    }

    public int getNumVerts() {
        return this.nverts;
    }

    public void setX(int value) {
        if (this.x1 == value) {
            return;
        }
        this.x1 = value;
        this.setNeedToRegenerate(true);
    }

    public void setY(int value) {
        if (this.y1 == value) {
            return;
        }
        this.y1 = value;
        this.setNeedToRegenerate(true);
    }

    public void setOffX(int value) {
        if (this.off_x == value) {
            return;
        }
        this.off_x = value;
        this.setNeedToRegenerate(true);
    }

    public void setOffY(int value) {
        if (this.off_y == value) {
            return;
        }
        this.off_y = value;
        this.setNeedToRegenerate(true);
    }

    public void setLatLon(float lat, float lon) {
        this.setCenter(new LatLonPoint(lat, lon));
    }

    public void setCenter(LatLonPoint p) {
        if (p.equals(this.center)) {
            return;
        }
        this.center = p;
        this.setNeedToRegenerate(true);
    }

    public LatLonPoint getCenter() {
        return this.center;
    }

    public void setRadius(float radius) {
        this.radius = Length.DECIMAL_DEGREE.toRadians(radius);
        this.setNeedToRegenerate(true);
    }

    public void setRadius(float radius, Length units) {
        this.radius = units.toRadians(radius);
        this.setNeedToRegenerate(true);
    }

    public void setWidth(int value) {
        if (this.width == value) {
            return;
        }
        this.width = value;
        this.setNeedToRegenerate(true);
    }

    public void setHeight(int value) {
        if (this.height == value) {
            return;
        }
        this.height = value;
        this.setNeedToRegenerate(true);
    }

    public void setStart(float value) {
        if (this.start == value) {
            return;
        }
        this.start = value;
        this.setNeedToRegenerate(true);
    }

    public void setExtent(float value) {
        if (this.extent == value) {
            return;
        }
        this.extent = value;
        this.setNeedToRegenerate(true);
    }

    public void setNumVerts(int nverts) {
        this.nverts = nverts;
    }

    public void setArcType(int type) {
        this.arcType = type == 2 || type == 1 ? type : 0;
    }

    public int getArcType() {
        return this.arcType;
    }

    public void setRotationAngle(double angle) {
        this.rotationAngle = angle;
        this.setNeedToRegenerate(true);
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setNeedToRegenerate(boolean value) {
        super.setNeedToRegenerate(value);
        if (value) {
            this.polarShapeLine = null;
            this.correctFill = false;
        }
    }

    public boolean getPolarCorrection() {
        return this.correctPolar;
    }

    public void setPolarCorrection(boolean value) {
        this.correctPolar = value;
        this.setNeedToRegenerate(true);
    }

    protected boolean shouldCenterBeInShape() {
        return this.arcType == 2;
    }

    public boolean generate(Projection proj) {
        this.setShape(null);
        this.polarShapeLine = null;
        this.correctFill = false;
        if (proj == null) {
            Debug.message("omgraphic", "OMArc: null projection in generate!");
            return false;
        }
        AffineTransform af = null;
        switch (this.renderType) {
            case 3: {
                if (!proj.isPlotable(this.center)) {
                    this.setNeedToRegenerate(true);
                    return false;
                }
                Point p1 = proj.forward(this.center.radlat_, this.center.radlon_, new Point(), true);
                this.x1 = p1.x + this.off_x;
                this.y1 = p1.y + this.off_y;
            }
            case 2: {
                float fwidth = this.width;
                float fheight = this.height;
                float transx = this.x1;
                float transy = this.y1;
                float x = transx - fwidth / 2.0f;
                float y = transy - fheight / 2.0f;
                Shape arcShape = this.createArcShape(x, y, fwidth, fheight);
                if (this.rotationAngle != 0.0) {
                    af = new AffineTransform();
                    af.rotate(this.rotationAngle, transx, transy);
                }
                PathIterator pi = arcShape.getPathIterator(af);
                GeneralPath gp = new GeneralPath();
                gp.append(pi, false);
                this.setShape(gp);
                break;
            }
            case 1: {
                ArrayList coordLists = this.getCoordLists(proj, this.center, this.radius, this.nverts);
                Point p = proj.forward(this.center.radlat_, this.center.radlon_, new Point(), true);
                this.x1 = p.x;
                this.y1 = p.y;
                int size = coordLists.size();
                GeneralPath tempShape = null;
                for (int i = 0; i < size; i += 2) {
                    int[] xpoints = (int[])coordLists.get(i);
                    int[] ypoints = (int[])coordLists.get(i + 1);
                    GeneralPath gp = OMArc.createShape(xpoints, ypoints, this.arcType != 0 || this.arcType == 0 && !OMArc.isClear(this.fillPaint));
                    if (this.shape == null) {
                        this.setShape(gp);
                    } else {
                        this.shape.append(gp, false);
                    }
                    boolean bl = this.correctFill = proj instanceof Cylindrical && (this.shouldCenterBeInShape() && this.shape != null && !this.shape.contains(this.x1, this.y1) || this.correctPolar);
                    if (!this.correctFill) continue;
                    int[][] alts = this.doPolarFillCorrection(xpoints, ypoints, this.center.radlat_ > 0.0f ? -1 : proj.getWidth() + 1);
                    int gp2length = alts[0].length - 2;
                    GeneralPath gp1 = OMArc.createShape(alts[0], alts[1], true);
                    GeneralPath gp2 = OMArc.createShape(alts[0], alts[1], 0, gp2length, false);
                    if (tempShape == null || this.polarShapeLine == null) {
                        tempShape = gp1;
                        this.polarShapeLine = gp2;
                        continue;
                    }
                    tempShape.append(gp1, false);
                    this.polarShapeLine.append(gp2, false);
                }
                if (tempShape == null) break;
                this.setShape(tempShape);
                break;
            }
            case 0: {
                System.err.println("OMArc.generate(): invalid RenderType");
                return false;
            }
        }
        this.setNeedToRegenerate(false);
        return true;
    }

    protected Shape createArcShape(float x, float y, float fwidth, float fheight) {
        return new Arc2D.Float(x, y, fwidth, fheight, this.start, this.extent, this.arcType);
    }

    protected ArrayList getCoordLists(Projection proj, LatLonPoint center, float radius, int nverts) {
        int at = this.arcType == 0 && !OMArc.isClear(this.fillPaint) ? 1 : this.arcType;
        return proj.forwardArc(center, true, radius, nverts, ProjMath.degToRad(this.start), ProjMath.degToRad(this.extent), at);
    }

    public GeneralPath getPolarShapeLine() {
        return this.polarShapeLine;
    }

    private int[][] doPolarFillCorrection(int[] xpoints, int[] ypoints, int y1) {
        int[][] ret = new int[2][];
        int len = xpoints.length;
        int[] alt_xpts = new int[len + 2];
        int[] alt_ypts = new int[len + 2];
        System.arraycopy(xpoints, 0, alt_xpts, 0, len);
        System.arraycopy(ypoints, 0, alt_ypts, 0, len);
        alt_xpts[len] = alt_xpts[len - 1];
        alt_xpts[len + 1] = alt_xpts[0];
        alt_ypts[len] = y1;
        alt_ypts[len + 1] = alt_ypts[len];
        ret[0] = alt_xpts;
        ret[1] = alt_ypts;
        return ret;
    }

    public void render(Graphics g) {
        if (!this.isRenderable()) {
            return;
        }
        if (!this.correctFill) {
            super.render(g);
        } else {
            if (this.shouldRenderFill()) {
                this.setGraphicsForFill(g);
                this.fill(g);
            }
            if (this.shouldRenderEdge()) {
                this.setGraphicsForEdge(g);
                ((Graphics2D)g).draw(this.polarShapeLine);
            }
        }
    }
}

