/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.gui.WindowSupport;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.BufferedImageRenderPolicy;
import com.bbn.openmap.layer.policy.ListResetPCPolicy;
import com.bbn.openmap.layer.vpf.LayerGraphicWarehouseSupport;
import com.bbn.openmap.layer.vpf.LibraryBean;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.layer.vpf.VPFConfig;
import com.bbn.openmap.layer.vpf.VPFFeatureGraphicWarehouse;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFLayerDCWWarehouse;
import com.bbn.openmap.layer.vpf.VPFLayerGraphicWarehouse;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.beancontext.BeanContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VPFLayer
extends OMGraphicHandlerLayer
implements ProjectionListener,
ActionListener,
Serializable {
    public static final String pathProperty = "vpfPath";
    public static final String coverageTypeProperty = "coverageType";
    public static final String featureTypesProperty = "featureTypes";
    public static final String defaultLayerProperty = "defaultLayer";
    public static final String searchByFeatureProperty = "searchByFeature";
    public static final String libraryProperty = "libraryBean";
    public static final String cutoffScaleProperty = "cutoffScale";
    public static final String LibraryNameProperty = "libraryName";
    protected transient LibrarySelectionTable lst;
    protected transient LayerGraphicWarehouseSupport warehouse;
    protected boolean searchByFeatures = false;
    protected String libraryBeanName = null;
    protected String prefix;
    protected Properties props;
    protected String[] dataPaths = null;
    protected String coverageType = "po";
    protected int cutoffScale = 31000000;
    protected String libraryName = null;
    private static Properties defaultProps;
    private transient JPanel box;
    public static final String ConfigCmd = "CONFIGURE";
    protected WindowSupport configWindowSupport = null;
    static /* synthetic */ Class class$com$bbn$openmap$layer$vpf$VPFLayer;

    public VPFLayer() {
        this.setProjectionChangePolicy(new ListResetPCPolicy(this));
        this.setRenderPolicy(new BufferedImageRenderPolicy(this));
        this.setMouseModeIDsForEvents(new String[]{"Gestures"});
    }

    public VPFLayer(String name) {
        this();
        this.setName(name);
    }

    public void setFeatures(String features) {
        this.warehouse.setFeatures(features);
    }

    public void setProperties(String prefix, Properties props) {
        String defaultProperty;
        super.setProperties(prefix, props);
        this.setAddToBeanContext(true);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.cutoffScale = PropUtils.intFromProperties(props, realPrefix + cutoffScaleProperty, this.cutoffScale);
        this.libraryBeanName = props.getProperty(realPrefix + libraryProperty, this.libraryBeanName);
        this.libraryName = props.getProperty(realPrefix + LibraryNameProperty, this.libraryName);
        String[] path = PropUtils.initPathsFromProperties(props, realPrefix + pathProperty);
        if (path != null && path.length != 0) {
            this.setPath(path);
        }
        if ((defaultProperty = props.getProperty(realPrefix + defaultLayerProperty)) != null) {
            prefix = defaultProperty;
            props = VPFLayer.getDefaultProperties();
        }
        this.prefix = prefix;
        this.props = props;
        String coverage = props.getProperty(realPrefix + coverageTypeProperty);
        if (coverage != null) {
            this.setDataTypes(coverage);
        }
        this.searchByFeatures = PropUtils.booleanFromProperties(props, realPrefix + searchByFeatureProperty, this.searchByFeatures);
        this.checkWarehouse(this.searchByFeatures);
        if (this.warehouse != null) {
            this.warehouse.setProperties(prefix, props);
            this.warehouse.setUseLibrary(this.libraryName);
            this.box = null;
            this.resetPalette();
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(realPrefix + cutoffScaleProperty, Integer.toString(this.cutoffScale));
        if (this.libraryBeanName != null) {
            props.put(realPrefix + libraryProperty, this.libraryBeanName);
        } else {
            StringBuffer paths = new StringBuffer();
            String[] ps = this.getPath();
            for (int i = 0; ps != null && i < ps.length; ++i) {
                paths.append(ps[i]);
                if (i >= ps.length - 1) continue;
                paths.append(";");
            }
            props.put(realPrefix + pathProperty, paths.toString());
        }
        this.libraryName = props.getProperty(realPrefix + LibraryNameProperty, this.libraryName);
        props.put(realPrefix + coverageTypeProperty, this.getDataTypes());
        props.put(realPrefix + searchByFeatureProperty, Boolean.toString(this.searchByFeatures));
        if (this.warehouse != null) {
            this.warehouse.getProperties(props);
        }
        return props;
    }

    public static Properties getDefaultProperties() {
        if (defaultProps == null) {
            try {
                InputStream in = (class$com$bbn$openmap$layer$vpf$VPFLayer == null ? (class$com$bbn$openmap$layer$vpf$VPFLayer = VPFLayer.class$("com.bbn.openmap.layer.vpf.VPFLayer")) : class$com$bbn$openmap$layer$vpf$VPFLayer).getResourceAsStream("defaultVPFlayers.properties");
                Properties tmp = new Properties();
                if (in != null) {
                    tmp.load(in);
                    in.close();
                } else {
                    Debug.error("VPFLayer: can't load default properties file");
                }
                defaultProps = tmp;
            }
            catch (IOException io) {
                Debug.error("VPFLayer: can't load default properties: " + io);
                defaultProps = new Properties();
            }
        }
        return defaultProps;
    }

    public void setPath(String newPath) {
        if (Debug.debugging("vpf")) {
            Debug.output("VPFLayer setting paths to " + newPath);
        }
        this.setPath(new String[]{newPath});
    }

    public void setPath(String[] newPaths) {
        this.dataPaths = newPaths;
        this.lst = null;
        this.initLST();
    }

    public String[] getPath() {
        return this.dataPaths;
    }

    public void setDataTypes(String dataTypes) {
        this.coverageType = dataTypes;
    }

    public String getDataTypes() {
        return this.coverageType;
    }

    public void setAreasEnabled(boolean value) {
        this.warehouse.setAreaFeatures(value);
    }

    public boolean getAreasEnabled() {
        return this.warehouse.drawAreaFeatures();
    }

    public void setEdgesEnabled(boolean value) {
        this.warehouse.setEdgeFeatures(value);
    }

    public boolean getEdgesEnabled() {
        return this.warehouse.drawEdgeFeatures();
    }

    public void setEPointsEnabled(boolean value) {
        this.warehouse.setEPointFeatures(value);
    }

    public boolean getEPointsEnabled() {
        return this.warehouse.drawEPointFeatures();
    }

    public void setCPointsEnabled(boolean value) {
        this.warehouse.setCPointFeatures(value);
    }

    public boolean getCPointsEnabled() {
        return this.warehouse.drawCPointFeatures();
    }

    public void setTextEnabled(boolean value) {
        this.warehouse.setTextFeatures(value);
    }

    public boolean getTextEnabled() {
        return this.warehouse.drawTextFeatures();
    }

    public DrawingAttributes getDrawingAttributes() {
        return this.warehouse.getDrawingAttributes();
    }

    public void setDrawingAttributes(DrawingAttributes da) {
        this.warehouse.setDrawingAttributes(da);
    }

    protected void initLST() {
        if (Debug.debugging("vpf")) {
            Debug.output("VPFLayer.initLST()");
        }
        try {
            if (this.lst == null) {
                if (this.libraryBeanName != null) {
                    LibraryBean libraryBean = null;
                    BeanContext beanContext = this.getBeanContext();
                    if (beanContext == null) {
                        return;
                    }
                    Iterator i = beanContext.iterator();
                    while (i.hasNext()) {
                        LibraryBean lb;
                        Object obj = i.next();
                        if (!(obj instanceof LibraryBean) || !this.libraryBeanName.equals((lb = (LibraryBean)obj).getName())) continue;
                        if (Debug.debugging("vpf")) {
                            Debug.output("VPFLayer|" + this.getName() + ": setting library bean to " + lb.getName());
                        }
                        libraryBean = lb;
                        break;
                    }
                    if (libraryBean != null) {
                        this.lst = libraryBean.getLibrarySelectionTable();
                        this.warehouse = libraryBean.getWarehouse();
                        this.warehouse.setProperties(this.getPropertyPrefix(), this.props);
                        this.searchByFeatures = true;
                        this.box = null;
                        if (Debug.debugging("vpf")) {
                            Debug.output("VPFLayer.initLST(libraryBean)");
                        }
                    } else if (Debug.debugging("vpf")) {
                        Debug.output("VPFLayer.init: Couldn't find libraryBean " + this.libraryBeanName + " to read VPF data");
                    }
                } else if (this.dataPaths == null) {
                    Debug.output("VPFLayer|" + this.getName() + ": path not set");
                } else {
                    if (Debug.debugging("vpf")) {
                        Debug.output("VPFLayer.initLST(dataPaths)");
                    }
                    this.lst = new LibrarySelectionTable(this.dataPaths);
                    this.lst.setCutoffScale(this.cutoffScale);
                }
            }
        }
        catch (FormatException f) {
            throw new IllegalArgumentException(f.getMessage());
        }
    }

    public void setWarehouse(LayerGraphicWarehouseSupport wh) {
        this.warehouse = wh;
    }

    public LayerGraphicWarehouseSupport getWarehouse() {
        return this.warehouse;
    }

    public void checkWarehouse(boolean sbf) {
        if (this.warehouse == null) {
            if (Debug.debugging("vpf")) {
                Debug.output("VPFLayer.getWarehouse: creating warehouse");
            }
            this.warehouse = this.lst != null && this.lst.getDatabaseName() != null && this.lst.getDatabaseName().equals("DCW") ? new VPFLayerDCWWarehouse() : (sbf ? new VPFFeatureGraphicWarehouse() : new VPFLayerGraphicWarehouse());
        } else if (sbf && !(this.warehouse instanceof VPFFeatureGraphicWarehouse) || !sbf && this.warehouse instanceof VPFFeatureGraphicWarehouse) {
            this.warehouse = null;
            this.checkWarehouse(sbf);
        }
    }

    public void computeLayer() {
        this.doPrepare();
    }

    public OMGraphicList getRectangle() {
        return this.prepare();
    }

    public synchronized OMGraphicList prepare() {
        if (this.lst == null) {
            try {
                this.initLST();
            }
            catch (IllegalArgumentException iae) {
                Debug.error("VPFLayer.prepare: Illegal Argument Exception.\n\nPerhaps a file not found.  Check to make sure that the paths to the VPF data directories are the parents of \"lat\" or \"lat.\" files. \n\n" + iae);
                return null;
            }
            if (this.lst == null) {
                if (Debug.debugging("vpf")) {
                    Debug.output("VPFLayer| " + this.getName() + " prepare(), Library Selection Table not set.");
                }
                return null;
            }
        }
        if (this.warehouse == null) {
            StringBuffer dpb = new StringBuffer();
            if (this.dataPaths != null) {
                for (int num = 0; num < this.dataPaths.length; ++num) {
                    if (num > 0) {
                        dpb.append(":");
                    }
                    dpb.append(this.dataPaths[num]);
                }
            }
            Debug.error("VPFLayer.getRectangle:  Data path probably wasn't set correctly (" + dpb.toString() + ").  The warehouse not initialized.");
            return null;
        }
        Projection p = this.getProjection();
        if (p == null) {
            Debug.error("VPFLayer.getRectangle() called without a projection set in the layer. Make sure a projection is set in the layer before calling getRectangle.");
            return new OMGraphicList();
        }
        LatLonPoint upperleft = p.getUpperLeft();
        LatLonPoint lowerright = p.getLowerRight();
        if (Debug.debugging("vpfdetail")) {
            Debug.output("VPFLayer.getRectangle: " + this.coverageType);
        }
        this.warehouse.clear();
        if (Debug.debugging("vpf")) {
            Debug.output("VPFLayer.getRectangle(): calling draw with boundaries: " + upperleft + " " + lowerright);
        }
        long start = System.currentTimeMillis();
        StringTokenizer t = new StringTokenizer(this.coverageType);
        while (t.hasMoreTokens()) {
            String currentCoverage = t.nextToken();
            if (this.searchByFeatures) {
                this.lst.drawFeatures((int)p.getScale(), p.getWidth(), p.getHeight(), currentCoverage, (VPFFeatureWarehouse)((Object)this.warehouse), upperleft, lowerright);
                continue;
            }
            this.lst.drawTile((int)p.getScale(), p.getWidth(), p.getHeight(), currentCoverage, this.warehouse, upperleft, lowerright);
        }
        long stop = System.currentTimeMillis();
        if (Debug.debugging("vpf")) {
            Debug.output("VPFLayer.getRectangle(): read time: " + (double)(stop - start) / 1000.0 + " seconds");
        }
        OMGraphicList omglist = this.warehouse.getGraphics();
        start = System.currentTimeMillis();
        omglist.project(p);
        stop = System.currentTimeMillis();
        if (Debug.debugging("vpf")) {
            Debug.output("VPFLayer.getRectangle(): proj time: " + (double)(stop - start) / 1000.0 + " seconds");
        }
        return omglist;
    }

    public Component getGUI() {
        if (this.lst == null) {
            try {
                this.initLST();
            }
            catch (IllegalArgumentException iie) {
                Debug.error(iie.getMessage());
            }
        }
        if (this.warehouse == null) {
            return new JLabel("VPF Layer data not loaded properly.");
        }
        if (this.box == null) {
            Component warehouseGUI;
            this.box = new JPanel();
            this.box.setLayout(new BoxLayout(this.box, 1));
            this.box.setAlignmentX(0.0f);
            JPanel stuff = new JPanel();
            JPanel pal = null;
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int index = Integer.parseInt(e.getActionCommand(), 10);
                    switch (index) {
                        case 0: {
                            VPFLayer.this.warehouse.setEdgeFeatures(!VPFLayer.this.warehouse.drawEdgeFeatures());
                            break;
                        }
                        case 1: {
                            VPFLayer.this.warehouse.setTextFeatures(!VPFLayer.this.warehouse.drawTextFeatures());
                            break;
                        }
                        case 2: {
                            VPFLayer.this.warehouse.setAreaFeatures(!VPFLayer.this.warehouse.drawAreaFeatures());
                            break;
                        }
                        case 3: {
                            VPFLayer.this.warehouse.setEPointFeatures(!VPFLayer.this.warehouse.drawEPointFeatures());
                            break;
                        }
                        case 4: {
                            VPFLayer.this.warehouse.setCPointFeatures(!VPFLayer.this.warehouse.drawCPointFeatures());
                            break;
                        }
                        default: {
                            throw new RuntimeException("argh!");
                        }
                    }
                }
            };
            pal = PaletteHelper.createCheckbox("Show:", new String[]{"Edges", "Text", "Area", "EPoint", "CPoint"}, new boolean[]{this.warehouse.drawEdgeFeatures(), this.warehouse.drawTextFeatures(), this.warehouse.drawAreaFeatures(), this.warehouse.drawEPointFeatures(), this.warehouse.drawCPointFeatures()}, al);
            stuff.add(pal);
            if (this.lst != null && (warehouseGUI = this.warehouse.getGUI(this.lst)) != null) {
                stuff.add(warehouseGUI);
            }
            this.box.add(stuff);
            JPanel pal2 = new JPanel();
            JButton config = new JButton("Configure Layer");
            config.setActionCommand(ConfigCmd);
            config.addActionListener(this);
            pal2.add(config);
            JButton redraw = new JButton("Redraw Layer");
            redraw.setActionCommand("redrawCmd");
            redraw.addActionListener(this);
            pal2.add(redraw);
            this.box.add(pal2);
        }
        return this.box;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "redrawCmd") {
            this.setList(null);
            if (this.isVisible()) {
                this.doPrepare();
            }
        } else if (cmd == ConfigCmd) {
            if (this.configWindowSupport == null) {
                this.configWindowSupport = new WindowSupport((Component)new VPFConfig(this), "Configure " + this.getName() + " Features");
            } else {
                this.configWindowSupport.setTitle(this.getName());
            }
            this.configWindowSupport.displayInWindow();
        } else {
            super.actionPerformed(e);
        }
    }

    protected void setConfigSettings(String prefix, Properties props) {
        this.lst = null;
        this.setProperties(prefix, props);
        if (this.isVisible()) {
            this.doPrepare();
        }
        if (this.configWindowSupport != null) {
            this.configWindowSupport.setTitle(this.getName());
        }
    }

    public String getToolTipTextFor(OMGraphic omg) {
        return (String)omg.getAttribute("Tooltip");
    }

    public String getInfoText(OMGraphic omg) {
        return (String)omg.getAttribute("Information Line");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

