/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

public class TileDirectory {
    private final String tilename;
    private final float westlon;
    private final float southlat;
    private final float eastlon;
    private final float northlat;
    private final int tileID;

    public TileDirectory(String path, int tileID, float n, float s, float e, float w) {
        StringBuffer strbuf = new StringBuffer(path.toLowerCase());
        strbuf.append("/");
        this.tilename = strbuf.toString().intern();
        this.tileID = tileID;
        if (e < w) {
            e = (float)((double)e + 360.0);
        }
        this.westlon = w;
        this.eastlon = e;
        this.northlat = n;
        this.southlat = s;
    }

    public TileDirectory() {
        this.tilename = "";
        this.tileID = -1;
        this.southlat = Float.NaN;
        this.northlat = Float.NaN;
        this.eastlon = Float.NaN;
        this.westlon = Float.NaN;
    }

    public String getPath() {
        return this.tilename;
    }

    public int getTileID() {
        return this.tileID;
    }

    public String toString() {
        return this.tilename;
    }

    public boolean inRegion(float n, float s, float e, float w) {
        if (s > this.northlat || n < this.southlat) {
            return false;
        }
        if (e < w) {
            e += 360.0f;
        }
        return !(w > this.eastlon) && !(e < this.westlon);
    }
}

