/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.CoverageAttributeTable;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.DcwRecordFile;
import com.bbn.openmap.layer.vpf.DescribeDB;
import com.bbn.openmap.layer.vpf.LibrarySelectionTable;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GenerateVPFProperties
extends DescribeDB {
    static String rootpath;

    public static void main(String[] args) throws FormatException {
        Debug.init();
        if (args.length == 0) {
            Debug.output("Usage: java com.bbn.openmap.layer.vpf.GenerateVPFProperties <path to vpf database directory> <path to vpf database directory> ...");
            System.exit(0);
        }
        for (int argsi = 0; argsi < args.length; ++argsi) {
            int i;
            rootpath = args[argsi];
            LibrarySelectionTable lst = new LibrarySelectionTable(rootpath);
            if (Debug.debugging("vpf")) {
                Debug.output("Path to database: " + rootpath);
                Debug.output("Database Name: " + lst.getDatabaseName());
            }
            GenerateVPFProperties.println("### Generated openmap.properties for");
            GenerateVPFProperties.println("# VPF Data at: " + rootpath);
            GenerateVPFProperties.println("# Description: " + lst.getDatabaseDescription());
            String[] libraries = lst.getLibraryNames();
            if (Debug.debugging("vpf")) {
                GenerateVPFProperties.print("Database Libraries: ");
                for (i = 0; i < libraries.length; ++i) {
                    GenerateVPFProperties.print(libraries[i], " ");
                }
                GenerateVPFProperties.println("");
                GenerateVPFProperties.println("");
            }
            for (i = 0; i < libraries.length; ++i) {
                String prefix = lst.getDatabaseName() + "_" + libraries[i];
                GenerateVPFProperties.println("# Library: " + prefix);
                GenerateVPFProperties.printLibrary(prefix, lst.getCAT(libraries[i]));
                GenerateVPFProperties.println("");
            }
        }
    }

    public static void printLibrary(String prefix, CoverageAttributeTable cat) {
        StringBuffer printedlayers = new StringBuffer();
        String printedlayername = null;
        if (cat == null) {
            System.err.println(prefix + "Library doesn't exist");
            return;
        }
        String[] coverages = cat.getCoverageNames();
        if (Debug.debugging("vpf")) {
            Debug.output(prefix + "uses " + (cat.isTiledData() ? "tiled" : "untiled") + " data");
        }
        for (int i = 0; i < coverages.length; ++i) {
            printedlayername = GenerateVPFProperties.printCoverageProperties(prefix, cat, coverages[i]);
            if (printedlayername == null) continue;
            printedlayers.append(" " + printedlayername);
        }
        GenerateVPFProperties.println("# Summary:" + printedlayers);
    }

    public static String printCoverageProperties(String prefix, CoverageAttributeTable cat, String covname) {
        String layername = prefix + "_" + covname;
        ArrayList<String> text_features = new ArrayList<String>();
        ArrayList<String> edge_features = new ArrayList<String>();
        ArrayList<String> area_features = new ArrayList<String>();
        ArrayList<String> point_features = new ArrayList<String>();
        CoverageTable ct = cat.getCoverageTable(covname);
        String path = ct.getDataPath();
        String fcaPath = path + "/fca";
        File fca = new File(fcaPath);
        if (!fca.exists()) {
            fcaPath = path + "/fca.";
            fca = new File(fcaPath);
        }
        if (!fca.canRead()) {
            GenerateVPFProperties.println("");
            return null;
        }
        try {
            DcwRecordFile fcadesc = new DcwRecordFile(fcaPath);
            int fclass = fcadesc.whatColumn("fclass");
            int type = fcadesc.whatColumn("type");
            ArrayList v = new ArrayList();
            while (fcadesc.parseRow(v)) {
                String name = (String)v.get(fclass);
                String t = (String)v.get(type);
                if (t.equals("T")) {
                    text_features.add(name);
                    continue;
                }
                if (t.equals("L")) {
                    edge_features.add(name);
                    continue;
                }
                if (t.equals("A")) {
                    area_features.add(name);
                    continue;
                }
                if (!t.equals("P")) continue;
                point_features.add(name);
            }
        }
        catch (FormatException fe) {
            // empty catch block
        }
        if (text_features.isEmpty() && edge_features.isEmpty() && area_features.isEmpty() && point_features.isEmpty()) {
            return null;
        }
        GenerateVPFProperties.println("### VPF " + cat.getCoverageDescription(covname) + " Layer");
        GenerateVPFProperties.println(layername + ".class=com.bbn.openmap.layer.vpf.VPFLayer");
        GenerateVPFProperties.println(layername + ".prettyName=" + "VPF " + cat.getCoverageDescription(covname) + " " + prefix);
        GenerateVPFProperties.println(layername + ".vpfPath=" + rootpath);
        GenerateVPFProperties.println(layername + ".coverageType=" + covname);
        GenerateVPFProperties.println(layername + ".featureTypes=" + "area edge text point");
        GenerateVPFProperties.printFeatures("text", text_features, layername);
        GenerateVPFProperties.printFeatures("edge", edge_features, layername);
        GenerateVPFProperties.printFeatures("area", area_features, layername);
        GenerateVPFProperties.printFeatures("point", point_features, layername);
        GenerateVPFProperties.println("");
        return layername;
    }

    public static void printFeatures(String fname, List features, String layername) {
        if (!features.isEmpty()) {
            GenerateVPFProperties.print(layername + "." + fname + "=");
            Iterator i = features.iterator();
            while (i.hasNext()) {
                GenerateVPFProperties.print(i.next() + " ");
            }
            GenerateVPFProperties.println("");
        }
    }
}

