/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.layer.vpf.FeatureDrawingAttributes;
import com.bbn.openmap.layer.vpf.VPFFeatureGraphicWarehouse;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import java.util.Iterator;

public abstract class FeatureCacheGraphicList
extends OMGraphicList
implements Cloneable {
    protected String featureName = null;

    public FeatureCacheGraphicList() {
    }

    public FeatureCacheGraphicList(int initSize) {
        super(initSize);
    }

    public void setFeatureName(String name) {
        this.featureName = name;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public synchronized void setTo(DrawingAttributes da) {
        if (da != null) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                da.setTo((OMGraphic)it.next());
            }
        }
    }

    public static FeatureCacheGraphicList createForType(String featureType) {
        int lastCharIndex = featureType.length() - 1;
        if (lastCharIndex >= 0) {
            if (featureType == "Edge") {
                return new EDGE();
            }
            if (featureType == "Area") {
                return new AREA();
            }
            if (featureType == "Text") {
                return new TEXT();
            }
            if (featureType == "EPoint" || featureType == "CPoint") {
                return new POINT();
            }
        }
        return new DEFAULT();
    }

    public abstract void setDrawingAttributes(VPFFeatureGraphicWarehouse var1);

    public static class POINT
    extends DEFAULT {
        public POINT() {
        }

        public POINT(int size) {
            super(size);
        }
    }

    public static class TEXT
    extends DEFAULT {
        public TEXT() {
        }

        public TEXT(int size) {
            super(size);
        }
    }

    public static class DEFAULT
    extends FeatureCacheGraphicList {
        public DEFAULT() {
        }

        public DEFAULT(int size) {
            super(size);
        }

        public synchronized void setDrawingAttributes(VPFFeatureGraphicWarehouse vfgw) {
            this.setTo(vfgw.getAttributesForFeature(this.featureName));
        }
    }

    public static class EDGE
    extends FeatureCacheGraphicList {
        public EDGE() {
        }

        public EDGE(int size) {
            super(size);
        }

        public synchronized void setDrawingAttributes(VPFFeatureGraphicWarehouse vfgw) {
            FeatureDrawingAttributes da = vfgw.getAttributesForFeature(this.featureName);
            da.setFillPaint(OMColor.clear);
            this.setTo(da);
        }
    }

    public static class AREA
    extends FeatureCacheGraphicList {
        public AREA() {
        }

        public AREA(int size) {
            super(size);
        }

        public synchronized void setDrawingAttributes(VPFFeatureGraphicWarehouse vfgw) {
            FeatureDrawingAttributes da = vfgw.getAttributesForFeature(this.featureName);
            da.setLinePaint(OMColor.clear);
            da.setSelectPaint(OMColor.clear);
            this.setTo(da);
        }
    }
}

