/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.terrain;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.dataAccess.dted.DTEDFrameCache;
import com.bbn.openmap.event.ProgressListener;
import com.bbn.openmap.event.ProgressSupport;
import com.bbn.openmap.gui.ProgressListenerGauge;
import com.bbn.openmap.layer.terrain.LOSStateMachine;
import com.bbn.openmap.layer.terrain.TerrainLayer;
import com.bbn.openmap.layer.terrain.TerrainTool;
import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.SwingWorker;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class LOSGenerator
implements TerrainTool {
    static final int PRECISE = 0;
    static final int GOODENOUGH = 1;
    static final int AZIMUTH = 2;
    Color toolColor = new Color(255, 0, 0);
    static final int INVISIBLE = 0;
    static final int VISIBLE = 1;
    static final int MAYBEVISIBLE = 2;
    int[] colortable;
    Projection proj;
    protected LOSStateMachine stateMachine;
    TerrainLayer layer;
    LatLonPoint LOScenterLLP;
    Point LOScenterP = new Point();
    int LOScenterHeight;
    int LOSobjectHeight = 0;
    int LOSedge;
    protected OMGraphicList graphics = new OMGraphicList();
    OMRaster LOSimage;
    OMCircle LOScirc;
    int LOSprecision;
    LatLonPoint LOSOffPagell = new LatLonPoint(-79.0f, -170.0f);
    Point LOSOffPagep1 = new Point(-10, -10);
    LOSWorker currentWorker;
    protected boolean cancelled = false;
    protected ProgressSupport progressSupport;

    private LOSGenerator() {
        this.init();
    }

    public LOSGenerator(TerrainLayer tLayer) {
        this.layer = tLayer;
        this.init();
    }

    public synchronized OMGraphicList getGraphics() {
        return this.graphics;
    }

    public State getState() {
        return this.stateMachine.getState();
    }

    public void init() {
        this.progressSupport = new ProgressSupport(this);
        this.addProgressListener(new ProgressListenerGauge("LOS Mask Creation"));
        this.colortable = new int[3];
        this.colortable[0] = new Color(0, 0, 0, 0).getRGB();
        this.colortable[1] = new Color(0, 255, 0, 255).getRGB();
        this.colortable[2] = new Color(255, 255, 0, 255).getRGB();
        this.stateMachine = new LOSStateMachine(this);
        this.reset(true, true);
        this.graphics.add(this.LOSimage);
        this.graphics.add(this.LOScirc);
    }

    public void doImage() {
        if (this.currentWorker == null) {
            this.currentWorker = new LOSWorker();
            this.currentWorker.execute();
        } else {
            this.setCancelled(true);
        }
    }

    protected synchronized void workerComplete() {
        if (!this.isCancelled()) {
            this.currentWorker = null;
            this.layer.repaint();
        } else {
            this.setCancelled(false);
            this.currentWorker = new LOSWorker();
            this.currentWorker.execute();
        }
    }

    public synchronized void setCancelled(boolean set) {
        this.cancelled = set;
    }

    public synchronized boolean isCancelled() {
        return this.cancelled;
    }

    public void reset() {
        this.reset(true, true);
    }

    public void reset(boolean circ, boolean image) {
        this.graphics.clear();
        if (image) {
            this.LOSimage = new OMRaster(this.LOSOffPagell.getLatitude(), this.LOSOffPagell.getLongitude(), this.LOSOffPagep1.x, this.LOSOffPagep1.y, 1, 1, new int[1]);
        }
        if (circ) {
            this.LOScirc = new OMCircle(this.LOSOffPagell.getLatitude(), this.LOSOffPagell.getLongitude(), 1, 1);
            this.LOScirc.setLinePaint(this.toolColor);
        }
        this.layer.repaint();
        this.stateMachine.reset();
    }

    public void setScreenParameters(Projection p) {
        this.reset(true, true);
        this.proj = p;
        this.LOSprecision = 2;
        this.graphics.generate(this.proj);
    }

    public synchronized void createLOSImage() {
        if (Debug.debugging("los")) {
            Debug.output("createLOSimage: Entered with diameter = " + this.LOSedge);
        }
        if (this.layer == null || this.layer.frameCache == null) {
            Debug.error("LOSGenerator:  can't access the DTED data through the terrain layer.");
            return;
        }
        int squareRadius = this.LOSedge / 2 + 1;
        int[] newPixels = new int[this.LOSedge * this.LOSedge];
        float[] azimuthVals = new float[8 * (squareRadius - 1)];
        newPixels[this.LOSedge / 2 * this.LOSedge + squareRadius] = 2;
        if (Debug.debugging("los")) {
            Debug.output("createLOSimage: size of azimuth array = " + azimuthVals.length);
        }
        this.fireProgressUpdate(0, "Building LOS Image Mask...", 0, 100);
        boolean mark = false;
        int markColor = this.colortable[0];
        float pix_arc_interval = (float)(Math.PI * 2 / (double)azimuthVals.length);
        for (int round = 1; round < squareRadius; ++round) {
            if (Debug.debugging("los")) {
                Debug.output("createLOSimage: round " + round);
            }
            int y = this.LOScenterP.y - round;
            int x = this.LOScenterP.x - round;
            if (round == 1) {
                mark = true;
                markColor = this.colortable[2];
            } else {
                mark = false;
            }
            if (this.LOSprecision == 2) {
                int range = (this.LOSedge * 4 - 4) / (round * 16);
                while (x < this.LOScenterP.x + round) {
                    this.resolveImagePoint(x, y, newPixels, azimuthVals, range, pix_arc_interval, mark, markColor);
                    ++x;
                }
                while (y < this.LOScenterP.y + round) {
                    this.resolveImagePoint(x, y, newPixels, azimuthVals, range, pix_arc_interval, mark, markColor);
                    ++y;
                }
                while (x > this.LOScenterP.x - round) {
                    this.resolveImagePoint(x, y, newPixels, azimuthVals, range, pix_arc_interval, mark, markColor);
                    --x;
                }
                while (y > this.LOScenterP.y - round) {
                    this.resolveImagePoint(x, y, newPixels, azimuthVals, range, pix_arc_interval, mark, markColor);
                    --y;
                }
            }
            int whereWeAre = (int)(100.0f * ((float)round / (float)squareRadius));
            this.fireProgressUpdate(1, "Analyzing data...", whereWeAre, 100);
        }
        this.fireProgressUpdate(1, "Creating Mask", 100, 100);
        this.LOSimage = new OMRaster(this.LOScenterLLP.getLatitude(), this.LOScenterLLP.getLongitude(), -1 - this.LOSedge / 2, -1 - this.LOSedge / 2, this.LOSedge, this.LOSedge, newPixels);
        this.LOSimage.generate(this.proj);
        this.graphics.clear();
        this.graphics.add(this.LOSimage);
        this.fireProgressUpdate(2, "LOS mask complete", 100, 100);
        if (Debug.debugging("los")) {
            Debug.output("createLOSimage: Done...");
        }
    }

    protected void resolveImagePoint(int x, int y, int[] newPixels, float[] azimuthVals, int range, float pix_arc_interval, boolean mark, int colorForMark) {
        int ox = this.LOScenterP.x - this.LOSedge / 2;
        int oy = this.LOScenterP.y - this.LOSedge / 2;
        int dist = TerrainLayer.numPixelsBetween(this.LOScenterP.x, this.LOScenterP.y, x, y);
        if (dist > (this.LOSedge - 1) / 2) {
            mark = true;
            colorForMark = 0;
        }
        if (dist == (this.LOSedge - 1) / 2) {
            mark = true;
            colorForMark = 2;
        }
        LatLonPoint cord = this.proj.inverse(x, y);
        x -= ox;
        y -= oy;
        if (Debug.debugging("losdetail")) {
            Debug.output("resolveImagePoint x = " + x + ", y = " + y);
        }
        if (mark) {
            newPixels[x + y * this.LOSedge] = colorForMark;
            mark = false;
            return;
        }
        float centerRadLat = this.LOScenterLLP.radlat_;
        float centerRadLon = this.LOScenterLLP.radlon_;
        float arc_dist = GreatCircle.spherical_distance(centerRadLat, centerRadLon, cord.radlat_, cord.radlon_);
        float slope = (float)this.calculateLOSslope(cord, arc_dist);
        float arc_angle = GreatCircle.spherical_azimuth(centerRadLat, centerRadLon, cord.radlat_, cord.radlon_);
        int index = Math.round(arc_angle / pix_arc_interval);
        int maxIndex = this.LOSedge * 4 - 4;
        if (index < 0) {
            index = maxIndex + index;
        } else if (index >= maxIndex) {
            index -= maxIndex;
        }
        if (Debug.debugging("losdetail")) {
            Debug.output(" angle = " + arc_angle + ", index/maxIndex = " + index + "/" + maxIndex + ", slope = " + slope + " compared to slope[index]=" + azimuthVals[index]);
        }
        int color = this.colortable[0];
        if (azimuthVals[index] < slope) {
            for (int i = index - range; i < index + range - 1; ++i) {
                if (i < 0) {
                    azimuthVals[maxIndex + i] = slope;
                    continue;
                }
                if (i >= maxIndex) {
                    azimuthVals[i - maxIndex] = slope;
                    continue;
                }
                azimuthVals[i] = slope;
            }
            color = this.colortable[1];
        }
        if (Debug.debugging("losdetail")) {
            Debug.output(" color = " + color);
        }
        newPixels[x + y * this.LOSedge] = color;
    }

    protected double calculateLOSslope(LatLonPoint cord, float arc_dist) {
        DTEDFrameCache frameCache = this.layer.frameCache;
        if (frameCache == null) {
            return 0.0;
        }
        int xyheight = frameCache.getElevation(cord.getLatitude(), cord.getLongitude());
        double ret = 0.0;
        double P = Math.sin(arc_dist) * (double)((float)xyheight + 6378137.0f);
        double xPrime = Math.cos(arc_dist) * (double)((float)xyheight + 6378137.0f);
        double cutoff = (float)this.LOScenterHeight + 6378137.0f;
        double bottom = cutoff - xPrime;
        ret = 1.5707963267948966 - Math.atan(bottom / P);
        return ret;
    }

    public void setCenter(MouseEvent event) {
        this.graphics.clear();
        this.LOScenterP.x = event.getX();
        this.LOScenterP.y = event.getY();
        this.LOScenterLLP = this.proj.inverse(this.LOScenterP.x, this.LOScenterP.y);
        this.LOScenterHeight = this.LOSobjectHeight;
        if (this.layer.frameCache != null) {
            this.LOScenterHeight += this.layer.frameCache.getElevation(this.LOScenterLLP.getLatitude(), this.LOScenterLLP.getLongitude());
        }
        this.LOScirc.setLatLon(this.LOScenterLLP.getLatitude(), this.LOScenterLLP.getLongitude());
        this.LOScirc.generate(this.proj);
        this.graphics.add(this.LOScirc);
    }

    public void addLOSEvent(MouseEvent event) {
        this.graphics.clear();
        this.LOSedge = TerrainLayer.numPixelsBetween(this.LOScenterP.x, this.LOScenterP.y, event.getX(), event.getY()) * 2 + 1;
        this.LOScirc.setWidth(this.LOSedge);
        this.LOScirc.setHeight(this.LOSedge);
        this.LOScirc.generate(this.proj);
        this.graphics.add(this.LOScirc);
    }

    public void setLOSobjectHeight(int value) {
        this.LOScenterHeight -= this.LOSobjectHeight;
        this.LOSobjectHeight = value;
        this.LOScenterHeight += this.LOSobjectHeight;
    }

    public void addProgressListener(ProgressListener list) {
        this.progressSupport.addProgressListener(list);
    }

    public void removeProgressListener(ProgressListener list) {
        this.progressSupport.removeProgressListener(list);
    }

    public void clearProgressListeners() {
        this.progressSupport.removeAll();
    }

    protected void fireProgressUpdate(int type, String task, int frameNumber, int totalFrames) {
        this.progressSupport.fireUpdate(type, task, totalFrames, frameNumber);
    }

    class LOSWorker
    extends SwingWorker {
        public Object construct() {
            Debug.message("terrain", LOSGenerator.this.layer.getName() + "|LOSWorker.construct()");
            LOSGenerator.this.layer.fireStatusUpdate(8342);
            LOSGenerator.this.createLOSImage();
            return null;
        }

        public void finished() {
            LOSGenerator.this.layer.fireStatusUpdate(8359);
            LOSGenerator.this.workerComplete();
        }
    }
}

