/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.layer.shape.ESRIBoundingBox;
import com.bbn.openmap.layer.shape.ESRIPoint;
import java.io.EOFException;
import java.io.IOException;

public class ShapeUtils
implements ShapeConstants {
    private static byte[] leiBuffer = new byte[4];

    public static int readBEInt(byte[] b, int off) {
        return (b[off + 0] & 0xFF) << 24 | (b[off + 1] & 0xFF) << 16 | (b[off + 2] & 0xFF) << 8 | b[off + 3] & 0xFF;
    }

    public static int readLEInt(byte[] b, int off) {
        return (b[off + 3] & 0xFF) << 24 | (b[off + 2] & 0xFF) << 16 | (b[off + 1] & 0xFF) << 8 | b[off + 0] & 0xFF;
    }

    public static synchronized int readLEInt(BinaryBufferedFile in) throws IOException {
        int result = in.read(leiBuffer, 0, 4);
        if (result < 4) {
            throw new EOFException();
        }
        return ShapeUtils.readLEInt(leiBuffer, 0);
    }

    public static long readLELong(byte[] b, int off) {
        return (long)b[off + 0] & 0xFFL | ((long)b[off + 1] & 0xFFL) << 8 | ((long)b[off + 2] & 0xFFL) << 16 | ((long)b[off + 3] & 0xFFL) << 24 | ((long)b[off + 4] & 0xFFL) << 32 | ((long)b[off + 5] & 0xFFL) << 40 | ((long)b[off + 6] & 0xFFL) << 48 | ((long)b[off + 7] & 0xFFL) << 56;
    }

    public static double readLEDouble(byte[] b, int off) {
        double result = Double.longBitsToDouble(ShapeUtils.readLELong(b, off));
        return result;
    }

    public static ESRIPoint readPoint(byte[] b, int off) {
        ESRIPoint point = new ESRIPoint();
        point.x = ShapeUtils.readLEDouble(b, off);
        point.y = ShapeUtils.readLEDouble(b, off + 8);
        return point;
    }

    public static ESRIBoundingBox readBox(byte[] b, int off) {
        ESRIBoundingBox bb = new ESRIBoundingBox();
        bb.min = ShapeUtils.readPoint(b, off);
        bb.max = ShapeUtils.readPoint(b, off + 16);
        return bb;
    }

    public static int writeBEInt(byte[] b, int off, int val) {
        b[off + 0] = (byte)(val >> 24 & 0xFF);
        b[off + 1] = (byte)(val >> 16 & 0xFF);
        b[off + 2] = (byte)(val >> 8 & 0xFF);
        b[off + 3] = (byte)(val & 0xFF);
        return 4;
    }

    public static int writeLEInt(byte[] b, int off, int val) {
        b[off + 0] = (byte)(val & 0xFF);
        b[off + 1] = (byte)(val >> 8 & 0xFF);
        b[off + 2] = (byte)(val >> 16 & 0xFF);
        b[off + 3] = (byte)(val >> 24 & 0xFF);
        return 4;
    }

    public static int writeLELong(byte[] b, int off, long val) {
        b[off + 0] = (byte)(val & 0xFFL);
        b[off + 1] = (byte)(val >> 8 & 0xFFL);
        b[off + 2] = (byte)(val >> 16 & 0xFFL);
        b[off + 3] = (byte)(val >> 24 & 0xFFL);
        b[off + 4] = (byte)(val >> 32 & 0xFFL);
        b[off + 5] = (byte)(val >> 40 & 0xFFL);
        b[off + 6] = (byte)(val >> 48 & 0xFFL);
        b[off + 7] = (byte)(val >> 56 & 0xFFL);
        return 8;
    }

    public static int writeLEDouble(byte[] b, int off, double val) {
        return ShapeUtils.writeLELong(b, off, Double.doubleToLongBits(val));
    }

    public static int writePoint(byte[] b, int off, ESRIPoint point) {
        int nBytes = ShapeUtils.writeLEDouble(b, off, point.x);
        nBytes += ShapeUtils.writeLEDouble(b, off + nBytes, point.y);
        return nBytes;
    }

    public static int writeBox(byte[] b, int off, ESRIBoundingBox box) {
        int nBytes = ShapeUtils.writePoint(b, off, box.min);
        nBytes += ShapeUtils.writePoint(b, off + nBytes, box.max);
        return nBytes;
    }
}

