/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.layer.shape.ShapeUtils;
import java.text.NumberFormat;

public class ESRIPoint {
    static NumberFormat format = NumberFormat.getInstance();
    public double x;
    public double y;

    public ESRIPoint() {
    }

    public ESRIPoint(double _x, double _y) {
        this.x = _x;
        this.y = _y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public String toString() {
        return "ESRIPoint[" + format.format(this.x) + "," + format.format(this.y) + "]";
    }

    public ESRIPoint(byte[] b, int off) {
        this.x = ShapeUtils.readLEDouble(b, off);
        this.y = ShapeUtils.readLEDouble(b, off + 8);
    }

    public int write(byte[] b, int off) {
        int nBytes = ShapeUtils.writeLEDouble(b, off, this.x);
        nBytes += ShapeUtils.writeLEDouble(b, off + nBytes, this.y);
        return nBytes;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ESRIPoint) {
            ESRIPoint pt = (ESRIPoint)obj;
            return this.x == pt.x && this.y == pt.y;
        }
        return false;
    }

    static {
        format.setMaximumFractionDigits(6);
        format.setMinimumFractionDigits(6);
    }
}

