/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.rpf;

import com.bbn.openmap.io.BinaryBufferedFile;
import com.bbn.openmap.io.BinaryFile;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.rpf.RpfConstants;
import com.bbn.openmap.layer.rpf.RpfFileSections;
import com.bbn.openmap.layer.rpf.RpfFrameCacheHandler;
import com.bbn.openmap.layer.rpf.RpfFrameEntry;
import com.bbn.openmap.layer.rpf.RpfHeader;
import com.bbn.openmap.layer.rpf.RpfProductInfo;
import com.bbn.openmap.layer.rpf.RpfTocEntry;
import com.bbn.openmap.layer.rpf.RpfViewAttributes;
import com.bbn.openmap.proj.CADRG;
import com.bbn.openmap.util.Debug;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class RpfTocHandler {
    public static final String RPF_TOC_FILE_NAME = "A.TOC";
    public static final String LITTLE_RPF_TOC_FILE_NAME = "a.toc";
    public static final int DEFAULT_FRAME_SPACE = 300;
    protected RpfHeader head;
    protected String aTocFilePath;
    protected boolean aTocByteOrder;
    protected BinaryFile binFile;
    protected RpfFileSections.RpfLocationRecord[] locations;
    protected RpfTocEntry[] entries;
    protected String dir;
    protected boolean Dchum;
    protected long estimateDiskSpace;
    protected int numBoundaries;
    protected long numFrameIndexRecords;
    protected int indexRecordLength;
    protected long currencyTime;
    protected boolean valid = false;
    private int tocNumber = 0;
    protected Vector entryResponses = new Vector();
    protected boolean fullPathsInATOC = false;
    protected boolean DEBUG_RPF = false;
    protected boolean DEBUG_RPFTOC = false;
    protected boolean DEBUG_RPFTOCDETAIL = false;
    protected boolean DEBUG_RPFTOCFRAMEDETAIL = false;
    private static final int[] CADRG_zone_extents = new int[]{0, 32, 48, 56, 64, 68, 72, 76, 80, 90};

    public RpfTocHandler() {
        this.DEBUG_RPF = Debug.debugging("rpf");
        this.DEBUG_RPFTOC = Debug.debugging("rpftoc");
        this.DEBUG_RPFTOCDETAIL = Debug.debugging("rpftocdetail");
        this.DEBUG_RPFTOCFRAMEDETAIL = Debug.debugging("rpftocframedetail");
        this.estimateDiskSpace = 300L;
        if (Debug.debugging("rpftoc")) {
            Debug.error("RpfTocHandler: No TOC parent directory name in constructor");
        }
    }

    public RpfTocHandler(String parentDir) {
        this(parentDir, 0);
    }

    public RpfTocHandler(String parentDir, int TOCNumber) {
        this.tocNumber = TOCNumber;
        this.estimateDiskSpace = 300L;
        this.valid = this.loadFile(parentDir);
        if (!this.valid) {
            Debug.error("RpfTocHandler: Invalid TOC File in " + parentDir);
        }
    }

    public File getTocFile(String parentDir) {
        File file = new File(parentDir + "/" + RPF_TOC_FILE_NAME);
        if (!file.exists() && !(file = new File(parentDir + "/" + LITTLE_RPF_TOC_FILE_NAME)).exists()) {
            return null;
        }
        if (this.DEBUG_RPFTOCDETAIL) {
            Debug.output("RpfTocHandler: getTocFile(): TOC file is " + file);
        }
        return file;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean hasChanged() {
        return false;
    }

    public boolean reload() {
        return this.loadFile(this.dir);
    }

    public boolean loadFile(String parentDir) {
        boolean ret = true;
        String upperCaseVersion = parentDir + "/" + RPF_TOC_FILE_NAME;
        String lowerCaseVersion = parentDir + "/" + LITTLE_RPF_TOC_FILE_NAME;
        try {
            if (BinaryFile.exists(upperCaseVersion)) {
                this.binFile = new BinaryBufferedFile(upperCaseVersion);
                this.aTocFilePath = upperCaseVersion;
            } else if (BinaryFile.exists(lowerCaseVersion)) {
                this.binFile = new BinaryBufferedFile(lowerCaseVersion);
                this.aTocFilePath = lowerCaseVersion;
            }
            if (this.binFile == null) {
                return false;
            }
            if (this.DEBUG_RPFTOC) {
                Debug.output("RpfTocHandler: TOC file is in " + parentDir);
            }
            this.dir = parentDir + "/";
            if (!this.parseToc(this.binFile)) {
                ret = false;
                Debug.error("RpfTocHandler: loadFile(): error parsing A.TOC file!!");
            }
            this.aTocByteOrder = this.binFile.byteOrder();
            this.binFile.close();
        }
        catch (IOException e) {
            ret = false;
        }
        this.binFile = null;
        return ret;
    }

    protected boolean parseToc(BinaryFile binFile) {
        if (this.DEBUG_RPFTOC) {
            Debug.output("ENTER TOC parsing...");
        }
        try {
            binFile.seek(0L);
            this.head = new RpfHeader();
            if (!this.head.read(binFile)) {
                return false;
            }
            if (this.DEBUG_RPFTOC) {
                Debug.output("RpfTocHandler.parseToc: read header:\n" + this.head);
            }
            binFile.seek(this.head.locationSectionLocation);
            RpfFileSections rfs = new RpfFileSections(binFile);
            this.locations = rfs.getLocations(4);
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): fseek to Boundary section subheader: " + this.locations[0].componentLocation);
            }
            binFile.seek(this.locations[0].componentLocation);
            long boundRectTableOffset = binFile.readInteger();
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): BoundRectTableOffset: " + boundRectTableOffset);
            }
            int n = binFile.readShort();
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): # Boundary rect. recs: " + n);
            }
            this.numBoundaries = n;
            short boundaryRecordLength = binFile.readShort();
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): should be 132: " + boundaryRecordLength);
            }
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): fseek to Boundary Rectangle Table: " + this.locations[1].componentLocation);
            }
            binFile.seek(this.locations[1].componentLocation);
            this.entries = new RpfTocEntry[this.numBoundaries];
            for (int i = 0; i < n; ++i) {
                if (this.DEBUG_RPFTOCDETAIL) {
                    Debug.output("RpfTocHandler: parseToc(): read boundary rec#: " + i);
                }
                this.entries[i] = new RpfTocEntry(binFile, this.tocNumber, i);
                if (!this.DEBUG_RPFTOCDETAIL) continue;
                Debug.output("RpfTocHandler: parseToc(): entry " + i + " has scale " + this.entries[i].scale + ", type " + (this.entries[i].Cib ? "CIB" : "CADRG") + " in zone " + this.entries[i].zone);
                if (!this.entries[i].Cib) continue;
                Debug.output("RpfTocHandler: parseToc(): entry noted as a Cib entry.");
            }
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): Read frame file index section subheader at loc: " + this.locations[2].componentLocation);
            }
            binFile.seek(this.locations[2].componentLocation + 1L);
            long frameIndexTableOffset = binFile.readInteger();
            this.numFrameIndexRecords = binFile.readInteger();
            short numPathnameRecords = binFile.readShort();
            this.indexRecordLength = binFile.readShort();
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): frameIndexTableOffset: " + frameIndexTableOffset);
                Debug.output("RpfTocHandler: parseToc(): # Frame file index recs: " + this.numFrameIndexRecords);
                Debug.output("RpfTocHandler: parseToc(): # pathname records: " + numPathnameRecords);
                Debug.output("RpfTocHandler: parseToc(): Index rec len(33): " + this.indexRecordLength);
            }
            this.figureOutChartSeriesForEntries(binFile);
        }
        catch (IOException ioe) {
            Debug.error("RpfTocHandler: IO ERROR parsing file!\n\t" + ioe);
            return false;
        }
        catch (FormatException fe) {
            Debug.error("RpfTocHandler: Format ERROR parsing file!\n\t" + fe);
            return false;
        }
        if (this.DEBUG_RPFTOC) {
            Debug.output("LEAVE TOC parsing...");
        }
        return true;
    }

    protected void figureOutChartSeriesForEntries(BinaryFile binFile) throws IOException, FormatException {
        RpfTocEntry[] entriesAlreadyChecked = new RpfTocEntry[this.entries.length];
        System.arraycopy(this.entries, 0, entriesAlreadyChecked, 0, this.entries.length);
        int i = 0;
        while ((long)i < this.numFrameIndexRecords) {
            if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): Read frame file index rec #: " + i);
            }
            binFile.seek(this.locations[3].componentLocation + (long)(this.indexRecordLength * i));
            short boundaryId = binFile.readShort();
            if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                Debug.output("boundary id for frame: " + i + " is " + boundaryId);
            }
            if (boundaryId > this.numBoundaries - 1) {
                throw new FormatException("Bad boundary id in FF index record " + i);
            }
            RpfTocEntry entry = entriesAlreadyChecked[boundaryId];
            if (entry != null) {
                entriesAlreadyChecked[boundaryId] = null;
                binFile.readShort();
                binFile.readShort();
                binFile.readInteger();
                String filename = binFile.readFixedLengthString(12);
                int dot = filename.lastIndexOf(46);
                entry.setInfo(filename.substring(dot + 1, dot + 3).intern());
            }
            ++i;
        }
    }

    protected void loadFrameInformation(RpfTocEntry rpfTocEntry) {
        try {
            if (this.binFile == null && this.aTocFilePath != null) {
                this.binFile = new BinaryBufferedFile(this.aTocFilePath);
                this.binFile.byteOrder(this.aTocByteOrder);
                this.readFrameInformation(this.binFile, rpfTocEntry);
                this.binFile.close();
                this.binFile = null;
            }
        }
        catch (IOException ioe) {
            Debug.error("RpfTocHandler: IO ERROR parsing file for frame information!\n\t" + ioe);
        }
        catch (FormatException fe) {
            Debug.error("RpfTocHandler: Format ERROR parsing file for frame information!\n\t" + fe);
        }
    }

    protected void readFrameInformation(BinaryFile binFile, RpfTocEntry entry) throws IOException, FormatException {
        int currentBoundaryIdForEntry = entry.coverage.entryNumber;
        int i = 0;
        while ((long)i < this.numFrameIndexRecords) {
            if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                Debug.output("RpfTocHandler: parseToc(): Read frame file index rec #: " + i);
            }
            binFile.seek(this.locations[3].componentLocation + (long)(this.indexRecordLength * i));
            short boundaryId = binFile.readShort();
            if (boundaryId == currentBoundaryIdForEntry) {
                long pathOffset;
                if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                    Debug.output("boundary id for frame: " + i + " is " + boundaryId);
                }
                if (boundaryId > this.numBoundaries - 1) {
                    throw new FormatException("Bad boundary id in FF index record " + i);
                }
                short frameRow = binFile.readShort();
                short frameCol = binFile.readShort();
                if (frameRow > entry.vertFrames - 1) {
                    throw new FormatException("Bad row number: " + frameRow + ", in FF index record " + i + ", Min row num=0;  Max. row num:" + (entry.horizFrames - 1));
                }
                if (frameCol > entry.horizFrames - 1) {
                    throw new FormatException(" Bad col number in FF index record " + i);
                }
                RpfFrameEntry frame = entry.getFrame(entry.vertFrames - 1 - frameRow, frameCol);
                if (frame.exists && this.DEBUG_RPFTOCDETAIL) {
                    Debug.output("FF " + i + " is a duplicate");
                }
                if ((pathOffset = (long)binFile.readInteger()) >= 0L) {
                    String tempPath;
                    int currentPosition = (int)binFile.getFilePointer();
                    binFile.seek(this.locations[3].componentLocation + pathOffset);
                    short pathLength = binFile.readShort();
                    if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                        Debug.output("RpfTocHandler: parseToc(): pathLength:" + pathLength);
                    }
                    String rpfdir = this.dir;
                    StringBuffer sBuf = new StringBuffer(pathLength);
                    String pathTest = binFile.readFixedLengthString(2);
                    this.fullPathsInATOC = !pathTest.equals("./");
                    if (!this.fullPathsInATOC) {
                        sBuf.append(binFile.readFixedLengthString(pathLength - 2));
                    } else {
                        sBuf.append(pathTest);
                        sBuf.append(binFile.readFixedLengthString(pathLength - 2));
                    }
                    String directory = sBuf.toString().trim();
                    if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                        Debug.output("RpfTocHandler: parseToc(): frame directory: " + directory);
                    }
                    binFile.seek(currentPosition);
                    String filename = binFile.readFixedLengthString(12);
                    if (this.DEBUG_RPFTOCFRAMEDETAIL) {
                        Debug.output("RpfTocHandler: parseToc(): frame filename: " + filename);
                    }
                    int dot = filename.lastIndexOf(46);
                    entry.setInfo(filename.substring(dot + 1, dot + 3).intern());
                    if (!this.fullPathsInATOC) {
                        tempPath = rpfdir + directory + filename;
                        frame.rpfdirIndex = (short)(rpfdir.length() - 3);
                        frame.filenameIndex = (short)(rpfdir.length() + directory.length());
                    } else {
                        tempPath = directory + filename;
                        frame.filenameIndex = (short)directory.length();
                    }
                    frame.framePath = tempPath;
                    frame.exists = true;
                    if (frame.framePath == null) {
                        Debug.output("RpfTocHandler: Frame " + tempPath + " doesn't exist.  Please rebuild A.TOC file using MakeToc, or check read permissions for the file.");
                    }
                }
            }
            ++i;
        }
    }

    public static String translateScaleToSeries(long scale) {
        if (scale == 0L) {
            return "Various    ";
        }
        if (scale == 50000L) {
            return "1:50K      ";
        }
        if (scale == 100000L) {
            return "1:100K     ";
        }
        if (scale == 200000L) {
            return "1:200K     ";
        }
        if (scale == 250000L) {
            return "1:250K     ";
        }
        if (scale == 500000L) {
            return "1:500K     ";
        }
        if (scale == 1000000L) {
            return "1:1M       ";
        }
        if (scale == 2000000L) {
            return "1:2M       ";
        }
        if (scale == 5000000L) {
            return "1:5M       ";
        }
        if (scale == 66666L) {
            return "10M         ";
        }
        if (scale == 33333L) {
            return "5M          ";
        }
        return null;
    }

    public static long textScaleToLong(String textScale) {
        long realValue;
        long resolution = 1L;
        int commaIndex = textScale.indexOf(44);
        while (commaIndex != -1) {
            StringBuffer buf = new StringBuffer(textScale.substring(0, commaIndex));
            buf.append(textScale.substring(commaIndex + 1));
            textScale = buf.toString();
            commaIndex = textScale.indexOf(44);
        }
        int colon = textScale.indexOf(":");
        try {
            StringBuffer buf;
            int expLetter;
            if (colon == -1) {
                expLetter = textScale.indexOf("m");
                if (expLetter == -1) {
                    expLetter = textScale.indexOf("M");
                }
                if (expLetter != -1) {
                    resolution = Long.parseLong(textScale.substring(0, expLetter));
                    return (long)((double)resolution / 1.5E-4);
                }
            }
            String expValue = "";
            expLetter = textScale.lastIndexOf(75);
            int expLetterSmall = textScale.lastIndexOf(107);
            if (expLetter == -1 && expLetterSmall == -1) {
                expLetter = textScale.lastIndexOf(77);
                expLetterSmall = textScale.lastIndexOf(109);
                if (expLetter != -1 || expLetterSmall != -1) {
                    expValue = "000000";
                }
            } else {
                expValue = "000";
            }
            if (!expValue.equals("")) {
                if (expLetter == -1) {
                    expLetter = expLetterSmall;
                }
                buf = new StringBuffer(textScale.substring(colon + 1, expLetter));
                buf.append(expValue);
            } else {
                buf = new StringBuffer(textScale.substring(colon + 1));
            }
            String longString = buf.toString().trim();
            realValue = Long.parseLong(longString);
        }
        catch (NumberFormatException nfe) {
            if (Debug.debugging("rpftoc")) {
                Debug.output("textScaleToLong: Number Format Exception!!!!" + textScale);
            }
            return (long)RpfConstants.UK.scale;
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            if (Debug.debugging("rpftoc")) {
                Debug.output("textScaleToLong: String index out of bounds:\n" + sioobe.getMessage());
            }
            return (long)RpfConstants.UK.scale;
        }
        if (colon != -1) {
            resolution = Long.parseLong(textScale.substring(0, colon));
        }
        long ret = realValue / resolution;
        if (Debug.debugging("rpftoc")) {
            Debug.output("RpfTocHandler: textScaleToLong converted " + textScale + " to " + ret);
        }
        return ret;
    }

    protected int getASCIIZone(float ullat, int zone) {
        int z = zone;
        if (ullat > 0.0f) {
            z += 48;
        } else if ((z += 64) == 73) {
            ++z;
        }
        return z;
    }

    public void getCatalogCoverage(float ullat, float ullon, float lrlat, float lrlon, CADRG proj, String chartSeriesCode, Vector coverages) {
        if (!this.valid) {
            return;
        }
        for (int i = 0; i < this.numBoundaries; ++i) {
            this.entries[i].coverage.reset();
            String chartSeries = chartSeriesCode == null ? "ANY" : chartSeriesCode;
            if (!chartSeries.equalsIgnoreCase("ANY") && !chartSeries.equalsIgnoreCase(this.entries[i].info.seriesCode) || !(this.entries[i].coverage.setPercentCoverage(ullat, ullon, lrlat, lrlon) > 0.0f)) continue;
            coverages.addElement(this.entries[i].coverage);
        }
    }

    public List getBestCoverageEntry(float ullat, float ullon, float lrlat, float lrlon, CADRG proj, RpfViewAttributes viewAtts) {
        int i;
        if (!this.valid) {
            return null;
        }
        Vector<RpfTocEntry> coverageEntries = new Vector<RpfTocEntry>();
        double scaleFactor = 0.0;
        double lowerScaleFactorLimit = 1.0;
        double upperScaleFactorLimit = 1.0;
        int prevBoundaryHits = 0;
        if (viewAtts != null) {
            lowerScaleFactorLimit = 1.0 / (double)viewAtts.imageScaleFactor;
            upperScaleFactorLimit = viewAtts.imageScaleFactor;
        }
        int nscale = 0;
        int scale = (int)proj.getScale();
        RpfTocEntry bestEntry = null;
        if (this.DEBUG_RPFTOCDETAIL) {
            Debug.output("getBestCoverageEntry(): Checking for coverage");
            Debug.output("  nw_lat: " + ullat);
            Debug.output("  se_lat: " + lrlat);
            Debug.output("  nw_lon: " + ullon);
            Debug.output("  se_lon: " + lrlon);
        }
        int zone = this.getASCIIZone(ullat, proj.getZone());
        char[] okZones = RpfTocHandler.getOkZones(ullat, lrlat, (char)zone);
        for (i = 0; i < this.numBoundaries; ++i) {
            RpfTocEntry currentEntry = this.entries[i];
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("********************");
                Debug.output("  tochandler: Boundary #" + i);
                Debug.output(currentEntry.toString());
            }
            currentEntry.coverage.reset();
            if (currentEntry.info == null || currentEntry.info.scale == -1.0f) {
                nscale = (int)RpfTocHandler.textScaleToLong(currentEntry.scale);
                currentEntry.info = new RpfProductInfo();
                currentEntry.info.scale = nscale;
                currentEntry.info.scaleString = currentEntry.scale;
                currentEntry.coverage.scale = nscale;
            } else {
                currentEntry.coverage.scale = currentEntry.info.scale;
                nscale = (int)currentEntry.info.scale;
            }
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("getBestCoverageEntry(): Query scale = " + scale + " vs. brect scale = " + nscale);
            }
            scaleFactor = viewAtts != null && !viewAtts.scaleImages ? (scale == nscale ? 1.0 : lowerScaleFactorLimit - 1.0) : (double)nscale / (double)scale;
            String chartSeries = viewAtts == null ? "ANY" : viewAtts.chartSeries;
            if (!(scaleFactor >= lowerScaleFactorLimit) || !(scaleFactor <= upperScaleFactorLimit) || !chartSeries.equalsIgnoreCase("ANY") && !chartSeries.equalsIgnoreCase(currentEntry.info.seriesCode) || !RpfTocHandler.isOkZone(currentEntry.zone, okZones)) continue;
            int hits = currentEntry.coverage.setBoundaryHits(ullat, ullon, lrlat, lrlon);
            if (this.DEBUG_RPFTOCDETAIL) {
                Debug.output("getBestCoverageEntry(): Boundary Hits = " + hits);
            }
            if (bestEntry != null) {
                float bestScaleDiff;
                boolean betterScale = false;
                float newScaleDiff = RpfFrameCacheHandler.scaleDifference(proj, currentEntry.coverage);
                if (newScaleDiff <= (bestScaleDiff = RpfFrameCacheHandler.scaleDifference(proj, bestEntry.coverage))) {
                    betterScale = true;
                }
                if (betterScale && currentEntry.coverage.setPercentCoverage(ullat, ullon, lrlat, lrlon) >= bestEntry.coverage.getPercentCoverage() && (hits >= prevBoundaryHits || hits >= 6)) {
                    if (newScaleDiff < bestScaleDiff) {
                        coverageEntries.clear();
                    }
                    coverageEntries.add(currentEntry);
                    bestEntry = currentEntry;
                    prevBoundaryHits = hits;
                    if (!this.DEBUG_RPFTOC) continue;
                    Debug.output("getBestCoverageEntry(): Found a match in a BR with coverage of " + currentEntry.coverage.getPercentCoverage() + "%.");
                    continue;
                }
                if (!betterScale || !(currentEntry.coverage.getPercentCoverage() > 0.0f)) continue;
                if (newScaleDiff < bestScaleDiff) {
                    coverageEntries.clear();
                }
                coverageEntries.add(currentEntry);
                continue;
            }
            if (hits <= prevBoundaryHits || !(currentEntry.coverage.setPercentCoverage(ullat, ullon, lrlat, lrlon) > 0.0f)) continue;
            bestEntry = currentEntry;
            prevBoundaryHits = hits;
            coverageEntries.add(currentEntry);
            if (!this.DEBUG_RPFTOC) continue;
            Debug.output("getBestCoverageEntry(): Found a match in a BR with coverage of " + currentEntry.coverage.getPercentCoverage() + "%.");
        }
        if (this.DEBUG_RPFTOC) {
            if (bestEntry != null) {
                Debug.output("getBestCoverageEntry(): found the best");
                Debug.output("################");
                Debug.output(bestEntry.toString());
                Debug.output("Returning the following coverage boxes: ");
                for (i = 0; i < coverageEntries.size(); ++i) {
                    Debug.output(coverageEntries.get(i).toString());
                }
            } else {
                Debug.output("getBestCoverageEntry(): no box found");
            }
        }
        return coverageEntries;
    }

    public static char[] getOkZones(float ullat, float lrlat, char zone) {
        char backupZone;
        int i;
        char[] okZones = new char[7];
        okZones[0] = zone;
        char currentZone = zone;
        for (i = 0; i < 3 && RpfTocHandler.isAboveZone(ullat, currentZone); ++i) {
            okZones[i + 1] = backupZone = RpfTocHandler.getHigherZone(currentZone);
            currentZone = backupZone;
        }
        currentZone = zone;
        for (int k = i; k < i + 3 && RpfTocHandler.isBelowZone(ullat, currentZone); ++k) {
            okZones[k + 1] = backupZone = RpfTocHandler.getLowerZone(currentZone);
            currentZone = backupZone;
        }
        int size = 0;
        for (int j = 0; j < okZones.length; ++j) {
            if (okZones[j] == '\u0000') continue;
            ++size;
        }
        char[] returnZones = new char[size];
        for (int j = 0; j < size; ++j) {
            returnZones[j] = okZones[j];
        }
        return returnZones;
    }

    public static boolean isOkZone(char zone, char[] okZones) {
        boolean ok = false;
        for (int i = 0; i < okZones.length; ++i) {
            if (zone != okZones[i]) continue;
            ok = true;
        }
        return ok;
    }

    protected static boolean isBelowZone(float lowerLat, char zone) {
        float zoneLowerLat = RpfTocHandler.getLowerZoneExtent(zone);
        return lowerLat < zoneLowerLat;
    }

    protected static boolean isAboveZone(float upperLat, char zone) {
        float zoneUpperLat = RpfTocHandler.getUpperZoneExtent(zone);
        return upperLat > zoneUpperLat;
    }

    public static float getUpperZoneExtent(char zone) {
        if (zone >= '0' && zone <= '9') {
            int i = zone - 49;
            return CADRG_zone_extents[i + 1];
        }
        int i = zone - 65;
        if (i == 9) {
            --i;
        }
        return -1 * CADRG_zone_extents[i];
    }

    public static float getLowerZoneExtent(char zone) {
        if (zone >= '0' && zone <= '9') {
            int i = zone - 49;
            return CADRG_zone_extents[i];
        }
        int i = zone - 65;
        if (i == 9) {
            --i;
        }
        return -1 * CADRG_zone_extents[i + 1];
    }

    public static char getLowerZone(char zone) {
        if (zone >= '2' && zone <= '9') {
            zone = (char)(zone - '\u0001');
        } else if (zone == '1') {
            zone = (char)65;
        } else if (zone >= 'A' && zone < 'H') {
            zone = (char)(zone + '\u0001');
        } else if (zone == 'H') {
            zone = (char)74;
        }
        return zone;
    }

    public static char getHigherZone(char zone) {
        if (zone >= '1' && zone < '9') {
            zone = (char)(zone + '\u0001');
        } else if (zone >= 'B' && zone < 'J' || zone >= 'b' && zone < 'j') {
            zone = (char)(zone - '\u0001');
        } else if (zone == 'J' || zone == 'j') {
            zone = (char)(zone - 2);
        } else if (zone == 'A' || zone == 'a') {
            zone = (char)49;
        }
        return zone;
    }

    public RpfTocEntry[] getEntries() {
        return this.entries;
    }

    public String getATocFilePath() {
        return this.aTocFilePath;
    }

    public void setATocFilePath(String tocFilePath) {
        this.aTocFilePath = tocFilePath;
    }

    public boolean isFullPathsInATOC() {
        return this.fullPathsInATOC;
    }

    public void setFullPathsInATOC(boolean fullPathsInATOC) {
        this.fullPathsInATOC = fullPathsInATOC;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            Debug.output("Usage: java RpfTocHandler <path to RPF directory>");
            return;
        }
        Debug.init(System.getProperties());
        RpfTocHandler toc = new RpfTocHandler();
        if (!toc.loadFile(args[0])) {
            Debug.output("RpfTocHandler: NOT read sucessfully!");
        } else {
            RpfTocEntry[] e = toc.getEntries();
            Debug.output("For A.TOC: " + args[0]);
            for (int i = 0; i < e.length; ++i) {
                Debug.output(e[i].toString());
            }
        }
        System.exit(0);
    }
}

