/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ProjectionChangePolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;

public class StandardPCPolicy
implements ProjectionChangePolicy {
    protected OMGraphicHandlerLayer layer;
    protected int graphicCutoff = 50;
    protected boolean alwaysSpawnThread = false;

    public StandardPCPolicy() {
    }

    public StandardPCPolicy(OMGraphicHandlerLayer layer) {
        this(layer, true);
    }

    public StandardPCPolicy(OMGraphicHandlerLayer layer, boolean alwaysSpawnThreadForPrepare) {
        this.setLayer(layer);
        this.setAlwaysSpawnThread(alwaysSpawnThreadForPrepare);
    }

    public void setLayer(OMGraphicHandlerLayer l) {
        this.layer = l;
    }

    public OMGraphicHandlerLayer getLayer() {
        return this.layer;
    }

    public void setAlwaysSpawnThread(boolean val) {
        this.alwaysSpawnThread = val;
    }

    public boolean getAlwaysSpawnThread() {
        return this.alwaysSpawnThread;
    }

    public void projectionChanged(ProjectionEvent pe) {
        if (this.layer != null) {
            Projection proj = this.layer.setProjection(pe);
            if (proj != null) {
                if (this.shouldSpawnThreadForPrepare()) {
                    if (Debug.debugging("layer")) {
                        Debug.output(this.getLayer().getName() + ": StandardPCPolicy projectionChanged with NEW projection, spawning thread to handle it.");
                    }
                    if (this.layer.isProjectionOK(proj)) {
                        this.layer.doPrepare();
                    }
                    return;
                }
                if (Debug.debugging("layer")) {
                    Debug.output(this.getLayer().getName() + ": StandardPCPolicy projectionChanged with NEW projection, handling it within current thread.");
                }
                this.layer.fireStatusUpdate(8342);
                if (this.layer.isProjectionOK(proj)) {
                    this.layer.prepare();
                }
                this.layer.repaint();
            } else {
                this.layer.repaint();
            }
            this.layer.fireStatusUpdate(8359);
        } else {
            Debug.error("StandardPCPolicy.projectionChanged(): NULL layer, can't do anything.");
        }
    }

    public void workerComplete(OMGraphicList aList) {
        if (this.layer != null) {
            this.layer.setList(aList);
        }
    }

    protected boolean shouldSpawnThreadForPrepare() {
        OMGraphicList list;
        if (this.layer != null && !this.alwaysSpawnThread && (list = this.layer.getList()) != null) {
            return this.layer.getList().size() > this.graphicCutoff;
        }
        return true;
    }

    public void setGraphicCutoff(int number) {
        this.graphicCutoff = number;
    }

    public int getGraphicCutoff() {
        return this.graphicCutoff;
    }
}

