/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.ProjectionChangePolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;

public class ListResetPCPolicy
implements ProjectionChangePolicy {
    protected OMGraphicHandlerLayer layer;

    public ListResetPCPolicy() {
    }

    public ListResetPCPolicy(OMGraphicHandlerLayer layer) {
        this.layer = layer;
    }

    public void setLayer(OMGraphicHandlerLayer l) {
        this.layer = l;
    }

    public OMGraphicHandlerLayer getLayer() {
        return this.layer;
    }

    public void projectionChanged(ProjectionEvent pe) {
        if (this.layer != null) {
            Projection proj = this.layer.setProjection(pe);
            if (proj != null) {
                if (Debug.debugging("layer")) {
                    Debug.output(this.getLayer().getName() + ": ListResetPCPolicy projectionChanged with NEW projection, resetting list.");
                }
                this.layer.setList(null);
                if (this.layer.isProjectionOK(proj)) {
                    this.layer.doPrepare();
                }
            } else {
                if (Debug.debugging("layer")) {
                    Debug.output(this.getLayer().getName() + ": ListResetPCPolicy projectionChanged with OLD projection, repainting.");
                }
                if (!this.layer.isWorking()) {
                    this.layer.repaint();
                    this.layer.fireStatusUpdate(8359);
                }
            }
        } else {
            Debug.error("ListResetPCPolicy.projectionChanged():  NULL layer, can't do anything.");
        }
    }

    public void workerComplete(OMGraphicList aList) {
        if (this.layer != null) {
            this.layer.setList(aList);
        }
    }
}

