/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location.db;

import com.bbn.openmap.util.Debug;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class RecordSet {
    protected Connection connection = null;
    protected String queryString = null;
    private Statement stmt;
    private ResultSet rset;

    public RecordSet(Connection inConnection) throws SQLException {
        this(inConnection, null);
    }

    public RecordSet(Connection inConnection, String query) throws SQLException {
        this.connection = inConnection;
        this.queryString = query;
        this.getAllQuery();
    }

    public void getAllQuery() throws SQLException {
        if (this.queryString != null && this.connection != null) {
            try {
                if (Debug.debugging("location")) {
                    Debug.output("RecordSet calling database with query => " + this.queryString);
                }
                this.stmt = this.connection.createStatement();
                this.rset = this.stmt.executeQuery(this.queryString);
            }
            catch (SQLException sqlE) {
                throw new SQLException(this.queryString + " | " + sqlE.getMessage());
            }
        } else {
            Debug.error("Database parameters faulty!\n  query => " + this.queryString + "\n  connection => " + this.connection);
        }
    }

    public boolean next() throws SQLException {
        if (this.rset != null) {
            return this.rset.next();
        }
        return false;
    }

    public ResultSet getResultSet() {
        return this.rset;
    }

    public void close() throws SQLException {
        if (this.rset != null) {
            this.rset.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection inConnection) {
        this.connection = inConnection;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String inQueryString) {
        this.queryString = inQueryString;
    }
}

