/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location.db;

import com.bbn.openmap.layer.location.db.RecordSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class LocationData {
    protected Connection connection;
    protected String cityName;
    protected String stateName;
    protected String graphicName;
    protected float latitude;
    protected float longitude;
    protected String queryString = null;
    private Statement stmt;
    private ResultSet rset;

    public LocationData() {
    }

    public LocationData(Connection inConnection) {
        this.connection = inConnection;
    }

    public LocationData(RecordSet drs) throws SQLException {
        ResultSet rset = drs.getResultSet();
        this.cityName = rset.getString(1);
        this.stateName = rset.getString(2);
        this.graphicName = rset.getString(3);
        this.latitude = rset.getFloat(4);
        this.longitude = rset.getFloat(5);
    }

    public void close() throws SQLException {
        this.rset.close();
        this.stmt.close();
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection inConnection) {
        this.connection = inConnection;
    }

    public String getCityName() {
        return this.cityName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public String getGraphicName() {
        return this.graphicName;
    }

    public float getLatitude() {
        return this.latitude;
    }

    public float getLongitude() {
        return this.longitude;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String inQueryString) {
        this.queryString = inQueryString;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("Location Data values:\n");
        s.append(" City Name = " + this.cityName + "\n");
        s.append(" State Name = " + this.stateName + "\n");
        s.append(" Graphic = " + this.graphicName + "\n");
        s.append(" Latitude = " + this.latitude + "\n");
        s.append(" Longitude = " + this.longitude + "\n");
        return s.toString();
    }

    public static void main(String[] args) {
        System.out.println("\n*** LocationData looks for the following query: ***\n");
        System.out.println(" select CITY (string), STATE (string), GRAPHIC (string, url or graphic name), LATITUDE (float), LONGITUDE (float) from LOCATION_TABLE (tablename where data is stored)\n");
        System.out.println("Note: Column names and tablename should reflect whatever is stored in the database.  Data types should match what this class is expecting, in the order listed here.\n");
    }
}

