/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location.db;

import com.bbn.openmap.layer.location.AbstractLocationHandler;
import com.bbn.openmap.layer.location.ByteRasterLocation;
import com.bbn.openmap.layer.location.LocationCBMenuItem;
import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.layer.location.LocationMenuItem;
import com.bbn.openmap.layer.location.LocationPopupMenu;
import com.bbn.openmap.layer.location.db.LocationData;
import com.bbn.openmap.layer.location.db.RawDataRecordSet;
import com.bbn.openmap.layer.location.db.RecordSet;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import com.bbn.openmap.util.quadtree.QuadTree;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;

public class DBLocationHandler
extends AbstractLocationHandler
implements LocationHandler,
ActionListener {
    protected QuadTree quadtree = null;
    protected String jdbcString = null;
    public static final String jdbcStringProperty = "jdbcString";
    protected String jdbcDriver = null;
    public static final String jdbcDriverProperty = "jdbcDriver";
    protected String userName = null;
    protected String userPassword = null;
    public static final String userNameProperty = "userName";
    public static final String userPasswordProperty = "userPassword";
    public static final String locationQueryStringProperty = "locationQueryString";
    protected String locationQueryString = null;
    protected Properties props;
    protected Box box = null;

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = this.getPropertyPrefix();
        prefix = prefix != null ? prefix + "." : "";
        this.props = properties;
        this.jdbcString = properties.getProperty(prefix + jdbcStringProperty);
        this.jdbcDriver = properties.getProperty(prefix + jdbcDriverProperty);
        this.userName = properties.getProperty(prefix + userNameProperty);
        this.userPassword = properties.getProperty(prefix + userPasswordProperty);
        this.locationQueryString = properties.getProperty(prefix + locationQueryStringProperty);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = this.getPropertyPrefix();
        prefix = prefix != null ? prefix + "." : "";
        props.put(prefix + "class", this.getClass().getName());
        props.put(prefix + jdbcStringProperty, PropUtils.unnull(this.jdbcString));
        props.put(prefix + jdbcDriverProperty, PropUtils.unnull(this.jdbcDriver));
        props.put(prefix + userNameProperty, PropUtils.unnull(this.userName));
        props.put(prefix + userPasswordProperty, PropUtils.unnull(this.userPassword));
        props.put(prefix + locationQueryStringProperty, PropUtils.unnull(this.locationQueryString));
        props.put(prefix + "rawDataTableName", PropUtils.unnull(props.getProperty(prefix + "rawDataTableName")));
        props.put(prefix + "rawDataColumnName", PropUtils.unnull(props.getProperty(prefix + "rawDataColumnName")));
        props.put(prefix + "rawDataKeyColumnName", PropUtils.unnull(props.getProperty(prefix + "rawDataKeyColumnName")));
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        list.put("class.editor", "com.bbn.openmap.util.propertyEditor.NonEditablePropertyEditor");
        list.put(jdbcStringProperty, "JDBC login string");
        list.put(jdbcDriverProperty, "JDBC driver class name");
        list.put(userNameProperty, "User name");
        list.put(userPasswordProperty, "User password");
        list.put(locationQueryStringProperty, "Select statement that the data object needs.");
        list.put("rawDataTableName", "The name of the table in the database that holds the images.");
        list.put("rawDataColumnName", "The name of the column in the table in the database that holds the name (key) of the image.");
        list.put("rawDataKeyColumnName", "The name of the column in the table in the database that holds the raw image bytes.");
        return list;
    }

    public void reloadData() {
        this.quadtree = this.createData();
    }

    protected QuadTree createData() {
        QuadTree qt = new QuadTree(90.0f, -180.0f, -90.0f, 180.0f, 100, 50.0f);
        if (this.locationQueryString == null) {
            return qt;
        }
        try {
            if (this.jdbcDriver != null) {
                Class.forName(this.getJdbcDriver());
            }
            Connection connection = DriverManager.getConnection(this.getJdbcString(), this.getUserName(), this.getUserPassword());
            RawDataRecordSet gifdataRS = new RawDataRecordSet(connection, this.getPropertyPrefix(), this.props);
            RecordSet locationdataRS = new RecordSet(connection, this.locationQueryString);
            while (locationdataRS.next()) {
                LocationData ld = new LocationData(locationdataRS);
                if (Debug.debugging("location")) {
                    Debug.output("DBLocationHandler:  location information:\n" + ld);
                }
                byte[] bytearr = gifdataRS.getRawData(ld.getGraphicName());
                float lat = ld.getLatitude();
                float lon = ld.getLongitude();
                ByteRasterLocation loc = new ByteRasterLocation(lat, lon, ld.getCityName(), bytearr);
                loc.setLocationHandler(this);
                loc.setShowName(this.isShowNames());
                loc.setShowLocation(this.isShowLocations());
                loc.setLocationPaint(this.getLocationColor());
                loc.getLabel().setLinePaint(this.getNameColor());
                loc.setDetails(ld.getCityName() + " is at lat: " + lat + ", lon: " + lon);
                qt.put(lat, lon, loc);
            }
            locationdataRS.close();
            connection.close();
        }
        catch (SQLException sqlE) {
            Debug.error("DBLocationHandler:SQL Exception: " + sqlE.getMessage());
            sqlE.printStackTrace();
        }
        catch (ClassNotFoundException cnfE) {
            Debug.error("DBLocationHandler: Class not found Exception: " + cnfE);
        }
        return qt;
    }

    public String getJdbcString() {
        return this.jdbcString;
    }

    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getUserPassword() {
        return this.userPassword;
    }

    public Properties getLocationProperties() {
        return this.props;
    }

    public Vector get(float nwLat, float nwLon, float seLat, float seLon, Vector graphicList) {
        if (this.quadtree == null) {
            Debug.output("DBLocationHandler: Figuring out the locations and names! (This is a one-time operation!)");
            this.quadtree = this.createData();
        }
        if (this.quadtree != null) {
            if (Debug.debugging("location")) {
                Debug.output("DBLocationHandler|DBLocationHandler.get() ul.lon = " + nwLon + " lr.lon = " + seLon + " delta = " + (seLon - nwLon));
            }
            this.quadtree.get(nwLat, nwLon, seLat, seLon, graphicList);
        }
        return graphicList;
    }

    public void fillLocationPopUpMenu(LocationPopupMenu locMenu) {
        LocationCBMenuItem lcbi = new LocationCBMenuItem("Always Show Name", locMenu, this.getLayer());
        lcbi.setState(locMenu.getLoc().isShowName());
        locMenu.add(lcbi);
        locMenu.add(new LocationMenuItem("Show Details", locMenu, this.getLayer()));
    }

    public Component getGUI() {
        if (this.box == null) {
            JCheckBox showDBLocationCheck = new JCheckBox("Show Locations", this.isShowLocations());
            showDBLocationCheck.setActionCommand("showLocations");
            showDBLocationCheck.addActionListener(this);
            JCheckBox showNameCheck = new JCheckBox("Show Location Names", this.isShowNames());
            showNameCheck.setActionCommand("showNames");
            showNameCheck.addActionListener(this);
            JButton rereadFilesButton = new JButton("Reload Data From Source");
            rereadFilesButton.setActionCommand("readData");
            rereadFilesButton.addActionListener(this);
            this.box = Box.createVerticalBox();
            this.box.add(showDBLocationCheck);
            this.box.add(showNameCheck);
            this.box.add(rereadFilesButton);
        }
        return this.box;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "showLocations") {
            JCheckBox locationCheck = (JCheckBox)e.getSource();
            this.setShowLocations(locationCheck.isSelected());
            if (Debug.debugging("location")) {
                Debug.output("DBLocationHandler::actionPerformed showLocations is " + this.isShowLocations());
            }
            this.getLayer().repaint();
        } else if (cmd == "showNames") {
            JCheckBox namesCheck = (JCheckBox)e.getSource();
            this.setShowNames(namesCheck.isSelected());
            if (Debug.debugging("location")) {
                Debug.output("DBLocationHandler::actionPerformed showNames is " + this.isShowNames());
            }
            this.getLayer().repaint();
        } else if (cmd == "readData") {
            Debug.output("DBLocationHandler: Re-reading Locations file");
            this.quadtree = null;
            this.getLayer().doPrepare();
        } else {
            Debug.error("DBLocationHandler: Unknown action command \"" + cmd + "\" in actionPerformed().");
        }
    }
}

