/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.location;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.layer.location.LocationHandler;
import com.bbn.openmap.layer.location.LocationLayer;
import com.bbn.openmap.layer.location.LocationPopupMenu;
import com.bbn.openmap.omGraphics.DrawingAttributes;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractLocationHandler
implements LocationHandler {
    protected LocationLayer zLayer;
    private boolean showNames = false;
    protected DrawingAttributes nameDrawingAttributes;
    private boolean showLocations = true;
    protected DrawingAttributes locationDrawingAttributes;
    private boolean forceGlobal = true;
    protected String propertyPrefix = null;
    protected transient I18n i18n = Environment.getI18n();
    static /* synthetic */ Class class$com$bbn$openmap$layer$location$AbstractLocationHandler;

    protected AbstractLocationHandler() {
        this.nameDrawingAttributes = new DrawingAttributes();
        this.locationDrawingAttributes = new DrawingAttributes();
    }

    public void fillLocationPopUpMenu(LocationPopupMenu lpm) {
    }

    public void setLayer(LocationLayer l) {
        this.zLayer = l;
    }

    public LocationLayer getLayer() {
        return this.zLayer;
    }

    public boolean isShowNames() {
        return this.showNames;
    }

    public void setShowNames(boolean set) {
        this.showNames = set;
    }

    public boolean isShowLocations() {
        return this.showLocations;
    }

    public void setShowLocations(boolean set) {
        this.showLocations = set;
    }

    public boolean isForceGlobal() {
        return this.forceGlobal;
    }

    public void setForceGlobal(boolean set) {
        this.forceGlobal = set;
    }

    public void setNameColor(Color nColor) {
        this.nameDrawingAttributes.setLinePaint(nColor);
    }

    public Color getNameColor() {
        return (Color)this.nameDrawingAttributes.getLinePaint();
    }

    public void setLocationColor(Color lColor) {
        this.locationDrawingAttributes.setLinePaint(lColor);
    }

    public Color getLocationColor() {
        return (Color)this.locationDrawingAttributes.getLinePaint();
    }

    public Component getGUI() {
        JPanel jp = new JPanel();
        jp.add(new JLabel("No Palette"));
        return jp;
    }

    public void removed(Container cont) {
    }

    public void setProperties(Properties props) {
        this.setProperties(null, props);
    }

    public void setProperties(String prefix, Properties properties) {
        this.propertyPrefix = prefix;
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.showLocations = PropUtils.booleanFromProperties(properties, prefix + "showLocations", this.showLocations);
        this.showNames = PropUtils.booleanFromProperties(properties, prefix + "showNames", this.showNames);
        this.nameDrawingAttributes.setProperties(prefix + "name", properties);
        this.locationDrawingAttributes.setProperties(prefix + "location", properties);
        this.setLocationColor((Color)PropUtils.parseColorFromProperties(properties, prefix + "locationColor", this.getLocationColor()));
        this.setNameColor((Color)PropUtils.parseColorFromProperties(properties, prefix + "nameColor", this.getNameColor()));
        this.forceGlobal = PropUtils.booleanFromProperties(properties, prefix + "override", this.forceGlobal);
    }

    public Properties getProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + "showNames", new Boolean(this.showNames).toString());
        props.put(prefix + "showLocations", new Boolean(this.showLocations).toString());
        props.put(prefix + "override", new Boolean(this.forceGlobal).toString());
        this.nameDrawingAttributes.setPropertyPrefix(prefix + "name");
        this.locationDrawingAttributes.setPropertyPrefix(prefix + "location");
        this.nameDrawingAttributes.getProperties(props);
        this.locationDrawingAttributes.getProperties(props);
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        if (list == null) {
            list = new Properties();
        }
        PropUtils.setI18NPropertyInfo(this.i18n, list, class$com$bbn$openmap$layer$location$AbstractLocationHandler == null ? (class$com$bbn$openmap$layer$location$AbstractLocationHandler = AbstractLocationHandler.class$("com.bbn.openmap.layer.location.AbstractLocationHandler")) : class$com$bbn$openmap$layer$location$AbstractLocationHandler, "showNames", "Show names", "Display all the location name labels.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, class$com$bbn$openmap$layer$location$AbstractLocationHandler == null ? (class$com$bbn$openmap$layer$location$AbstractLocationHandler = AbstractLocationHandler.class$("com.bbn.openmap.layer.location.AbstractLocationHandler")) : class$com$bbn$openmap$layer$location$AbstractLocationHandler, "showLocations", "Show locations", "Display all the location markers.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        PropUtils.setI18NPropertyInfo(this.i18n, list, class$com$bbn$openmap$layer$location$AbstractLocationHandler == null ? (class$com$bbn$openmap$layer$location$AbstractLocationHandler = AbstractLocationHandler.class$("com.bbn.openmap.layer.location.AbstractLocationHandler")) : class$com$bbn$openmap$layer$location$AbstractLocationHandler, "override", "Layer Override", "Layer settings override map object settings.", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        this.nameDrawingAttributes.getPropertyInfo(list);
        this.locationDrawingAttributes.getPropertyInfo(list);
        return list;
    }

    public void setPropertyPrefix(String prefix) {
        this.propertyPrefix = prefix;
    }

    public String getPropertyPrefix() {
        return this.propertyPrefix;
    }

    public DrawingAttributes getLocationDrawingAttributes() {
        return this.locationDrawingAttributes;
    }

    public void setLocationDrawingAttributes(DrawingAttributes lda) {
        this.locationDrawingAttributes = lda;
    }

    public DrawingAttributes getNameDrawingAttributes() {
        return this.nameDrawingAttributes;
    }

    public void setNameDrawingAttributes(DrawingAttributes nda) {
        this.nameDrawingAttributes = nda;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

