/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link.draw;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.link.ClientLink;
import com.bbn.openmap.layer.link.LinkActionRequest;
import com.bbn.openmap.layer.link.LinkLayer;
import com.bbn.openmap.layer.link.LinkOMGraphicList;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkUtil;
import com.bbn.openmap.omGraphics.EditableOMGraphic;
import com.bbn.openmap.omGraphics.OMAction;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.tools.drawing.DrawingToolRequestor;
import com.bbn.openmap.tools.drawing.OMDrawingTool;
import com.bbn.openmap.util.Debug;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

public class DrawLinkLayer
extends LinkLayer {
    public static final String LPC_EDITABLE = "editable";
    public static final String LPC_SELECTABLE = "selectable";
    protected OMDrawingTool drawingTool = null;
    protected final DrawingToolRequestor layer = this;
    protected String key = "MapToolDrawing";

    public DrawLinkLayer() {
    }

    public DrawLinkLayer(String host, int port, String propertiesURL) {
        super(host, port, propertiesURL);
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        this.setAddToBeanContext(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mouseClicked(MouseEvent e) {
        int descriptor = 1;
        LinkOMGraphicList graphics = this.getGraphicList();
        if (graphics == null) {
            Debug.message("link", "DrawLinkLayer.mouseClicked: null LinkOMGraphicList, making new one...");
            graphics = new LinkOMGraphicList();
            this.setGraphicList(graphics);
        }
        Debug.message("link", "DrawLinkLayer mouseClicked");
        OMGraphic gesGraphic = null;
        LinkOMGraphicList selectableList = new LinkOMGraphicList();
        Iterator it = graphics.iterator();
        while (it.hasNext()) {
            OMGraphic g = (OMGraphic)it.next();
            Properties p = (Properties)g.getAppObject();
            String selectable = p.getProperty(LPC_SELECTABLE);
            if (!selectable.equals("true")) continue;
            selectableList.add(g);
        }
        gesGraphic = selectableList.findClosest(e.getX(), e.getY(), this.distanceLimit);
        try {
            if (e == null) {
                graphics.deselectAll();
                return false;
            }
            String id = null;
            if (gesGraphic != null) {
                Debug.message("link", "LinkLayer: found gesture graphic");
                boolean tellServer = this.graphicGestureReaction(gesGraphic, descriptor, e);
                if (!tellServer) {
                    this.repaint();
                    return true;
                }
                descriptor = LinkUtil.setMask(descriptor, 512);
                id = ((LinkProperties)gesGraphic.getAppObject()).getProperty("gid");
            } else {
                Debug.message("link", "LinkLayer: gesture graphic NOT FOUND");
                this.fireRequestInfoLine("");
            }
            if (!LinkUtil.isMask(this.getGestureDescriptor(), 2048)) {
                return false;
            }
            LatLonPoint llpoint = this.getProjection().inverse(e.getX(), e.getY());
            ClientLink l = this.linkManager.getLink(false);
            if (l == null) {
                Debug.message("link", "LinkLayer: unable to get link in handleGesture().");
                return false;
            }
            ClientLink clientLink = l;
            synchronized (clientLink) {
                if (id != null) {
                    this.args.setProperty("gid", id);
                } else {
                    this.args.remove("gid");
                }
                LinkActionRequest.write(descriptor, e, llpoint.getLatitude(), llpoint.getLongitude(), this.args, l);
            }
            this.linkManager.finLink();
        }
        catch (IOException ioe) {
            System.err.println("LinkLayer: IOException contacting server during gesture handling!");
            System.err.println(ioe);
            this.linkManager.resetLink();
            return false;
        }
        OMDrawingTool dt = this.getDrawingTool();
        if (dt != null) {
            dt.setMask(32);
            EditableOMGraphic egraphic = dt.getCurrentEditable();
            if (egraphic != null) {
                OMGraphic graphic = egraphic.getGraphic();
                OMAction action = new OMAction(128);
                this.drawingComplete(graphic, action);
                dt.setCurrentEditable(null);
            }
        }
        if (gesGraphic != null && this.drawingTool != null) {
            OMGraphic graphic = null;
            if (dt != null) {
                Properties prop = (Properties)gesGraphic.getAppObject();
                String editable = prop.getProperty(LPC_EDITABLE);
                Debug.message("link", "DrawLinkLayer: editable: " + editable);
                if (editable.equals("false")) {
                    Debug.message("link", "DrawLinkLayer not editing graphic.  editable = false");
                } else {
                    Debug.message("link", "DrawLinkLayer trying to edit graphic");
                    graphic = dt.edit(gesGraphic, this.layer);
                }
            } else {
                Debug.message("link", "Error: DrawLinkLayer has not drawing tool");
            }
            if (graphic != null) {
                Debug.message("link", "DrawLinkLayer editing graphic");
            } else {
                Debug.message("link", "DrawLinkLayer unable to edit graphic");
            }
        }
        return true;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String aKey) {
        this.key = aKey;
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof OMDrawingTool) {
            Debug.message("link", "DrawLinkLayer: found a drawing tool");
            this.setDrawingTool((OMDrawingTool)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof OMDrawingTool && this.getDrawingTool() == (OMDrawingTool)someObj) {
            this.setDrawingTool(null);
        }
    }

    public void setDrawingTool(OMDrawingTool dt) {
        this.drawingTool = dt;
    }

    public OMDrawingTool getDrawingTool() {
        return this.drawingTool;
    }
}

