/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.daynight;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.ProjectionListener;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.daynight.SunPosition;
import com.bbn.openmap.omGraphics.OMCircle;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMRaster;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Timer;

public class DayNightLayer
extends OMGraphicHandlerLayer
implements ProjectionListener,
ActionListener {
    public static final float DEFAULT_TERM_FADE = 0.1f;
    public static final int DO_NOT_UPDATE = -1;
    protected Color daytimeColor = new Color(0xFFFFFF, true);
    protected Color nighttimeColor = new Color(0x7F000000, true);
    protected float termFade = 0.1f;
    protected boolean currentTime = true;
    protected long overlayTime = 0L;
    protected int updateInterval = 300000;
    protected Timer timer;
    protected boolean doPolyTerminator = true;
    protected int terminatorVerts = 360;
    public static final String DaytimeColorProperty = "daytimeColor";
    public static final String NighttimeColorProperty = "nighttimeColor";
    public static final String TermFadeProperty = "termFade";
    public static final String CurrentTimeProperty = "useCurrentTime";
    public static final String OverlayTimeProperty = "overlayTime";
    public static final String UpdateIntervalProperty = "updateInterval";
    public static final String DoPolyTerminatorProperty = "doPolyTerminator";
    public static final String TerminatorVertsProperty = "terminatorVerts";
    static /* synthetic */ Class class$com$bbn$openmap$layer$daynight$DayNightLayer;

    public DayNightLayer() {
        this.setName("Day-Night");
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.overlayTime = PropUtils.longFromProperties(properties, prefix + OverlayTimeProperty, this.overlayTime);
        if (this.overlayTime <= 0L) {
            this.currentTime = true;
        }
        this.currentTime = PropUtils.booleanFromProperties(properties, prefix + CurrentTimeProperty, this.currentTime);
        this.updateInterval = PropUtils.intFromProperties(properties, prefix + UpdateIntervalProperty, this.updateInterval);
        if (this.updateInterval > 0) {
            this.timer = new Timer(this.updateInterval, this);
        }
        this.termFade = PropUtils.floatFromProperties(properties, prefix + TermFadeProperty, this.termFade);
        if (this.termFade < 0.0f || (double)this.termFade >= 0.5) {
            Debug.output("DayNightLayer: termFade funky value ignored.");
            this.termFade = 0.1f;
        }
        this.daytimeColor = (Color)PropUtils.parseColorFromProperties(properties, prefix + DaytimeColorProperty, this.daytimeColor);
        this.nighttimeColor = (Color)PropUtils.parseColorFromProperties(properties, prefix + NighttimeColorProperty, this.nighttimeColor);
        this.doPolyTerminator = PropUtils.booleanFromProperties(properties, prefix + DoPolyTerminatorProperty, this.doPolyTerminator);
        this.terminatorVerts = PropUtils.intFromProperties(properties, prefix + TerminatorVertsProperty, this.terminatorVerts);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + OverlayTimeProperty, Long.toString(this.overlayTime));
        props.put(prefix + CurrentTimeProperty, new Boolean(this.currentTime).toString());
        props.put(prefix + UpdateIntervalProperty, Integer.toString(this.updateInterval));
        props.put(prefix + TermFadeProperty, Float.toString(this.termFade));
        props.put(prefix + DaytimeColorProperty, Integer.toHexString(this.daytimeColor.getRGB()));
        props.put(prefix + NighttimeColorProperty, Integer.toHexString(this.nighttimeColor.getRGB()));
        props.put(prefix + DoPolyTerminatorProperty, new Boolean(this.doPolyTerminator).toString());
        props.put(prefix + TerminatorVertsProperty, Integer.toString(this.terminatorVerts));
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        String interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, OverlayTimeProperty, 3, "The time used to create the layer, in milliseconds from java/unix epoch (leave empty for current time).");
        props.put(OverlayTimeProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, OverlayTimeProperty, OverlayTimeProperty);
        props.put("overlayTime.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, CurrentTimeProperty, 3, "If true, the layer will set the darkness according to the current time.");
        props.put(CurrentTimeProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, CurrentTimeProperty, CurrentTimeProperty);
        props.put("useCurrentTime.label", interString);
        props.put("useCurrentTime.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, UpdateIntervalProperty, 3, "Update interval to automatically update the layer, in milli-seconds.");
        props.put(UpdateIntervalProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, UpdateIntervalProperty, UpdateIntervalProperty);
        props.put("updateInterval.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, TermFadeProperty, 3, "Percentage of the distance from the horizon to the brightest point to start fading to darkness, 0.0 to 0.5.");
        props.put(TermFadeProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, TermFadeProperty, TermFadeProperty);
        props.put("termFade.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, DaytimeColorProperty, 3, "Color for the daytime area, if polygon terminator isn't used.");
        props.put(DaytimeColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, DaytimeColorProperty, DaytimeColorProperty);
        props.put("daytimeColor.label", interString);
        props.put("daytimeColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, NighttimeColorProperty, 3, "Color for the nighttime area.");
        props.put(NighttimeColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, NighttimeColorProperty, NighttimeColorProperty);
        props.put("nighttimeColor.label", interString);
        props.put("nighttimeColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, DoPolyTerminatorProperty, 3, "Render with polygon instead of image (it's faster).");
        props.put(DoPolyTerminatorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, DoPolyTerminatorProperty, DoPolyTerminatorProperty);
        props.put("doPolyTerminator.label", interString);
        props.put("doPolyTerminator.editor", "com.bbn.openmap.util.propertyEditor.YesNoPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, TerminatorVertsProperty, 3, "Number of vertices of the polygon terminator (more is smoother).");
        props.put(TerminatorVertsProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$daynight$DayNightLayer == null ? (class$com$bbn$openmap$layer$daynight$DayNightLayer = DayNightLayer.class$("com.bbn.openmap.layer.daynight.DayNightLayer")) : class$com$bbn$openmap$layer$daynight$DayNightLayer, TerminatorVertsProperty, TerminatorVertsProperty);
        props.put("terminatorVerts.label", interString);
        props.put("initProperties", "useCurrentTime overlayTime updateInterval nighttimeColor doPolyTerminator terminatorVerts daytimeColor termFade removable background");
        return props;
    }

    public void actionPerformed(ActionEvent ae) {
        super.actionPerformed(ae);
        if (Debug.debugging("daynight")) {
            Debug.output(this.getName() + "| updating image via timer...");
        }
        this.doPrepare();
    }

    protected OMGraphic createImage(Projection projection) {
        if (this.currentTime) {
            this.overlayTime = System.currentTimeMillis();
        }
        if (Debug.debugging("daynight")) {
            Debug.output("DayNightLayer: Calculating sun position at time " + Long.toString(this.overlayTime));
        }
        LatLonPoint brightPoint = SunPosition.sunPosition(this.overlayTime);
        Debug.message("daynight", "DayNightLayer: Calculated sun position");
        if (this.doPolyTerminator) {
            Debug.message("daynight", "DayNightLayer:  Creating polygon terminator");
            LatLonPoint darkPoint = GreatCircle.spherical_between(brightPoint.radlat_, brightPoint.radlon_, (float)Math.PI, 0.7853982f);
            OMCircle circle = new OMCircle(darkPoint, projection instanceof Cylindrical ? 90.0f : 89.0f, Length.DECIMAL_DEGREE, this.terminatorVerts);
            circle.setPolarCorrection(true);
            circle.setFillPaint(this.nighttimeColor);
            circle.setLinePaint(this.nighttimeColor);
            circle.generate(projection);
            Debug.message("daynight", "DayNightLayer: Done creating polygon terminator");
            return circle;
        }
        int width = projection.getWidth();
        int height = projection.getHeight();
        int[] pixels = new int[width * height];
        OMRaster ret = new OMRaster(0, 0, width, height, pixels);
        Debug.message("daynight", this.getName() + "|createImage: Center of bright spot lat= " + brightPoint.getLatitude() + ", lon= " + brightPoint.getLongitude());
        int light = this.daytimeColor.getRGB();
        LatLonPoint testPoint = new LatLonPoint(0.0f, 0.0f);
        int dark = this.nighttimeColor.getRGB();
        int darkness = dark >>> 24;
        float upperFadeLimit = (float)(1.5707963705062866 * (1.0 + (double)this.termFade));
        float lowerFadeLimit = (float)(1.5707963705062866 * (1.0 - (double)this.termFade));
        int fadeColorValue = 0xFFFFFF & dark;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                testPoint = projection.inverse(i, j, testPoint);
                float distance = GreatCircle.spherical_distance(brightPoint.radlat_, brightPoint.radlon_, testPoint.radlat_, testPoint.radlon_);
                if (distance > upperFadeLimit) {
                    pixels[j * width + i] = dark;
                    continue;
                }
                if (distance > lowerFadeLimit) {
                    int value = (int)((float)darkness * (1.0f - (upperFadeLimit - distance) / (upperFadeLimit - lowerFadeLimit)));
                    pixels[j * width + i] = fadeColorValue | (value <<= 24);
                    continue;
                }
                pixels[j * width + i] = light;
            }
        }
        ret.generate(projection);
        return ret;
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList list = this.getList();
        if (list == null) {
            list = new OMGraphicList();
        } else {
            list.clear();
        }
        if (this.isCancelled()) {
            Debug.message("daynight", this.getName() + "|DayNightLayer.prepare(): aborted.");
            return null;
        }
        Debug.message("basic", this.getName() + "|DayNightLayer.prepare(): doing it");
        OMGraphic ras = this.createImage(this.getProjection());
        if (this.timer != null) {
            this.timer.restart();
        }
        list.add(ras);
        return list;
    }

    public long getOverlayTime() {
        return this.overlayTime;
    }

    public void setOverlayTime(long ot) {
        this.overlayTime = ot;
        this.currentTime = false;
        this.doPrepare();
    }

    public boolean getCurrentTime() {
        return this.currentTime;
    }

    public void setCurrentTime(boolean ct) {
        this.currentTime = ct;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer t) {
        this.timer = t;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

