/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.io;

import com.bbn.openmap.Environment;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.io.Closable;
import com.bbn.openmap.io.FileInputReader;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.io.InputReader;
import com.bbn.openmap.io.InvalidCharException;
import com.bbn.openmap.io.JarInputReader;
import com.bbn.openmap.io.URLInputReader;
import com.bbn.openmap.util.Debug;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.Vector;

public class BinaryFile {
    private static int openCount = 0;
    private static int classCount = 0;
    private InputReader inputReader = null;
    protected boolean MSBFirst = false;
    private static Vector closableList = new Vector();

    public BinaryFile(File f) throws IOException {
        this.inputReader = new FileInputReader(f);
        ++classCount;
        ++openCount;
    }

    public BinaryFile(String name) throws IOException {
        boolean showDebug = false;
        if (Debug.debugging("binaryfile")) {
            showDebug = true;
        }
        if (showDebug) {
            Debug.output("BinaryFile: trying to figure out how to handle " + name);
        }
        File file = null;
        URL url = null;
        if (!Environment.isApplet()) {
            file = new File(name);
        }
        if (file != null && file.exists()) {
            this.setInputReader(new FileInputReader(file));
        } else {
            url = Thread.currentThread().getContextClassLoader().getResource(name);
            if (url != null) {
                String newname = url.getFile();
                if (showDebug) {
                    Debug.output("BinaryFile: looking for " + newname);
                }
                if (!Environment.isApplet()) {
                    file = new File(newname);
                }
                if (file != null && file.exists()) {
                    this.setInputReader(new FileInputReader(file));
                } else if (!this.setJarInputReader(newname)) {
                    if (showDebug) {
                        Debug.output(" trying as url: " + url);
                    }
                    this.setInputReader(new URLInputReader(url));
                }
            } else if (Environment.isApplet()) {
                URL[] cba;
                URLClassLoader ucl;
                if (showDebug) {
                    Debug.output(" As applet, checking codebase...");
                }
                if ((url = (ucl = URLClassLoader.newInstance(cba = new URL[]{Environment.getApplet().getCodeBase()})).getResource(name)) != null) {
                    this.setInputReader(new URLInputReader(url));
                }
            }
            if (this.inputReader == null) {
                if (showDebug) {
                    Debug.output(" lastly, trying as URL: " + name);
                }
                try {
                    this.setInputReader(new URLInputReader(new URL(name)));
                }
                catch (AccessControlException ace) {
                    Debug.output("BinaryFile: " + name + " couldn't be accessed.");
                    throw new IOException("AccessControlException trying to fetch " + name + " as a URL");
                }
            }
        }
        if (this.inputReader == null) {
            throw new FileNotFoundException("BinaryFile can't find: " + name);
        }
        ++classCount;
        ++openCount;
    }

    protected boolean setJarInputReader(String name) throws IOException {
        block5: {
            try {
                int index = name.indexOf("!");
                if (index != -1) {
                    File f;
                    String jarFileName = name.startsWith("file:") ? name.substring(name.indexOf(":") + 1, index) : name.substring(0, index);
                    String jarEntryName = name.substring(index + 2);
                    if (Debug.debugging("binaryfile")) {
                        Debug.output(" got: \n" + jarFileName + "\n" + jarEntryName);
                    }
                    if (!(f = new File(jarFileName)).exists()) {
                        return false;
                    }
                    this.setInputReader(new JarInputReader(jarFileName, jarEntryName));
                    return true;
                }
            }
            catch (AccessControlException ace) {
                if (!Debug.debugging("binaryfile")) break block5;
                Debug.output("BinaryFile.setJarInputFile: AccessControlException for " + name);
            }
        }
        return false;
    }

    public static boolean exists(String name) {
        boolean exists = false;
        try {
            File file = null;
            URL url = null;
            if (!Environment.isApplet()) {
                file = new File(name);
            }
            if (file != null && file.exists()) {
                exists = true;
            } else {
                url = Thread.currentThread().getContextClassLoader().getResource(name);
                if (url != null) {
                    exists = true;
                } else if (Environment.isApplet()) {
                    URL[] cba;
                    URLClassLoader ucl;
                    if (Debug.debugging("binaryfile")) {
                        Debug.output(" As applet, checking codebase...");
                    }
                    if ((ucl = URLClassLoader.newInstance(cba = new URL[]{Environment.getApplet().getCodeBase()})).getResource(name) != null) {
                        exists = true;
                    }
                }
                if (!exists && name.indexOf("http:") != -1) {
                    try {
                        InputStream stream = new URL(name).openStream();
                        stream.close();
                        exists = true;
                    }
                    catch (AccessControlException ace) {
                        exists = false;
                    }
                }
            }
        }
        catch (IOException ioe) {
            Debug.message("binaryfile", "BinaryFile.exists() caught IOException");
            exists = false;
        }
        if (Debug.debugging("binaryfile")) {
            Debug.output("BinaryFile.exists(" + name + ") = " + exists);
        }
        return exists;
    }

    public String getName() {
        if (this.inputReader != null) {
            return this.inputReader.getName();
        }
        return null;
    }

    public InputReader getInputReader() {
        return this.inputReader;
    }

    public void setInputReader(InputReader reader) {
        if (Debug.debugging("binaryfile")) {
            Debug.output("Setting inputReader");
        }
        this.inputReader = reader;
    }

    public void byteOrder(boolean msbfirst) {
        this.MSBFirst = msbfirst;
    }

    public boolean byteOrder() {
        return this.MSBFirst;
    }

    public long skipBytes(long n) throws IOException {
        return this.inputReader.skipBytes(n);
    }

    public long getFilePointer() throws IOException {
        return this.inputReader.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.inputReader.seek(pos);
    }

    public long length() throws IOException {
        return this.inputReader.length();
    }

    public long available() throws IOException {
        return this.inputReader.available();
    }

    public void close() throws IOException {
        if (this.inputReader != null) {
            this.inputReader.close();
            --openCount;
        }
    }

    public void dispose() throws IOException {
        this.close();
        this.inputReader = null;
    }

    public int read() throws IOException {
        return this.inputReader.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputReader.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.inputReader.read(b);
    }

    public byte[] readBytes(int howmany, boolean allowless) throws EOFException, FormatException {
        return this.inputReader.readBytes(howmany, allowless);
    }

    public char readChar() throws EOFException, FormatException {
        try {
            int retv = this.inputReader.read();
            if (retv == -1) {
                throw new EOFException("Error in ReadChar, EOF reached");
            }
            return (char)retv;
        }
        catch (IOException i) {
            throw new FormatException("readChar IOException: " + i.getMessage());
        }
    }

    public int readUnsigned() throws IOException, EOFException {
        byte b = (byte)this.read();
        if (b == -1) {
            throw new EOFException();
        }
        return MoreMath.signedToInt(b);
    }

    public short readShort() throws EOFException, FormatException {
        return MoreMath.BuildShort(this.readBytes(2, false), this.MSBFirst);
    }

    public short readShortData() throws EOFException, FormatException {
        byte[] bytevec = this.readBytes(2, false);
        if (bytevec[0] < 0) {
            bytevec[0] = (byte)(bytevec[0] & 0x7F);
            return (short)(MoreMath.BuildShort(bytevec, true) * -1);
        }
        return MoreMath.BuildShort(bytevec, true);
    }

    public int readUnsignedShort() throws EOFException, FormatException {
        return MoreMath.signedToInt(this.readShort());
    }

    public int readInteger() throws EOFException, FormatException {
        return MoreMath.BuildInteger(this.readBytes(4, false), this.MSBFirst);
    }

    public void readIntegerArray(int[] vec, int offset, int len) throws EOFException, FormatException {
        for (int i = 0; i < len; ++i) {
            vec[offset++] = this.readInteger();
        }
    }

    public long readLong() throws EOFException, FormatException {
        return MoreMath.BuildLong(this.readBytes(8, false), this.MSBFirst);
    }

    public float readFloat() throws EOFException, FormatException {
        return Float.intBitsToFloat(this.readInteger());
    }

    public void readFloatArray(float[] vec, int offset, int len) throws EOFException, FormatException {
        for (int i = 0; i < len; ++i) {
            vec[offset++] = this.readFloat();
        }
    }

    public double readDouble() throws EOFException, FormatException {
        return Double.longBitsToDouble(this.readLong());
    }

    public String readFixedLengthString(int length) throws EOFException, FormatException {
        byte[] foo = this.readBytes(length, false);
        return new String(foo, 0, length);
    }

    public void assertChar(char expected) throws EOFException, FormatException {
        char c = this.readChar();
        if (c != expected) {
            throw new InvalidCharException("AssertChar: expected " + expected + " got " + c, c);
        }
    }

    public String readToDelimiter(char delim) throws FormatException {
        StringBuffer buildretval;
        block4: {
            buildretval = new StringBuffer();
            try {
                char tmp;
                while ((tmp = this.readChar()) != delim) {
                    buildretval.append(tmp);
                }
            }
            catch (EOFException e) {
            }
            catch (FormatException fe) {
                if (buildretval.length() != 0) break block4;
                throw fe;
            }
        }
        return buildretval.toString();
    }

    public void finalize() throws Throwable {
        this.close();
        --classCount;
    }

    public static synchronized void addClosable(Closable it) {
        closableList.addElement(new WeakReference<Closable>(it));
    }

    public static synchronized void removeClosable(Closable it) {
        for (int i = 0; i < closableList.size(); ++i) {
            Object o = ((WeakReference)closableList.elementAt(i)).get();
            if (o != it && o != null) continue;
            closableList.removeElementAt(i);
            --i;
        }
    }

    public static synchronized void closeClosable() {
        System.out.println("closeClosable " + closableList.size());
        for (int i = 0; i < closableList.size(); ++i) {
            Closable c = (Closable)((WeakReference)closableList.elementAt(i)).get();
            if (c != null && c.close(false)) continue;
            closableList.removeElementAt(i);
            --i;
        }
    }
}

