/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image.wms;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.image.ImageFormatter;
import com.bbn.openmap.image.ImageServer;
import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.image.ImageServerUtils;
import com.bbn.openmap.image.MapRequestFormatException;
import com.bbn.openmap.image.wms.CapabilitiesSupport;
import com.bbn.openmap.image.wms.DefaultFeatureInfoResponse;
import com.bbn.openmap.image.wms.GetFeatureInfoRequestParameters;
import com.bbn.openmap.image.wms.GetMapRequestParameters;
import com.bbn.openmap.image.wms.IWmsLayer;
import com.bbn.openmap.image.wms.LayerFeatureInfoResponse;
import com.bbn.openmap.image.wms.WMSException;
import com.bbn.openmap.image.wms.WmsLayerFactory;
import com.bbn.openmap.layer.util.http.IHttpResponse;
import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.proj.AspectRatioProjection;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.CoordinateReferenceSystem;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Paint;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

public class WmsRequestHandler
extends ImageServer
implements ImageServerConstants {
    private CapabilitiesSupport capabilities;
    private Map wmsLayers;
    private WmsLayerFactory wmsLayerFactory;
    private Map imageFormatterByContentType = new HashMap();

    public WmsRequestHandler(String wmsScheme, String wmsHostName, int wmsPort, String wmsUrlPath, Properties props) throws IOException, WMSException {
        super(props);
        this.setProperties(null, props);
        boolean antialias = PropUtils.booleanFromProperties(props, "openmap.wms.antialiasing", false);
        this.setDoAntiAliasing(antialias);
        this.wmsLayerFactory = new WmsLayerFactory(props);
        this.createWmsLayers();
        Iterator it = this.getFormatters().values().iterator();
        while (it.hasNext()) {
            ImageFormatter formatter = (ImageFormatter)it.next();
            this.imageFormatterByContentType.put(formatter.getContentType(), formatter);
        }
        this.capabilities = new CapabilitiesSupport(props, wmsScheme, wmsHostName, wmsPort, wmsUrlPath);
        ArrayList formatsList = new ArrayList(this.imageFormatterByContentType.keySet());
        this.capabilities.setFormats(1, formatsList);
    }

    protected void createWmsLayers() {
        this.wmsLayers = new HashMap();
        for (int i = 0; i < this.layers.length; ++i) {
            Layer layer = this.layers[i];
            IWmsLayer wmsLayer = this.wmsLayerFactory.createWmsLayer(layer);
            this.wmsLayers.put(wmsLayer.getWmsName(), wmsLayer);
        }
    }

    protected Layer getLayerByName(String layerPropertyPrefix) {
        for (int i = 0; i < this.layers.length; ++i) {
            Layer layer = this.layers[i];
            if (!layerPropertyPrefix.equals(layer.getPropertyPrefix())) continue;
            return layer;
        }
        return null;
    }

    public void handleRequest(Properties requestProperties, IHttpResponse httpResponse) throws IOException, MapRequestFormatException {
        block6: {
            try {
                String requestType = requestProperties.getProperty("REQUEST");
                this.checkRequest(requestProperties);
                if (requestType == null) {
                    throw new WMSException("Missing REQUEST type parameter");
                }
                if (requestType.equalsIgnoreCase("GetMap")) {
                    Debug.message("ms", "OGCMRH: GetMap request...");
                    this.handleGetMapRequest(requestProperties, httpResponse);
                    break block6;
                }
                if (requestType.equals("GetCapabilities")) {
                    Debug.message("ms", "OGCMRH: GetCapabilities request...");
                    this.handleGetCapabilitiesRequest(requestProperties, httpResponse);
                    break block6;
                }
                if (requestType.equalsIgnoreCase("GetFeatureInfo")) {
                    Debug.message("ms", "OGCMRH: GetFeatureInfo request...");
                    this.handleGetFeatureInfoRequest(requestProperties, httpResponse);
                    break block6;
                }
                throw new WMSException("Invalid REQUEST parameter: " + requestType, "OperationNotSupported");
            }
            catch (WMSException e) {
                Debug.output("WMSException(" + e.getCode() + "): " + e.getMessage());
                httpResponse.writeHttpResponse("application/vnd.ogc.se_xml", e.getXML());
            }
        }
    }

    public void handleGetMapRequest(Properties requestProperties, IHttpResponse httpResponse) throws IOException, MapRequestFormatException, WMSException {
        String contentType;
        byte[] image = this.handleGetMapRequest(requestProperties);
        if (Debug.debugging("imageserver")) {
            Debug.output("OGCMRH: have completed image, size " + image.length);
        }
        if ((contentType = this.getFormatter().getContentType()) == null) {
            contentType = "text/plain";
        }
        httpResponse.writeHttpResponse(contentType, image);
    }

    public byte[] handleGetMapRequest(Properties requestProperties) throws IOException, MapRequestFormatException, WMSException {
        GetMapRequestParameters parameters = new GetMapRequestParameters();
        this.checkFormat(requestProperties, parameters);
        this.setFormatter(parameters.formatter);
        this.checkBackground(requestProperties, parameters);
        Paint bgPaint = parameters.background;
        this.checkProjectionType(requestProperties, parameters);
        this.checkBoundingBox(requestProperties, parameters);
        Proj projection = this.createProjection(requestProperties, parameters);
        this.checkLayersAndStyles(requestProperties, parameters);
        Debug.message("ms", "handleGetMapRequest: createImage layers:" + parameters.layerNames.toString());
        return this.createImage((Projection)projection, parameters.width, parameters.height, parameters.layerNames, bgPaint);
    }

    public void handleGetCapabilitiesRequest(Properties requestProperties, IHttpResponse httpResponse) throws IOException, MapRequestFormatException, WMSException {
        String response = this.handleGetCapabilitiesRequest(requestProperties);
        httpResponse.writeHttpResponse("text/xml", response.getBytes("UTF-8"));
    }

    public String handleGetCapabilitiesRequest(Properties requestProperties) throws IOException, MapRequestFormatException, WMSException {
        String format = requestProperties.getProperty("FORMAT");
        if (format != null && !format.equals("application/vnd.ogc.wms_xml")) {
            throw new WMSException("Invalid FORMAT parameter.", "InvalidFormat");
        }
        Layer[] layers = this.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i].getPropertyPrefix() == null) continue;
            this.capabilities.addLayer(this.wmsLayerFactory.createWmsLayer(layers[i]));
        }
        try {
            return this.capabilities.generateXMLString();
        }
        catch (Exception e) {
            throw new WMSException("Unable to compile a response due to server misconfiguration.", "InternalError");
        }
    }

    public void handleGetFeatureInfoRequest(Properties requestProperties, IHttpResponse httpResponse) throws IOException, MapRequestFormatException, WMSException {
        String contentType = requestProperties.getProperty("INFO_FORMAT");
        String content = this.handleGetFeatureInfoRequest(requestProperties);
        byte[] contentBytes = content.getBytes("UTF-8");
        httpResponse.writeHttpResponse(contentType, contentBytes);
    }

    public String handleGetFeatureInfoRequest(Properties requestProperties) throws IOException, MapRequestFormatException, WMSException {
        GetFeatureInfoRequestParameters parameters = new GetFeatureInfoRequestParameters();
        this.checkFormat(requestProperties, parameters);
        this.setFormatter(parameters.formatter);
        this.checkBackground(requestProperties, parameters);
        this.checkProjectionType(requestProperties, parameters);
        this.checkBoundingBox(requestProperties, parameters);
        this.checkFeatureInfoPoint(requestProperties, parameters);
        this.checkLayersAndStyles(requestProperties, parameters);
        this.checkQueryLayers(requestProperties, parameters);
        this.checkInfoFormat(requestProperties, parameters);
        Proj projection = this.createProjection(requestProperties, parameters);
        DefaultFeatureInfoResponse featureInfoResponse = null;
        if (featureInfoResponse == null) {
            featureInfoResponse = new DefaultFeatureInfoResponse();
        }
        Iterator it = parameters.queryLayerNames.iterator();
        while (it.hasNext()) {
            String queryLayerName = (String)it.next();
            IWmsLayer wmslayer = (IWmsLayer)this.wmsLayers.get(queryLayerName);
            Layer layer = this.getLayerByName(queryLayerName);
            layer.setProjection(new ProjectionEvent(this, projection));
            LayerFeatureInfoResponse layerResponse = wmslayer.query(parameters.x, parameters.y);
            featureInfoResponse.add(layerResponse);
        }
        StringBuffer out = new StringBuffer();
        featureInfoResponse.output(parameters.infoFormat, out);
        return out.toString();
    }

    public void updateLayers() {
    }

    protected byte[] getFormattedImage(ImageFormatter formatter, int scaledWidth, int scaledHeight) {
        Debug.message("imageserver", "ImageServer: using full scale image (unscaled).");
        byte[] formattedImage = formatter.getImageBytes();
        return formattedImage;
    }

    private void checkRequest(Properties requestProperties) throws WMSException {
        boolean getcaps;
        String version = requestProperties.getProperty("VERSION");
        String service = requestProperties.getProperty("SERVICE");
        String requestType = requestProperties.getProperty("REQUEST");
        boolean bl = getcaps = requestType != null && requestType.equals("GetCapabilities");
        if (!getcaps) {
            if (version == null) {
                version = "1.1.1";
                Debug.message("wms", "missing version string. use " + version);
            }
            if (!version.equals("1.1.1")) {
                throw new WMSException("Unsupported protocol version: " + version);
            }
            String ex = requestProperties.getProperty("EXCEPTIONS");
            if (ex != null && !ex.equals("application/vnd.ogc.se_inimage") && !ex.equals("application/vnd.ogc.se_xml")) {
                throw new WMSException("Invalid EXCEPTIONS value: " + ex);
            }
        } else if (service == null || !service.equals("WMS")) {
            throw new WMSException("Unsupported service name: " + service);
        }
    }

    private void checkProjectionType(Properties requestProperties, GetMapRequestParameters parameters) throws WMSException {
        String strSRS = requestProperties.getProperty("SRS");
        if (strSRS == null) {
            strSRS = requestProperties.getProperty("CRS");
        }
        if (strSRS == null) {
            throw new WMSException("Missing SRS parameter.");
        }
        System.out.println("crs: " + strSRS);
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.getForCode(strSRS);
        if (crs == null) {
            throw new WMSException("Invalid SRS/CRS parameter: " + strSRS, "InvalidSRS");
        }
        parameters.crs = crs;
    }

    private void checkBoundingBox(Properties requestProperties, GetMapRequestParameters parameters) throws WMSException {
        String strWidth = requestProperties.getProperty("WIDTH");
        if (strWidth == null) {
            throw new WMSException("Missing WIDTH parameter.", "MissingDimensionValue");
        }
        String strHeight = requestProperties.getProperty("HEIGHT");
        if (strHeight == null) {
            throw new WMSException("Missing HEIGHT parameter.", "MissingDimensionValue");
        }
        String strBBox = requestProperties.getProperty("BBOX");
        if (strBBox == null) {
            throw new WMSException("Missing BBOX parameter.", "MissingDimensionValue");
        }
        String[] arrayBBox = strBBox.split(",");
        if (arrayBBox.length != 4) {
            throw new WMSException("Invalid BBOX parameter. BBOX must contain exactly 4 values separated with comas.", "InvalidDimensionValue");
        }
        try {
            double minX = Double.parseDouble(arrayBBox[0]);
            double minY = Double.parseDouble(arrayBBox[1]);
            double maxX = Double.parseDouble(arrayBBox[2]);
            double maxY = Double.parseDouble(arrayBBox[3]);
            double medX = (maxX - minX) / 2.0 + minX;
            double medY = (maxY - minY) / 2.0 + minY;
            CoordinateReferenceSystem crs = parameters.crs;
            parameters.bboxLatLonMinXY = crs.inverse(minX, minY);
            parameters.bboxLatLonMaxXY = crs.inverse(maxX, maxY);
            parameters.bboxLatLonCenter = crs.inverse(medX, medY);
        }
        catch (NumberFormatException e) {
            throw new WMSException("Invalid BBOX parameter. BBOX parameter must be in the form of minx, miny, maxx, maxy confirming to the selected SRS/CRS.", "InvalidDimensionValue");
        }
        parameters.width = 0;
        try {
            parameters.width = Integer.parseInt(strWidth);
            if (parameters.width <= 0) {
                throw new WMSException("Invalid values encountered while parsing WIDTH parameter.");
            }
        }
        catch (NumberFormatException e) {
            throw new WMSException("Invalid values encountered while parsing WIDTH parameter.");
        }
        parameters.height = 0;
        try {
            parameters.height = Integer.parseInt(strHeight);
            if (parameters.height <= 0) {
                throw new WMSException("Invalid value encountered while parsing HEIGHT parameter.");
            }
        }
        catch (NumberFormatException e) {
            throw new WMSException("Invalid value encountered while parsing HEIGHT parameter.");
        }
    }

    private void checkLayersAndStyles(Properties requestProperties, GetMapRequestParameters parameters) throws WMSException {
        String strLayers = requestProperties.getProperty("LAYERS");
        if (strLayers == null) {
            throw new WMSException("LAYERS not specified.", "LayerNotDefined");
        }
        if (Debug.debugging("imageserver")) {
            Debug.output("OGCMRH.checkLayersAndStyles: requested layers >> " + strLayers);
        }
        String[] layers_in = strLayers.replace('\"', '\u0000').split(",", -1);
        String strStyles = requestProperties.getProperty("STYLES");
        String[] styles_in = null;
        if (strStyles != null && (styles_in = strStyles.replace('\"', '\u0000').split(",", -1)).length != layers_in.length) {
            throw new WMSException("Number of specified styles does not match the number of specified layers.");
        }
        parameters.layerNames.clear();
        for (int i = layers_in.length - 1; i >= 0; --i) {
            String layerName = layers_in[i];
            IWmsLayer wmsLayer = (IWmsLayer)this.wmsLayers.get(layerName);
            if (wmsLayer == null) {
                throw new WMSException("Unknown layer specified (" + layerName + ").", "LayerNotDefined");
            }
            if (styles_in == null) {
                wmsLayer.setDefaultStyle();
            } else {
                String styleName = styles_in[i];
                if (styleName.equals("")) {
                    wmsLayer.setDefaultStyle();
                } else if (wmsLayer.isStyleSupported(styleName)) {
                    wmsLayer.setStyle(styleName);
                } else {
                    throw new WMSException("Unknown style specified (" + styleName + ").", "StyleNotDefined");
                }
            }
            parameters.layerNames.add(layerName);
        }
        if (parameters.layerNames.isEmpty()) {
            throw new WMSException("LAYERS not specified.", "LayerNotDefined");
        }
    }

    private void checkQueryLayers(Properties requestProperties, GetFeatureInfoRequestParameters parameters) throws WMSException {
        String strLayers = requestProperties.getProperty("QUERY_LAYERS");
        if (strLayers == null) {
            throw new WMSException("QUERY_LAYERS not specified.", "LayerNotDefined");
        }
        if (Debug.debugging("imageserver")) {
            Debug.output("OGCMRH.checkQueryLayers: requested layers >> " + strLayers);
        }
        String[] layers_in = strLayers.replace('\"', '\u0000').split(",", -1);
        parameters.queryLayerNames.clear();
        for (int i = 0; i < layers_in.length; ++i) {
            String layerName = layers_in[i];
            if (!parameters.layerNames.contains(layerName)) {
                throw new WMSException("Layers missing Query Layer " + layerName + ".", "LayerNotDefined");
            }
            IWmsLayer layer = (IWmsLayer)this.wmsLayers.get(layerName);
            if (layer == null) {
                throw new WMSException("Could not find layer " + layerName);
            }
            if (!layer.isQueryable()) {
                throw new WMSException("Layer " + layerName + " is not queryable");
            }
            parameters.queryLayerNames.add(layerName);
        }
    }

    private Proj createProjection(Properties requestProperties, GetMapRequestParameters parameters) throws WMSException {
        Properties projProps = new Properties();
        projProps.put("CENTER", new LatLonPoint(0.0f, 0.0f));
        projProps.setProperty("WIDTH", Integer.toString(parameters.width));
        projProps.setProperty("HEIGHT", Integer.toString(parameters.height));
        Proj projection = parameters.crs.createProjection(projProps);
        parameters.crs.prepareProjection(projection);
        projection.setScale(projection.getMinScale());
        LatLonPoint llp1 = parameters.bboxLatLonMinXY;
        LatLonPoint llp2 = parameters.bboxLatLonMaxXY;
        System.out.println("bbox toLatLon: 1: " + llp1 + ", 2: " + llp2 + ", center: " + parameters.bboxLatLonCenter);
        projection.setCenter(parameters.bboxLatLonCenter);
        int intnewwidth = parameters.width;
        int intnewheight = parameters.height;
        float newscale = projection.getScale(llp1, llp2, new Point(0, 0), new Point(intnewwidth, intnewheight));
        projection.setScale(newscale);
        Point xyp1 = projection.forward(llp1);
        Point xyp2 = projection.forward(llp2);
        int w = xyp2.x - xyp1.x;
        int h = xyp1.y - xyp2.y;
        if (Math.abs(w - parameters.width) > 2 || Math.abs(h - parameters.height) > 2) {
            Debug.output("use aspect ratio fix");
            projection.setWidth(w);
            projection.setHeight(h);
            projection.setCenter(parameters.bboxLatLonCenter);
            float underlyingScale = projection.getScale(llp1, llp2, new Point(0, 0), new Point(w, h));
            projection.setScale(underlyingScale);
            AspectRatioProjection p = new AspectRatioProjection(projection, parameters.width, parameters.height);
            projection = p;
        }
        return projection;
    }

    private void checkFormat(Properties requestProperties, GetMapRequestParameters parameters) throws WMSException {
        String format = requestProperties.getProperty("FORMAT");
        if (format == null && parameters instanceof GetFeatureInfoRequestParameters) {
            parameters.formatter = (ImageFormatter)this.getFormatters().values().iterator().next();
            format = parameters.formatter.getContentType();
        }
        if (format == null) {
            throw new WMSException("Missing FORMAT parameter.", "InvalidFormat");
        }
        parameters.formatter = (ImageFormatter)this.imageFormatterByContentType.get(format);
        if (parameters.formatter == null) {
            throw new WMSException("Invalid FORMAT parameter: " + format, "InvalidFormat");
        }
    }

    private void checkFeatureInfoPoint(Properties requestProperties, GetFeatureInfoRequestParameters parameters) throws WMSException {
        parameters.x = -1;
        parameters.y = -1;
        try {
            parameters.x = Integer.parseInt(requestProperties.getProperty("X"));
        }
        catch (NumberFormatException e) {
            throw new WMSException("Invalid X parameter: " + requestProperties.getProperty("X"), "InvalidPoint");
        }
        try {
            parameters.y = Integer.parseInt(requestProperties.getProperty("Y"));
        }
        catch (NumberFormatException e) {
            throw new WMSException("Invalid Y parameter: " + requestProperties.getProperty("Y"), "InvalidPoint");
        }
    }

    private void checkInfoFormat(Properties requestProperties, GetFeatureInfoRequestParameters parameters) throws WMSException {
        String format;
        List<String> okFormats = Arrays.asList("text/plain", "text/html");
        if (!okFormats.contains(format = requestProperties.getProperty("INFO_FORMAT"))) {
            throw new WMSException("Invalid value for INFO_FORMAT: " + requestProperties.getProperty("INFO_FORMAT"));
        }
        parameters.infoFormat = format;
    }

    private void checkBackground(Properties requestProperties, GetMapRequestParameters parameters) throws WMSException {
        String test = requestProperties.getProperty("TRANSPARENT");
        if (test != null && test.equals("0") && test.equals("1") && test.equalsIgnoreCase("TRUE") && test.equalsIgnoreCase("FALSE")) {
            throw new WMSException("Invalid TRANSPARENT format. Please specify a boolean value (0,1,FALSE,TRUE)");
        }
        test = requestProperties.getProperty("BGCOLOR");
        if (test != null && !Pattern.matches("0x[0-9a-fA-F]{6}", test)) {
            throw new WMSException("Invalid BGCOLOR format. Please specify an hexadecimal number in the form 0xXXXXXX, where X is a hexadecimal digit (0..9,A-F)");
        }
        parameters.background = ImageServerUtils.getBackground(requestProperties, OMColor.clear);
    }
}

