/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image.wms;

import com.bbn.openmap.util.Debug;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WMSException
extends Exception {
    public static final String INVALIDFORMAT = "InvalidFormat";
    public static final String INVALIDSRS = "InvalidSRS";
    public static final String LAYERNOTDEFINED = "LayerNotDefined";
    public static final String STYLENOTDEFINED = "StyleNotDefined";
    public static final String LAYERNOTQUERYABLE = "LayerNotQueryable";
    public static final String INVALIDPOINT = "InvalidPoint";
    public static final String CURRENTUPDATESEQUENCE = "CurrentUpdateSequence";
    public static final String INVALIDUPDATESEQUENCE = "InvalidUpdateSequence";
    public static final String MISSINGDIMENSIONVALUE = "MissingDimensionValue";
    public static final String INVALIDDIMENSIONVALUE = "InvalidDimensionValue";
    public static final String OPERATIONNOTSUPPORTED = "OperationNotSupported";
    public static final String INTERNALERROR = "InternalError";
    protected static String exceptionTemplate = "<?xml version='1.0' encoding=\"UTF-8\"?><ServiceExceptionReport version=\"1.1.0\"></ServiceExceptionReport>";
    private String XML;
    private String Message;
    private String Code;

    public WMSException() {
        this("All your base are belong to us.", (String)null);
    }

    public WMSException(String message) {
        this(message, (String)null);
    }

    public WMSException(String message, String code) {
        this.Message = message;
        this.Code = code;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement("ServiceExceptionReport");
            root.setAttribute("version", "1.1.0");
            Element ex = doc.createElement("ServiceException");
            ex.appendChild(doc.createTextNode(this.Message));
            if (this.Code != null) {
                ex.setAttribute("code", this.Code);
            }
            root.appendChild(ex);
            doc.appendChild(root);
            StringWriter strWriter = new StringWriter();
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            tr.setOutputProperty("version", "1.0");
            tr.setOutputProperty("encoding", "UTF-8");
            tr.transform(new DOMSource(doc), new StreamResult(strWriter));
            this.XML = strWriter.toString();
            strWriter.close();
        }
        catch (Exception ex) {
            Debug.output("WMSException Internal Error !\n[");
            ex.printStackTrace();
            Debug.output("]");
            this.XML = INTERNALERROR;
        }
    }

    public String getXML() {
        return this.XML;
    }

    public String getMessage() {
        return this.Message;
    }

    public String getCode() {
        return this.Code;
    }
}

