/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.image.wms;

import com.bbn.openmap.image.ImageServerConstants;
import com.bbn.openmap.image.wms.IWmsLayer;
import com.bbn.openmap.image.wms.IWmsLayerStyle;
import com.bbn.openmap.image.wms.WMSException;
import com.bbn.openmap.proj.coords.CoordinateReferenceSystem;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class CapabilitiesSupport
implements ImageServerConstants {
    public static final String WMSPrefix = "openmap.wms.";
    public static final int FMT_GETCAPS = 0;
    public static final int FMT_GETMAP = 1;
    public static final int FMT_GETFEATUREINFO = 2;
    public static final int FMT_EXCEPTIONS = 3;
    public static final int FMT_MAIN = 3;
    private List[] formatsList = new List[]{null, null, null, null};
    private String[] onlineResourcesList = new String[]{null, null, null, null};
    private List keywordsList = null;
    private String wmsTitle = null;
    private String wmsAbstract = null;
    private int updateSequence = 1;
    private List wmslayers = new ArrayList();
    private String layersTitle;
    private Collection projections = CoordinateReferenceSystem.getCodes();

    public CapabilitiesSupport(Properties props, String scheme, String hostName, int port, String path) throws WMSException {
        this.wmsTitle = props.getProperty("openmap.wms.Title", "Sample Title");
        this.wmsAbstract = props.getProperty("openmap.wms.Abstract", "Sample Abstract");
        this.layersTitle = props.getProperty("openmap.wms.LayersTitle", "Sample Layer List");
        String[] strKeywords = props.getProperty("openmap.wms.Keyword", "").split(" ");
        List<String> keywords = Arrays.asList(strKeywords);
        this.setKeywords(keywords);
        String url = scheme + "://" + hostName + ":" + port + path;
        this.setOnlineResource(3, url);
        this.setOnlineResource(1, url);
        this.setOnlineResource(0, url);
        this.setOnlineResource(2, url);
        ArrayList<String> al = new ArrayList<String>();
        al.add("application/vnd.ogc.wms_xml");
        this.setFormats(0, al);
        al.clear();
        al.add("text/plain");
        al.add("text/html");
        this.setFormats(2, al);
        al.clear();
        al.add("application/vnd.ogc.se_xml");
        this.setFormats(3, al);
    }

    private Document generateCapabilitiesDocument() {
        Document doc;
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            DOMImplementation impl = builder.getDOMImplementation();
            DocumentType doctype = impl.createDocumentType("wms", "WMT_MS_Capabilities", "http://schemas.opengis.net/wms/1.1.1/WMS_MS_Capabilities.dtd");
            doc = impl.createDocument(null, "WMT_MS_Capabilities", doctype);
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Cannot create new Xml Document:" + ex.getMessage());
        }
        Element root = doc.getDocumentElement();
        root.setAttribute("version", "1.1.1");
        root.setAttribute("updateSequence", Integer.toString(this.updateSequence));
        Element service = doc.createElement("Service");
        service.appendChild(this.textnode(doc, "Name", "OGC:WMS"));
        service.appendChild(this.textnode(doc, "Title", this.wmsTitle));
        service.appendChild(this.textnode(doc, "Abstract", this.wmsAbstract));
        if (!this.keywordsList.isEmpty()) {
            Element keywordListElement = doc.createElement("KeywordList");
            for (int i = 0; i < this.keywordsList.size(); ++i) {
                keywordListElement.appendChild(this.textnode(doc, "Keyword", (String)this.keywordsList.get(i)));
            }
            service.appendChild(keywordListElement);
        }
        Element onlineResource = doc.createElement("OnlineResource");
        onlineResource.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        onlineResource.setAttribute("xlink:type", "simple");
        onlineResource.setAttribute("xlink:href", this.onlineResourcesList[3]);
        service.appendChild(onlineResource);
        service.appendChild(this.textnode(doc, "Fees", "none"));
        service.appendChild(this.textnode(doc, "AccessConstraints", "none"));
        root.appendChild(service);
        Element capability = doc.createElement("Capability");
        Element request = doc.createElement("Request");
        request.appendChild(this.requestcap(doc, "GetCapabilities", this.formatsList[0], "Get", this.onlineResourcesList[0]));
        request.appendChild(this.requestcap(doc, "GetMap", this.formatsList[1], "Get", this.onlineResourcesList[1]));
        request.appendChild(this.requestcap(doc, "GetFeatureInfo", this.formatsList[2], "Get", this.onlineResourcesList[2]));
        capability.appendChild(request);
        Element exceptionElement = doc.createElement("Exception");
        for (int i = 0; i < this.formatsList[3].size(); ++i) {
            exceptionElement.appendChild(this.textnode(doc, "Format", (String)this.formatsList[3].get(i)));
        }
        capability.appendChild(exceptionElement);
        capability.appendChild(this.createLayersElement(doc));
        root.appendChild(capability);
        return doc;
    }

    private Element createLayersElement(Document doc) {
        Element layers = doc.createElement("Layer");
        layers.appendChild(this.textnode(doc, "Title", this.layersTitle));
        Iterator it = this.projections.iterator();
        while (it.hasNext()) {
            layers.appendChild(this.textnode(doc, "SRS", (String)it.next()));
        }
        this.setBoundingBox(doc, layers, "-180", "-90", "180", "90");
        it = this.wmslayers.iterator();
        while (it.hasNext()) {
            IWmsLayer wmsLayer = (IWmsLayer)it.next();
            this.createLayerElement(doc, layers, wmsLayer);
        }
        return layers;
    }

    private void createLayerElement(Document doc, Element layers, IWmsLayer wmsLayer) {
        Element layerElement = (Element)this.node(doc, "Layer");
        layerElement.setAttribute("queryable", wmsLayer.isQueryable() ? "1" : "0");
        layerElement.setAttribute("opaque", wmsLayer.isOpaque() ? "1" : "0");
        layerElement.setAttribute("cascaded", wmsLayer.isCascaded() ? "1" : "0");
        layerElement.setAttribute("noSubsets", wmsLayer.isNoSubsets() ? "1" : "0");
        layerElement.setAttribute("fixedWidth", Integer.toString(wmsLayer.getFixedWidth()));
        layerElement.setAttribute("fixedHeight", Integer.toString(wmsLayer.getFixedHeight()));
        layerElement.appendChild(this.textnode(doc, "Name", wmsLayer.getWmsName()));
        layerElement.appendChild(this.textnode(doc, "Title", wmsLayer.getTitle()));
        layerElement.appendChild(this.textnode(doc, "Abstract", wmsLayer.getAbstract()));
        IWmsLayerStyle[] styles = wmsLayer.getStyles();
        for (int i = 0; i < styles.length; ++i) {
            IWmsLayerStyle style = styles[i];
            Element styleElement = (Element)this.node(doc, "Style");
            styleElement.appendChild(this.textnode(doc, "Name", style.getName()));
            styleElement.appendChild(this.textnode(doc, "Title", style.getTitle()));
            if (style.getAbstract() != null) {
                styleElement.appendChild(this.textnode(doc, "Abstract", style.getAbstract()));
            }
            layerElement.appendChild(styleElement);
        }
        layers.appendChild(layerElement);
    }

    public void incUpdateSequence() {
        ++this.updateSequence;
    }

    public boolean setFormats(int request, List formats) {
        switch (request) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.formatsList[request] = new ArrayList(formats);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setOnlineResource(int which, String url) {
        switch (which) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.onlineResourcesList[which] = url;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void setKeywords(List keywordsList) {
        this.keywordsList = keywordsList;
    }

    public void addLayer(IWmsLayer wmsLayer) {
        this.wmslayers.add(wmsLayer);
    }

    public void setLayersTitle(String title) {
        this.layersTitle = title;
    }

    private void setBoundingBox(Document doc, Element layers, String minx, String miny, String maxx, String maxy) {
        Element e1 = (Element)this.node(doc, "LatLonBoundingBox");
        e1.setAttribute("minx", minx);
        e1.setAttribute("miny", miny);
        e1.setAttribute("maxx", maxx);
        e1.setAttribute("maxy", maxy);
        layers.appendChild(e1);
    }

    public String generateXMLString() throws IOException, TransformerConfigurationException, TransformerException {
        StringWriter strWriter = new StringWriter();
        Transformer tr = TransformerFactory.newInstance().newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        tr.setOutputProperty("version", "1.0");
        tr.setOutputProperty("encoding", "UTF-8");
        Document document = this.generateCapabilitiesDocument();
        tr.setOutputProperty("doctype-system", document.getDoctype().getSystemId());
        tr.transform(new DOMSource(document), new StreamResult(strWriter));
        return strWriter.toString();
    }

    private Node textnode(Document doc, String Name2, String Text2) {
        Element e1 = doc.createElement(Name2);
        Text n = doc.createTextNode(Text2);
        e1.appendChild(n);
        return e1;
    }

    private Node node(Document doc, String Name2) {
        return doc.createElement(Name2);
    }

    private Node requestcap(Document doc, String requestName, List formatList, String methodName, String url) {
        Element onlineResourceElement = doc.createElement("OnlineResource");
        onlineResourceElement.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        onlineResourceElement.setAttribute("xlink:type", "simple");
        onlineResourceElement.setAttribute("xlink:href", url);
        Element methodNode = doc.createElement(methodName);
        methodNode.appendChild(onlineResourceElement);
        Element httpNode = doc.createElement("HTTP");
        httpNode.appendChild(methodNode);
        Element dcpTypeNode = doc.createElement("DCPType");
        dcpTypeNode.appendChild(httpNode);
        Element requestNameNode = doc.createElement(requestName);
        for (int i = 0; i < formatList.size(); ++i) {
            requestNameNode.appendChild(this.textnode(doc, "Format", (String)formatList.get(i)));
        }
        requestNameNode.appendChild(dcpTypeNode);
        return requestNameNode;
    }
}

