/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.gui.MenuBar;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class MenuList
extends OMComponent {
    public static final String MenusProperty = "menus";
    public static final String MenuNameProperty = "name";
    protected LinkedList menus = new LinkedList();
    protected MenuBar menuBar;
    protected JMenu menu;
    protected String name = "Map";
    static /* synthetic */ Class class$com$bbn$openmap$gui$menu$MenuList;

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new MenuBar();
        }
        this.menuBar.removeAll();
        Iterator iterator = this.menus.iterator();
        while (iterator.hasNext()) {
            this.menuBar.findAndInit(iterator.next());
        }
        return this.menuBar;
    }

    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = new JMenu(this.name);
        }
        this.menu.removeAll();
        Iterator iterator = this.menus.iterator();
        while (iterator.hasNext()) {
            this.menu.add((JMenu)iterator.next());
        }
        return this.menu;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.name = props.getProperty(prefix + MenuNameProperty, this.name);
        Vector menuItems = PropUtils.parseSpacedMarkers(props.getProperty(realPrefix + MenusProperty));
        if (!menuItems.isEmpty()) {
            int nMenuItems = menuItems.size();
            if (Debug.debugging("menu")) {
                Debug.output("MenuList created with " + nMenuItems + " menus" + (nMenuItems == 1 ? "" : "s") + " in properties");
            }
            for (int i = 0; i < nMenuItems; ++i) {
                String itemPrefix = (String)menuItems.elementAt(i);
                String classProperty = itemPrefix + ".class";
                String className = props.getProperty(classProperty);
                if (className == null) {
                    Debug.error("MenuList.setProperties(): Failed to locate property \"" + classProperty + "\"\n  Skipping menu \"" + itemPrefix + "\"");
                    continue;
                }
                Object obj = ComponentFactory.create(className, itemPrefix, props);
                if (!(obj instanceof JMenu)) continue;
                this.menus.add(obj);
            }
        } else if (Debug.debugging("menu")) {
            Debug.output("MenuList created without menus in properties");
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        StringBuffer itemList = new StringBuffer();
        Iterator iterator = this.menus.iterator();
        while (iterator.hasNext()) {
            JMenu menu = (JMenu)iterator.next();
            if (!(menu instanceof PropertyConsumer)) continue;
            PropertyConsumer ps = (PropertyConsumer)((Object)menu);
            String prefix = ps.getPropertyPrefix();
            if (prefix == null) {
                prefix = menu.getText().toLowerCase();
                ps.setPropertyPrefix(prefix);
            }
            itemList.append(prefix + " ");
            ps.getProperties(props);
        }
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + MenusProperty, itemList.toString());
        props.put(prefix + MenuNameProperty, this.name);
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        PropUtils.setI18NPropertyInfo(this.i18n, props, class$com$bbn$openmap$gui$menu$MenuList == null ? (class$com$bbn$openmap$gui$menu$MenuList = MenuList.class$("com.bbn.openmap.gui.menu.MenuList")) : class$com$bbn$openmap$gui$menu$MenuList, MenusProperty, "List of Menus", "List of marker names for menu component properties.", null);
        PropUtils.setI18NPropertyInfo(this.i18n, props, class$com$bbn$openmap$gui$menu$MenuList == null ? (class$com$bbn$openmap$gui$menu$MenuList = MenuList.class$("com.bbn.openmap.gui.menu.MenuList")) : class$com$bbn$openmap$gui$menu$MenuList, MenuNameProperty, "Name", "Name of the Menu provided by the MenuList.", null);
        return props;
    }

    public void setBeanContext(BeanContext bc) throws PropertyVetoException {
        super.setBeanContext(bc);
        Iterator it = this.menus.iterator();
        while (bc != null && it.hasNext()) {
            bc.add(it.next());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

