/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.Environment;
import com.bbn.openmap.MapBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AboutMenuItem
extends JMenuItem
implements ActionListener {
    protected JDialog aboutBox = null;

    public AboutMenuItem() {
        super("About");
        this.setMnemonic('t');
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.aboutBox == null) {
            this.aboutBox = this.createAboutBox();
            this.aboutBox.getContentPane().setLayout(new BorderLayout());
            this.aboutBox.getContentPane().add((Component)this.createCopyrightViewer(), "Center");
            this.aboutBox.getContentPane().add(this.createAboutControls(this.aboutBox), "South");
            this.aboutBox.pack();
        }
        this.aboutBox.setVisible(true);
    }

    protected JComponent createCopyrightViewer() {
        StringBuffer sb = new StringBuffer(MapBean.getCopyrightMessage() + Environment.get("line.separator") + Environment.get("line.separator") + "Version " + Environment.get("openmap.Version"));
        String buildDate = Environment.get("openmap.BuildDate");
        if (buildDate != null) {
            sb.append(Environment.get("line.separator") + "Build " + buildDate);
        }
        JTextArea viewer = new JTextArea(sb.toString());
        viewer.setEditable(false);
        JScrollPane scroller = new JScrollPane(viewer);
        return scroller;
    }

    protected Component createAboutControls(final JDialog window) {
        JButton button = new JButton("OK");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                window.setVisible(false);
            }
        });
        Box box = Box.createHorizontalBox();
        box.add(button);
        return box;
    }

    protected JDialog createAboutBox() {
        Container topContainer = this.getTopLevelAncestor();
        String title = "About " + Environment.get("openmap.Title");
        if (topContainer instanceof Frame) {
            return new JDialog((Frame)topContainer, title, true);
        }
        JDialog d = new JDialog();
        d.setTitle(title);
        return d;
    }
}

