/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.Environment;
import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;

public class WindowSupport
extends ListenerSupport
implements ComponentListener,
ActionListener {
    protected Component content;
    protected String title;
    protected Point componentLocation;
    protected Dimension componentSize;
    public static final String DisplayWindowCmd = "displayWindowCmd";
    public static final String KillWindowCmd = "killWindowCmd";
    protected transient WSDisplay display;
    protected static Class defaultWindowSupportDisplayType = class$com$bbn$openmap$gui$WindowSupport$Frm == null ? (class$com$bbn$openmap$gui$WindowSupport$Frm = WindowSupport.class$("com.bbn.openmap.gui.WindowSupport$Frm")) : class$com$bbn$openmap$gui$WindowSupport$Frm;
    protected int maxHeight = -1;
    protected int maxWidth = -1;
    protected Class persistentDisplayType;
    static /* synthetic */ Class class$com$bbn$openmap$gui$WindowSupport$Frm;
    static /* synthetic */ Class class$com$bbn$openmap$gui$WindowSupport$Dlg;
    static /* synthetic */ Class class$com$bbn$openmap$gui$WindowSupport$IntrnlFrm;

    public WindowSupport(Component content, String windowTitle) {
        super(content);
        this.setContent(content);
        this.title = windowTitle;
    }

    public WindowSupport(Component content, WSDisplay display) {
        super(content);
        this.setContent(content);
        this.setDisplay(display);
        if (display != null) {
            this.title = display.getTitle();
        }
    }

    public void setComponentLocation(Point p) {
        this.componentLocation = p;
    }

    public Point getComponentLocation() {
        return this.componentLocation;
    }

    public void setComponentSize(Dimension dim) {
        this.componentSize = dim;
    }

    public Dimension getComponentSize() {
        return this.componentSize;
    }

    public void componentResized(ComponentEvent e) {
        Component source = (Component)e.getSource();
        this.setComponentSize(source.getSize());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentResized(e);
        }
    }

    public void componentMoved(ComponentEvent e) {
        this.setComponentLocation(((Component)e.getSource()).getLocation());
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentMoved(e);
        }
    }

    public void componentShown(ComponentEvent e) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentShown(e);
        }
    }

    public void componentHidden(ComponentEvent e) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            ((ComponentListener)it.next()).componentHidden(e);
        }
        Component source = (Component)e.getSource();
        if (this.display == source) {
            this.cleanUp();
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == KillWindowCmd) {
            this.killWindow();
        } else if (command == DisplayWindowCmd) {
            this.displayInWindow();
        }
    }

    protected void finalize() {
        if (Debug.debugging("gc")) {
            Debug.output("WindowSupport being gc'd");
        }
    }

    public void setTitle(String tle) {
        this.title = tle;
        if (this.display != null) {
            this.display.setTitle(tle);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setContent(Component comp) {
        if (this.content instanceof ComponentListener) {
            this.removeComponentListener((ComponentListener)((Object)this.content));
        }
        this.content = comp;
        if (this.display != null) {
            this.display.setContent(comp);
        }
        if (this.content instanceof ComponentListener) {
            this.addComponentListener((ComponentListener)((Object)this.content));
        }
    }

    public Component getContent() {
        return this.content;
    }

    public void setMaxSize(int width, int height) {
        this.maxHeight = height;
        this.maxWidth = width;
    }

    protected WSDisplay createDisplay(Frame owner) {
        Class wTypeClass;
        Container wsd = this.persistentDisplayType == null && Environment.getBoolean("openmap.UseInternalFrames") ? new IntrnlFrm(this.title) : ((wTypeClass = this.persistentDisplayType == null ? WindowSupport.getDefaultWindowSupportDisplayType() : this.persistentDisplayType) == (class$com$bbn$openmap$gui$WindowSupport$Dlg == null ? (class$com$bbn$openmap$gui$WindowSupport$Dlg = WindowSupport.class$("com.bbn.openmap.gui.WindowSupport$Dlg")) : class$com$bbn$openmap$gui$WindowSupport$Dlg) ? new Dlg(owner, this.title) : (wTypeClass == (class$com$bbn$openmap$gui$WindowSupport$IntrnlFrm == null ? (class$com$bbn$openmap$gui$WindowSupport$IntrnlFrm = WindowSupport.class$("com.bbn.openmap.gui.WindowSupport$IntrnlFrm")) : class$com$bbn$openmap$gui$WindowSupport$IntrnlFrm) ? new IntrnlFrm(this.title) : new Frm(this.title)));
        this.setDisplay((WSDisplay)((Object)wsd));
        return wsd;
    }

    public static Class getDefaultWindowSupportDisplayType() {
        return defaultWindowSupportDisplayType;
    }

    public static void setDefaultWindowSupportDisplayType(Class defaultWindowSupportDisplayType) {
        WindowSupport.defaultWindowSupportDisplayType = defaultWindowSupportDisplayType;
    }

    public void setDisplay(WSDisplay dis) {
        if (this.display != null) {
            this.display.removeComponentListener(this);
        }
        this.display = dis;
        if (this.display != null) {
            this.display.addComponentListener(this);
            this.display.setContent(this.modifyContent(this.content));
        }
    }

    public Component modifyContent(Component comp) {
        return comp;
    }

    public WSDisplay getDisplay() {
        return this.display;
    }

    public void displayInWindow() {
        this.displayInWindow(null);
    }

    public void displayInWindow(Frame owner) {
        Dimension dim = this.getComponentSize();
        if (dim != null) {
            this.content.setSize(dim);
        }
        this.displayInWindow(owner, -1, -1, -1, -1);
    }

    public void displayInWindow(int x, int y, int width, int height) {
        this.displayInWindow(null, x, y, width, height);
    }

    public void displayInWindow(Frame owner, int x, int y, int width, int height) {
        Point loc;
        if (this.content == null) {
            Debug.message("windowsupport", "WindowSupport asked to display window with null content");
            return;
        }
        if (x < 0 && y < 0 && (loc = this.getComponentLocation()) != null) {
            x = (int)loc.getX();
            y = (int)loc.getY();
        }
        if (this.display == null) {
            this.display = this.createDisplay(owner);
        }
        Container displayWindow = this.display.getWindow();
        this.checkBounds(displayWindow, x, y, width, height);
        this.display.show(x, y);
        this.setComponentLocation(displayWindow.getLocation());
        this.setComponentSize(displayWindow.getSize());
    }

    protected void checkBounds(Component comp, int x, int y, int width, int height) {
        if (comp != null) {
            if (width <= 0) {
                width = comp.getWidth();
            }
            if (this.maxWidth > 0 && width > this.maxWidth) {
                width = this.maxWidth;
            }
            if (height <= 0) {
                height = comp.getHeight();
            }
            if (this.maxHeight > 0 && height > this.maxHeight) {
                height = this.maxHeight;
            }
            comp.setBounds(x, y, width, height);
        }
    }

    protected static void setDefaultPosition(Component comp) {
        int w = comp.getWidth();
        int h = comp.getHeight();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        Debug.message("basic", "Screen dimensions are " + d);
        int x = d.width / 2 - w / 2;
        int y = d.height / 2 - h / 2;
        if (Debug.debugging("basic")) {
            Debug.output("Setting PLG frame X and Y from properties to " + x + " " + y);
        }
        comp.setBounds(x, y, w, h);
    }

    public void killWindow() {
        ComponentEvent ce = null;
        if (this.display != null) {
            ce = this.display.kill();
        }
        if (ce != null) {
            this.componentHidden(ce);
        }
    }

    protected void cleanUp() {
        if (this.display != null) {
            this.persistentDisplayType = this.display.getClass();
            WSDisplay wsd = this.display;
            this.setDisplay(null);
            wsd.dispose();
        }
    }

    public void addComponentListener(ComponentListener l) {
        this.addListener(l);
    }

    public void removeComponentListener(ComponentListener l) {
        this.removeListener(l);
    }

    public Container getWindow() {
        if (this.display != null) {
            return this.display.getWindow();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class Frm
    extends JFrame
    implements WSDisplay {
        public Frm(String title) {
            super(title);
            this.setLocation(-1, -1);
        }

        public Frm(String title, boolean undecorated) {
            super(title);
            this.setUndecorated(undecorated);
            this.setLocation(-1, -1);
        }

        public Container getWindow() {
            return this;
        }

        public ComponentEvent kill() {
            this.setVisible(false);
            return new ComponentEvent(this, 103);
        }

        public void setContent(Component content) {
            Container cp = this.getContentPane();
            cp.removeAll();
            cp.add(content);
            this.pack();
        }

        public Dimension getContentSize() {
            return this.getContentPane().getSize();
        }

        public void show(int x, int y) {
            if (!this.isVisible()) {
                Window owner = this.getOwner();
                if (x <= 0 && y <= 0) {
                    if (owner != null) {
                        this.setLocationRelativeTo(owner);
                    } else if (owner == null) {
                        WindowSupport.setDefaultPosition(this);
                    }
                }
                super.setVisible(true);
            }
            this.toFront();
        }
    }

    public static class Dlg
    extends JDialog
    implements WSDisplay {
        public Dlg(Frame owner, String title) {
            super(owner, title);
            Debug.message("windows", "WindowSupport creating frame");
        }

        public Container getWindow() {
            return this;
        }

        public ComponentEvent kill() {
            this.setVisible(false);
            return new ComponentEvent(this, 103);
        }

        public void setContent(Component content) {
            Container cp = this.getContentPane();
            cp.removeAll();
            cp.add(content);
            this.pack();
        }

        public Dimension getContentSize() {
            return this.getContentPane().getSize();
        }

        public void show(int x, int y) {
            if (!this.isVisible()) {
                Window owner = this.getOwner();
                if (x <= 0 && y <= 0) {
                    if (owner != null) {
                        this.setLocationRelativeTo(owner);
                    } else if (owner == null) {
                        WindowSupport.setDefaultPosition(this);
                    }
                }
            }
            super.setVisible(true);
        }
    }

    public static class IntrnlFrm
    extends JInternalFrame
    implements WSDisplay {
        public IntrnlFrm(String title) {
            super(title, true, true, true, true);
            this.setOpaque(true);
            JLayeredPane desktop = Environment.getInternalFrameDesktop();
            Debug.message("windows", "WindowSupport creating internal frame");
            if (desktop != null) {
                desktop.remove(this);
                desktop.add((Component)this, JLayeredPane.PALETTE_LAYER);
            } else {
                Debug.output("WindowSupport:  No desktop set for internal frame");
            }
        }

        public Container getWindow() {
            return this;
        }

        public ComponentEvent kill() {
            this.setVisible(false);
            return new ComponentEvent(this, 103);
        }

        public void setContent(Component content) {
            Container cp = this.getContentPane();
            cp.add(content);
            this.pack();
        }

        public Dimension getContentSize() {
            return this.getContentPane().getSize();
        }

        public void show(int x, int y) {
            if (!this.isVisible()) {
                super.show();
            }
            this.toFront();
        }
    }

    public static interface WSDisplay {
        public void setTitle(String var1);

        public String getTitle();

        public Container getWindow();

        public void setContent(Component var1);

        public void show(int var1, int var2);

        public ComponentEvent kill();

        public void dispose();

        public Dimension getContentSize();

        public void addComponentListener(ComponentListener var1);

        public void removeComponentListener(ComponentListener var1);
    }
}

