/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.event.CenterEvent;
import com.bbn.openmap.event.CenterListener;
import com.bbn.openmap.event.CenterSupport;
import com.bbn.openmap.gui.CoordPanel;
import com.bbn.openmap.gui.DMSCoordPanel;
import com.bbn.openmap.gui.MGRSCoordPanel;
import com.bbn.openmap.gui.OMComponentPanel;
import com.bbn.openmap.gui.UTMCoordPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class CombinedCoordPanel
extends OMComponentPanel
implements Serializable,
ActionListener,
CenterListener {
    protected transient JButton closebutton;
    protected transient JButton applybutton;
    protected transient JTabbedPane tabPane;
    protected transient CoordPanel coordPanel;
    protected transient DMSCoordPanel dmsPanel;
    protected transient UTMCoordPanel utmPanel;
    protected transient MGRSCoordPanel mgrsPanel;
    protected transient CenterSupport centerDelegate;
    public static final String CloseCmd = "Close";
    static /* synthetic */ Class class$com$bbn$openmap$gui$CombinedCoordPanel;

    public CombinedCoordPanel() {
        this((ActionListener)null);
    }

    public CombinedCoordPanel(ActionListener closeButtonListener) {
        this.setup(this.i18n.get(class$com$bbn$openmap$gui$CombinedCoordPanel == null ? (class$com$bbn$openmap$gui$CombinedCoordPanel = CombinedCoordPanel.class$("com.bbn.openmap.gui.CombinedCoordPanel")) : class$com$bbn$openmap$gui$CombinedCoordPanel, "defaultComment", "Set Center of Map to Coordinates:"), closeButtonListener);
    }

    public CombinedCoordPanel(String comment, ActionListener closeButtonListener) {
        this.setup(comment, closeButtonListener);
    }

    protected void setup(String comment, ActionListener closeButtonListener) {
        this.centerDelegate = new CenterSupport(this);
        this.addCenterListener(this);
        this.setLayout(new BoxLayout(this, 1));
        JPanel titlePanel = new JPanel();
        titlePanel.setLayout(new BoxLayout(titlePanel, 0));
        JLabel clarification = new JLabel(comment);
        titlePanel.add(clarification);
        this.add(titlePanel);
        this.coordPanel = new CoordPanel(this.centerDelegate);
        this.dmsPanel = new DMSCoordPanel(this.centerDelegate);
        this.utmPanel = new UTMCoordPanel(this.centerDelegate);
        this.mgrsPanel = new MGRSCoordPanel(this.centerDelegate);
        this.tabPane = new JTabbedPane();
        String locText = this.i18n.get(class$com$bbn$openmap$gui$CombinedCoordPanel == null ? (class$com$bbn$openmap$gui$CombinedCoordPanel = CombinedCoordPanel.class$("com.bbn.openmap.gui.CombinedCoordPanel")) : class$com$bbn$openmap$gui$CombinedCoordPanel, "tabPane.decdeg", "Dec Deg");
        this.tabPane.addTab(locText, this.coordPanel);
        locText = this.i18n.get(class$com$bbn$openmap$gui$CombinedCoordPanel == null ? (class$com$bbn$openmap$gui$CombinedCoordPanel = CombinedCoordPanel.class$("com.bbn.openmap.gui.CombinedCoordPanel")) : class$com$bbn$openmap$gui$CombinedCoordPanel, "tabPane.dms", "DMS");
        this.tabPane.addTab(locText, this.dmsPanel);
        locText = this.i18n.get(class$com$bbn$openmap$gui$CombinedCoordPanel == null ? (class$com$bbn$openmap$gui$CombinedCoordPanel = CombinedCoordPanel.class$("com.bbn.openmap.gui.CombinedCoordPanel")) : class$com$bbn$openmap$gui$CombinedCoordPanel, "tabPane.utm", "UTM");
        this.tabPane.addTab(locText, this.utmPanel);
        locText = this.i18n.get(class$com$bbn$openmap$gui$CombinedCoordPanel == null ? (class$com$bbn$openmap$gui$CombinedCoordPanel = CombinedCoordPanel.class$("com.bbn.openmap.gui.CombinedCoordPanel")) : class$com$bbn$openmap$gui$CombinedCoordPanel, "tabPane.mgrs", "MGRS");
        this.tabPane.addTab(locText, this.mgrsPanel);
        this.add(this.tabPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        locText = this.i18n.get(class$com$bbn$openmap$gui$CombinedCoordPanel == null ? (class$com$bbn$openmap$gui$CombinedCoordPanel = CombinedCoordPanel.class$("com.bbn.openmap.gui.CombinedCoordPanel")) : class$com$bbn$openmap$gui$CombinedCoordPanel, "applybutton", "Apply");
        this.applybutton = new JButton(locText);
        this.applybutton.addActionListener(this);
        buttonPanel.add(this.applybutton);
        if (closeButtonListener != null) {
            locText = this.i18n.get(class$com$bbn$openmap$gui$CombinedCoordPanel == null ? (class$com$bbn$openmap$gui$CombinedCoordPanel = CombinedCoordPanel.class$("com.bbn.openmap.gui.CombinedCoordPanel")) : class$com$bbn$openmap$gui$CombinedCoordPanel, "closebutton", CloseCmd);
            this.closebutton = new JButton(locText);
            this.closebutton.setActionCommand(CloseCmd);
            this.closebutton.addActionListener(closeButtonListener);
            buttonPanel.add(this.closebutton);
        }
        this.add(buttonPanel);
    }

    public LatLonPoint getLatLon() {
        return this.coordPanel.getLatLon();
    }

    public void setLatLon(LatLonPoint llpoint) {
        this.coordPanel.setLatLon(llpoint);
        this.dmsPanel.setLatLon(llpoint);
        this.utmPanel.setLatLon(llpoint);
        this.mgrsPanel.setLatLon(llpoint);
    }

    public boolean setCenter() {
        return ((CoordPanel)this.tabPane.getSelectedComponent()).setCenter();
    }

    public void actionPerformed(ActionEvent e) {
        boolean allOK;
        if (e.getSource() == this.applybutton && !(allOK = this.setCenter())) {
            this.setLatLon(null);
        }
    }

    public void addCenterListener(CenterListener listener) {
        this.centerDelegate.addCenterListener(listener);
    }

    public void removeCenterListener(CenterListener listener) {
        this.centerDelegate.removeCenterListener(listener);
    }

    public void center(CenterEvent centerEvent) {
        this.setLatLon(new LatLonPoint(centerEvent.getLatitude(), centerEvent.getLongitude()));
    }

    public void findAndInit(Object someObj) {
        if (someObj instanceof CenterListener) {
            this.addCenterListener((CenterListener)someObj);
        }
    }

    public void findAndUndo(Object someObj) {
        if (someObj instanceof CenterListener) {
            this.removeCenterListener((CenterListener)someObj);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

