/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader.netmap;

import com.bbn.openmap.graphicLoader.netmap.NodeColor;
import com.bbn.openmap.omGraphics.OMPoint;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public class Node
extends OMPoint
implements ActionListener,
FocusListener {
    public static final int DEFAULT_LENGTH = 10;
    public static final int DEFAULT_WIDTH = 10;
    public static final int DEFAULT_RADIUS = 5;
    public static Color STATUS_UP = Color.green;
    public static Color STATUS_DOWN = Color.red;
    public static Color STATUS_UNKNOWN = Color.yellow;
    protected String label;
    protected int index;
    protected Color color = null;
    protected int posX = 0;
    protected int posY = 0;
    protected String posLat = null;
    protected String posLon = null;
    protected double gpsTime = 0.0;
    protected int length = 0;
    protected int width = 0;
    protected int menu = 0;
    protected int shape = 0;
    protected boolean localhost = false;

    public Node(String label, int index, int shape, int menu, int color) {
        this.label = label;
        this.index = index;
        this.shape = shape;
        this.menu = menu;
        this.color = NodeColor.colorOf(color);
        this.initOM();
    }

    private void initOM() {
        this.setOval(true);
        this.setRadius(5);
        this.setRenderType(1);
        this.setFillPaint(this.color);
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.getLabel();
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public Color getColor() {
        return this.color;
    }

    public void setStatus(int color) {
        this.color = NodeColor.colorOf(color);
        this.setFillPaint(this.color);
    }

    public int getStatus() {
        return NodeColor.valueOf(this.color);
    }

    public void setTime(double time) {
        this.gpsTime = time;
    }

    public double getTime() {
        return this.gpsTime;
    }

    public void setShape(int shape) {
        this.shape = shape;
    }

    public void moveTo(int newX, int newY) {
        if (this.getRenderType() == 2) {
            this.setX(newX);
            this.setY(newY);
        }
    }

    public void moveTo(float newLat, float newLon) {
        if (this.getRenderType() == 1) {
            this.setLat(newLat);
            this.setLon(newLon);
        }
    }

    public void setLocalhost(boolean value) {
        this.localhost = value;
    }

    public boolean isLocalhost() {
        return this.localhost;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    public void actionPerformed(ActionEvent ae) {
    }
}

