/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader.netmap;

import com.bbn.openmap.Layer;
import com.bbn.openmap.graphicLoader.MMLGraphicLoader;
import com.bbn.openmap.graphicLoader.netmap.Line;
import com.bbn.openmap.graphicLoader.netmap.LineCache;
import com.bbn.openmap.graphicLoader.netmap.NetMapConnector;
import com.bbn.openmap.graphicLoader.netmap.NetMapConstants;
import com.bbn.openmap.graphicLoader.netmap.NetMapEvent;
import com.bbn.openmap.graphicLoader.netmap.NetMapListener;
import com.bbn.openmap.graphicLoader.netmap.Node;
import com.bbn.openmap.graphicLoader.netmap.NodeCache;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.plugin.PlugIn;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;

public class NetMapGraphicLoader
extends MMLGraphicLoader
implements NetMapListener,
NetMapConstants {
    protected OMGraphicList omList = null;
    private NetMapConnector connector = null;
    private NodeCache nodeList = new NodeCache();
    private LineCache lineList = new LineCache();
    protected boolean DEBUG = Debug.debugging("netmap");
    protected String localhostIP = null;
    protected boolean toolTipUp = false;

    public NetMapGraphicLoader() {
        this.nodeList = new NodeCache();
        this.lineList = new LineCache();
        try {
            this.localhostIP = InetAddress.getLocalHost().getHostAddress();
            if (this.DEBUG) {
                Debug.output("NetMapGraphicLoader running on: " + this.localhostIP);
            }
        }
        catch (UnknownHostException uhe) {
            this.localhostIP = null;
        }
    }

    public NetMapGraphicLoader(NetMapConnector nmc) {
        this();
        this.setNetMapConnector(nmc);
    }

    public void setNetMapConnector(NetMapConnector nmc) {
        if (this.connector != null) {
            this.connector.removeNetMapListener(this);
        }
        this.connector = nmc;
        if (this.connector != null) {
            this.connector.addNetMapListener(this);
        }
    }

    public NetMapConnector getNetMapConnector() {
        return this.connector;
    }

    public void catchEvent(NetMapEvent nme) {
        if (this.DEBUG) {
            Debug.output(nme.getProperties().toString());
        }
        this.processEventProperties(nme.getProperties());
    }

    private void setNodePositionFromEventProps(Node node, Properties eventProps) {
        String geo = eventProps.getProperty("lat");
        if (geo != null) {
            try {
                node.setLat(Float.parseFloat(geo));
                node.posLat = geo;
            }
            catch (Exception e) {
                Debug.error("NetMapGraphicLoader: " + geo + " is not a valid latitude value.");
            }
        }
        if ((geo = eventProps.getProperty("lon")) != null) {
            try {
                node.setLon(Float.parseFloat(geo));
                node.posLon = geo;
            }
            catch (Exception e) {
                Debug.error("NetMapGraphicLoader: " + geo + " is not a valid longitude value.");
            }
        }
    }

    protected void processEventProperties(Properties eventProps) {
        String cmd = eventProps.getProperty("cmd");
        int index = PropUtils.intFromProperties(eventProps, "index", Integer.MIN_VALUE);
        if (cmd.equals("nobj")) {
            int shape = PropUtils.intFromProperties(eventProps, "shape", Integer.MIN_VALUE);
            if (index == Integer.MIN_VALUE) {
                Debug.error("NMGL: error parsing object index for node.");
                return;
            }
            Node node = this.nodeList.get(index);
            if (shape == 11) {
                String icon = eventProps.getProperty("icon");
                if (this.DEBUG) {
                    Debug.output("NetMapReader: jimage  " + icon);
                }
            }
            if (shape == -1) {
                if (node != null) {
                    this.lineList.del(node);
                    this.nodeList.del(node);
                }
            } else if (shape == 0 && node != null) {
                this.setNodePositionFromEventProps(node, eventProps);
                this.lineList.move(node);
                node.setTime(Double.parseDouble(eventProps.getProperty("time", "0")));
            } else {
                int status = PropUtils.intFromProperties(eventProps, "status", 0);
                int menu = PropUtils.intFromProperties(eventProps, "menu", 0);
                String label = eventProps.getProperty("label");
                if (label == null) {
                    label = eventProps.getProperty("index");
                }
                String ip = eventProps.getProperty("ip");
                boolean isLocalhost = false;
                if (ip != null && this.localhostIP != null) {
                    isLocalhost = this.localhostIP.equals(ip);
                    if (this.DEBUG) {
                        Debug.output("NetMapGraphicLoader displaying a node running on the localhost: " + this.localhostIP);
                    }
                }
                if (this.DEBUG) {
                    Debug.output("Creating node (" + label + ")");
                }
                try {
                    if (shape != Integer.MIN_VALUE) {
                        node = this.nodeList.add(label, index, shape, menu, status);
                        node.setLocalhost(isLocalhost);
                    }
                }
                catch (Exception e) {
                    Debug.error("NMGL: error creating node");
                }
                this.setNodePositionFromEventProps(node, eventProps);
            }
        } else if (cmd.equals("nobjstat")) {
            int status;
            if (index == Integer.MIN_VALUE) {
                Debug.error("NMGL: error parsing object index for status update.");
                return;
            }
            Node node = this.nodeList.get(index);
            if (node != null && (status = PropUtils.intFromProperties(eventProps, "status", Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                node.setStatus(status);
            }
        } else if (cmd.equals("lobjstat")) {
            int status;
            if (index == Integer.MIN_VALUE) {
                Debug.error("NMGL: error parsing line index for status update.");
                return;
            }
            Line line = this.lineList.get(index);
            if (line != null && (status = PropUtils.intFromProperties(eventProps, "status", Integer.MIN_VALUE)) != Integer.MIN_VALUE) {
                line.setStatus(status);
            }
        } else if (cmd.equals("lobj")) {
            if (index == Integer.MIN_VALUE) {
                Debug.error("NMGL: error parsing line index for link.");
                return;
            }
            Line line = this.lineList.get(index);
            int shape = PropUtils.intFromProperties(eventProps, "shape", Integer.MIN_VALUE);
            if (shape == -1) {
                this.lineList.del(index);
            } else {
                int status = PropUtils.intFromProperties(eventProps, "status", 0);
                int node1 = PropUtils.intFromProperties(eventProps, "lnode1", Integer.MIN_VALUE);
                int node2 = PropUtils.intFromProperties(eventProps, "lnode2", Integer.MIN_VALUE);
                if (node1 == Integer.MIN_VALUE || node2 == Integer.MIN_VALUE) {
                    Debug.error("NMGL: error parsing node indexes for link");
                    return;
                }
                Node n1 = this.nodeList.get(node1);
                Node n2 = this.nodeList.get(node2);
                if (n1 != null && n2 != null) {
                    this.lineList.add(String.valueOf(index), index, shape, status, n1, n2);
                } else if (this.DEBUG) {
                    Debug.output("NetMapGraphicLoader: can't create lobj, nodes are undefined");
                }
            }
        } else if (!cmd.equals("refresh") && !cmd.equals("update")) {
            if (cmd.equals("clear")) {
                if (this.nodeList != null) {
                    this.nodeList.flush();
                }
                if (this.lineList != null) {
                    this.lineList.flush();
                }
            } else if (this.DEBUG) {
                Debug.output("NMGL: received unused event: " + eventProps.toString());
            }
        }
        this.manageGraphics();
    }

    protected OMGraphicList getOMList() {
        Enumeration list;
        this.omList = new OMGraphicList();
        if (this.nodeList != null) {
            list = this.nodeList.elements();
            while (list != null && list.hasMoreElements()) {
                Node point = (Node)list.nextElement();
                point.setMatted(point.isLocalhost());
                this.omList.add(point);
            }
        }
        if (this.lineList != null) {
            list = this.lineList.elements();
            while (list != null && list.hasMoreElements()) {
                Line line = (Line)list.nextElement();
                if (line == null) continue;
                line.setPos();
                this.omList.add(line);
            }
        }
        if (this.DEBUG) {
            int size = this.omList.size();
            Debug.output("NMGL.getOMList(): created list with " + size + (size == 1 ? " graphic." : " graphics."));
        }
        return this.omList;
    }

    public Component getGUI() {
        if (this.connector != null) {
            return this.connector.getGUI();
        }
        return null;
    }

    public String getName() {
        return "NetMap";
    }

    public void manageGraphics() {
        if (this.receiver != null) {
            if (this.DEBUG) {
                Debug.output("NetMapConnector.update: Updating graphics.");
            }
            this.receiver.setList(this.getOMList());
        } else if (this.DEBUG) {
            Debug.output("NetMapConnector.update: no receiver to notify.");
        }
    }

    public boolean mouseMoved(MouseEvent e) {
        if (this.receiver instanceof PlugIn && this.omList != null) {
            Component comp;
            OMGraphic graphic = this.omList.getOMGraphicThatContains(e.getX(), e.getY());
            String label = null;
            if (graphic instanceof Node) {
                label = ((Node)graphic).getLabel();
            }
            if (this.receiver instanceof PlugIn && (comp = ((PlugIn)((Object)this.receiver)).getComponent()) instanceof Layer) {
                if (graphic != null && label != null) {
                    ((Layer)comp).fireRequestToolTip("Node " + label);
                    this.toolTipUp = true;
                } else if (this.toolTipUp) {
                    ((Layer)comp).fireHideToolTip();
                    this.toolTipUp = false;
                }
                return true;
            }
        }
        return false;
    }
}

