/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader;

import com.bbn.openmap.graphicLoader.AbstractGraphicLoader;
import com.bbn.openmap.graphicLoader.GLPoint;
import com.bbn.openmap.omGraphics.OMGraphicHandler;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AnimationTester
extends AbstractGraphicLoader {
    OMGraphicList nodes = new OMGraphicList();
    float factor = 1.0f;
    JPanel panel = null;
    String addCmd = "AddSpriteCommand";
    String clearCmd = "ClearSpriteCommand";
    String timerCmd = "TimerCommand";

    public void manageGraphics() {
        if (Debug.debugging("animationtester")) {
            Debug.output("AnimationTester.manageGraphics with " + this.nodes.size() + " node(s).");
        }
        Projection p = this.getProjection();
        Iterator it = this.nodes.iterator();
        while (it.hasNext()) {
            GLPoint point = (GLPoint)it.next();
            point.moveRandomly(this.factor);
            point.generate(p);
        }
        OMGraphicHandler receiver = this.getReceiver();
        if (receiver != null) {
            receiver.setList(this.nodes);
        }
    }

    public void addNode() {
        float ranLat = (float)(Math.random() * 180.0) - 90.0f;
        float ranLon = (float)(Math.random() * 360.0) - 180.0f;
        GLPoint point = new GLPoint(ranLat, ranLon, 5, true);
        point.setFillPaint(Color.red);
        this.nodes.add(point);
    }

    public void clearNodes() {
        this.nodes.clear();
    }

    public Component getGUI() {
        if (this.panel == null) {
            this.panel = new JPanel(new GridLayout(0, 1));
            JPanel buttonBox = new JPanel();
            JButton button = new JButton("Add Sprite");
            button.setActionCommand(this.addCmd);
            button.addActionListener(this);
            buttonBox.add(button);
            button = new JButton("Clear Sprites");
            button.setActionCommand(this.clearCmd);
            button.addActionListener(this);
            buttonBox.add(button);
            this.panel.add(buttonBox);
            JLabel label = new JLabel("Timer interval in seconds:");
            this.panel.add(label);
            JSlider slider = new JSlider(0, 0, 50, 20);
            Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
            dict.put(new Integer(10), new JLabel("1"));
            dict.put(new Integer(20), new JLabel("2"));
            dict.put(new Integer(30), new JLabel("3"));
            dict.put(new Integer(40), new JLabel("4"));
            dict.put(new Integer(50), new JLabel("5"));
            slider.setLabelTable(dict);
            slider.setPaintLabels(true);
            slider.setMajorTickSpacing(5);
            slider.setPaintTicks(true);
            slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent ce) {
                    JSlider slider2 = (JSlider)ce.getSource();
                    if (slider2.getValueIsAdjusting()) {
                        AnimationTester.this.manageGraphics();
                        float interval = ((float)slider2.getValue() + 0.01f) * 100.0f;
                        Debug.output("Animation Tester delay set to: " + interval / 1000.0f + " seconds");
                        AnimationTester.this.setUpdateInterval((int)interval);
                    }
                }
            });
            this.panel.add(slider);
            JCheckBox timerButton = new JCheckBox("Run Timer", this.getTimer().isRunning());
            timerButton.setActionCommand("TimerCommand");
            timerButton.addActionListener(this);
            this.panel.add(timerButton);
        }
        return this.panel;
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command == this.addCmd) {
            this.addNode();
            if (!this.getTimer().isRunning()) {
                this.manageGraphics();
            }
        } else if (command == this.clearCmd) {
            this.clearNodes();
            if (!this.getTimer().isRunning()) {
                this.manageGraphics();
            }
        } else if (command == "TimerCommand") {
            JCheckBox check = (JCheckBox)ae.getSource();
            if (check.isSelected()) {
                this.manageGraphics();
                this.getTimer().restart();
            } else {
                this.getTimer().stop();
            }
        } else {
            this.manageGraphics();
        }
    }
}

